<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSettings.isExtractSalesTaxFromPurchase && !entity.itsOwner.purchaseInvoice.omitTaxes && !entity.itsOwner.purchaseInvoice.vendor.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSettings.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSettings.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.purchaseInvoice.vendor.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.purchaseInvoice.vendor.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.purchaseInvoice.vendor.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<c:if test="${not empty entity.purchaseInvoiceLine}">
  <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.itsId}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${entity.purchaseInvoiceLine.itsCost}, ${srvI18n.getMsg('rest_was', reqVars.lang)}=${entity.purchaseInvoiceLine.theRest}"/>
  <c:if test="${empty entity.purchaseInvoiceLine.idBirth}">
    <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.idDatabaseBirth}-${entity.purchaseInvoiceLine.itsId}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.itsCost.toString(), dseparatorv, dgseparatorv, costPrecision, digitsInGroup)}, ${srvI18n.getMsg('theRest', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.theRest.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.pricePrecision, reqVars.digitsInGroup)}"/>
  </c:if>
  <c:if test="${not empty entity.purchaseInvoiceLine.idBirth}">
    <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.idDatabaseBirth}-${entity.purchaseInvoiceLine.idBirth}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.itsCost.toString(), dseparatorv, dgseparatorv, costPrecision, digitsInGroup)}, ${srvI18n.getMsg('theRest', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.theRest.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.pricePrecision, reqVars.digitsInGroup)}"/>
  </c:if>
</c:if>
<tr>
  <td>
    <label for="PurchaseReturnLinepurchaseInvoiceLineAppearanceVisible">${srvI18n.getMsg(fieldName, reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="PurchaseReturnLinepurchaseInvoiceLineAppearanceVisible" disabled type="text" value="${docLineAppr}" onchange="inputHasBeenChanged(this);">
      <input id="PurchaseReturnLinepurchaseInvoiceLineId" type="hidden" required name="PurchaseReturnLine.purchaseInvoiceLine" value="${entity.purchaseInvoiceLine.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('PurchaseInvoiceLine', 'PurchaseReturnLine', 'purchaseInvoiceLine', '&nmHnd=${param.nmHnd}&fltordPitsOwnerValId=${entity.itsOwner.purchaseInvoice.itsId}&fltordPitsOwnerOpr=eq&fltordPforcedFor=itsOwner&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('PurchaseReturnLinepurchaseInvoiceLine');">X</button>
    </div>
  </td>
</tr>
<c:if test="${isTaxable && isItemBasis && isAggrOnlyRate}">
  <c:set var="calcTotalFnNm" value="calculateTotalAndTaxForCost"/>
  <c:set var="calcCostFnNm" value="calculateCostTax"/>
  <c:set var="taxIncludedPar" value=",false"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && isAggrOnlyRate)}">
  <c:set var="calcTotalFnNm" value="calculateTotalForCost"/>
  <c:set var="calcCostFnNm" value="calculateCost"/>
  <c:set var="taxIncludedPar" value=""/>
</c:if>
<tr>
  <td>
    <label for="PurchaseReturnLine.itsCost">
      ${srvI18n.getMsg("itsCost", reqVars.lang)}
      <c:if test="${isTaxable}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.costPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsCost" value="0.0" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="PurchaseReturnLine.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.quantityPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="PurchaseReturnLineitsQuantity" name="PurchaseReturnLine.itsQuantity" value="${entity.itsQuantity}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('PurchaseReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="PurchaseReturnLineitsTotal">
      ${srvI18n.getMsg("subtotal", reqVars.lang)}
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="PurchaseReturnLineitsTotal" name="PurchaseReturnLine.subtotal" value="${entity.subtotal}" onchange="inputHasBeenChanged(this); ${calcCostFnNm}('PurchaseReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
      </label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input type="text" disabled id="PurchaseReturnLinetaxCategory" onchange="inputHasBeenChanged(this);"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && isAggrOnlyRate}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" disabled id="PurchaseReturnLineitsPercentage" class="autoNumSalTax" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" value="0.0" onchange="inputHasBeenChanged(this);calcTaxOchRate('PurchaseReturnLine', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="PurchaseReturnLinetotalTaxes" required name="PurchaseReturnLine.totalTaxes" class="autoNumSalTaxTot" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>
