<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSettings.isExtractSalesTaxFromSales && !entity.itsOwner.omitTaxes && !entity.itsOwner.customer.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSettings.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSettings.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.customer.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.customer.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.customer.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.serviceAppearanceVisible">${srvI18n.getMsg('service', reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <c:set var="invoiceLnItemId" value="${entity.getClass().simpleName}serviceId" scope="request"/>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}serviceAppearanceVisible" disabled="disabled" type="text" value="${entity.service.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}serviceId" required type="hidden" name="${entity.getClass().simpleName}.service" value="${entity.service.itsId}">
      <c:if test="${isTaxable && isItemBasis}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('ServiceToSale','${entity.getClass().simpleName}', 'service','&nmHnd=${param.nmHnd}&wdgPick=pickItemUomTax&mobile=${param.mobile}');">...</button>
      </c:if>
      <c:if test="${!(isTaxable && isItemBasis)}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('ServiceToSale','${entity.getClass().simpleName}', 'service','&nmHnd=${param.nmHnd}&mobile=${param.mobile}');">...</button>
      </c:if>
      <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}service');">X</button>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.unitOfMeasureAppearanceVisible">${srvI18n.getMsg('unitOfMeasure', reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}unitOfMeasureAppearanceVisible" disabled="disabled" type="text" value="${entity.unitOfMeasure.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}unitOfMeasureId" required type="hidden" name="${entity.getClass().simpleName}.unitOfMeasure" value="${entity.unitOfMeasure.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('UnitOfMeasure','${entity.getClass().simpleName}', 'unitOfMeasure','&nmHnd=${param.nmHnd}&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}unitOfMeasure');">X</button>
    </div>
  </td>
</tr>
<jsp:include page="inpSalesInvLnTmp.jsp"/>
