<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSettings.isExtractSalesTaxFromPurchase && !entity.itsOwner.omitTaxes && !entity.itsOwner.vendor.isForeigner}"/>
<c:set var="isItemBasis" value="${!reqVars.accSettings.salTaxIsInvoiceBase}"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSettings.salTaxUseAggregItBas}"/>
<c:if test="${entity.itsOwner.vendor.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.vendor.taxDestination.salTaxIsInvoiceBase}"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.vendor.taxDestination.salTaxUseAggregItBas}"/>
</c:if>
<c:if test="${isTaxable && isItemBasis && isAggrOnlyRate}">
  <c:set var="calcTotalFnNm" value="calculateTotalAndTaxForCost"/>
  <c:set var="calcCostFnNm" value="calculateCostTax"/>
  <c:set var="taxIncludedPar" value=",${entity.itsOwner.priceIncTax}"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && isAggrOnlyRate)}">
  <c:set var="calcTotalFnNm" value="calculateTotalForCost"/>
  <c:set var="calcCostFnNm" value="calculateCost"/>
  <c:set var="taxIncludedPar" value=""/>
</c:if>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.invItemAppearanceVisible">${srvI18n.getMsg('invItem', reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <c:set var="invoiceLnItemId" value="${entity.getClass().simpleName}invItemId"/>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}invItemAppearanceVisible" disabled="disabled" type="text" value="${entity.invItem.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}invItemId" required type="hidden" name="${entity.getClass().simpleName}.invItem" value="${entity.invItem.itsId}">
      <c:if test="${isTaxable && isItemBasis}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','${entity.getClass().simpleName}', 'invItem','&nmHnd=${param.nmHnd}&fltordPknownCostOpr1=isnotnull&fltordPforcedFor=knownCost&wdgPick=pickItemCostTax&mobile=${param.mobile}');">...</button>
      </c:if>
      <c:if test="${!(isTaxable && isItemBasis)}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','${entity.getClass().simpleName}', 'invItem','&nmHnd=${param.nmHnd}&fltordPknownCostOpr1=isnotnull&fltordPforcedFor=knownCost&wdgPick=pickItemCost&mobile=${param.mobile}');">...</button>
      </c:if>
      <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}invItem');">X</button>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.unitOfMeasureAppearanceVisible">${srvI18n.getMsg('unitOfMeasure', reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}unitOfMeasureAppearanceVisible" disabled="disabled" type="text" value="${entity.unitOfMeasure.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}unitOfMeasureId" required type="hidden" name="${entity.getClass().simpleName}.unitOfMeasure" value="${entity.unitOfMeasure.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('UnitOfMeasure','${entity.getClass().simpleName}', 'unitOfMeasure','&nmHnd=${param.nmHnd}&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}unitOfMeasure');">X</button>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsCost">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignPrice", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsCost", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && !entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.costPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsCostVisible" disabled value="${entity.foreignPrice}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsCost" name="${entity.getClass().simpleName}.foreignPrice" value="${entity.foreignPrice}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.costPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" id="${entity.getClass().simpleName}itsCostVisible" disabled value="${entity.itsCost}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsCost" name="${entity.getClass().simpleName}.itsCost" value="${entity.itsCost}"/> 
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input type="text" class="autoNum${reqVars.quantityPrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" required id="${entity.getClass().simpleName}itsQuantity" name="${entity.getClass().simpleName}.itsQuantity" value="${entity.itsQuantity}" onchange="inputHasBeenChanged(this); ${calcTotalFnNm}('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
    </div>
  </td>
</tr>
<c:if test="${!isTaxable || entity.itsOwner.priceIncTax}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" disabled id="${entity.getClass().simpleName}itsTotalVisible" value="${entity.foreignTotal}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" disabled id="${entity.getClass().simpleName}itsTotalVisible" value="${entity.itsTotal}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity['itsTotal']}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${!(!isTaxable || entity.itsOwner.priceIncTax)}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" disabled id="${entity.getClass().simpleName}itsTotalVisible" value="${entity.foreignSubtotal}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" disabled id="${entity.getClass().simpleName}itsTotalVisible" value="${entity.subtotal}" onchange="inputHasBeenChanged(this);"/> 
        <input type="hidden" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination}">
          <button type="button" id="${entity.getClass().simpleName}btnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'service/?nmHnd=srhAccSecure&nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&nmEnt=${entity.getClass().simpleName}&taxDestId=${entity.itsOwner.vendor.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input type="text" disabled id="${entity.getClass().simpleName}taxCategory" value="${entity.taxCategory.itsName}" onchange="inputHasBeenChanged(this);"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && isAggrOnlyRate}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination}">
            <c:set var="aggrOnlyPercent" value=""/>
          </c:if>
          <c:if test="${empty entity.taxCategory && empty entity.itsOwner.vendor.taxDestination}">
            <c:set var="aggrOnlyPercent" value="0.0"/>
          </c:if>
          <c:if test="${not empty entity.taxCategory}">
            <c:set var="aggrOnlyPercent" value="${entity.taxCategory.aggrOnlyPercent}"/>
          </c:if>
          <input type="text" disabled id="${entity.getClass().simpleName}itsPercentage" value="${aggrOnlyPercent}" class="autoNumSalTax" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" onchange="inputHasBeenChanged(this);calcTaxOchRate('${entity.getClass().simpleName}', '${reqVars.dseparatorv}', '${reqVars.dgseparatorv}'${taxIncludedPar});"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination}">
            <c:set var="totTaxes" value=""/>
          </c:if>
          <c:if test="${!(empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination)}">
            <c:set var="totTaxes" value="${entity.totalTaxes}"/>
          </c:if>
          <input type="text" id="${entity.getClass().simpleName}totalTaxes" required name="${entity.getClass().simpleName}.totalTaxes" class="autoNumSalTaxTot" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}" value="${totTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>

