<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:if test="${isTaxable}">
  <c:if test="${not empty taxDestination}">
    ${taxDestination.itsName}: ${srvI18n.getMsg("salTaxRoundMode", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxRoundMode, reqVars.lang)},
    ${srvI18n.getMsg("salTaxIsInvoiceBase", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxIsInvoiceBase, reqVars.lang)},
    ${srvI18n.getMsg("salTaxUseAggregItBas", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxUseAggregItBas, reqVars.lang)}
    <br>
  </c:if>
  <c:set var="taxesTl" value="0"/>
  ${srvI18n.getMsg("taxes", reqVars.lang)}:
  <c:forEach var="entity" items="${ownedListsMapEntry.value}" varStatus="vs">
    <c:if test="${!vs.isFirst()}">; </c:if>
    ${entity.tax.itsName}
    <c:if test="${reqVars.accSettings.salTaxIsInvoiceBase}">
      * ${utlJsp.printNumber(entity.taxableInvBas.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.pricePrecision, reqVars.digitsInGroup)} =
    </c:if>
    ${utlJsp.printNumber(entity.itsTotal.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.pricePrecision, reqVars.digitsInGroup)}
    <c:set var="taxesTl" value="${entity.itsTotal + taxesTl}"/>
  </c:forEach>
  <br> <b>${srvI18n.getMsg("totalTaxes", reqVars.lang)}: ${utlJsp.printNumber(taxesTl.toString(), reqVars.dseparatorv, reqVars.dgseparatorv, reqVars.pricePrecision, reqVars.digitsInGroup)} ${reqVars.curSign}</b>
</c:if>
