<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<jsp:useBean id="now" class="java.util.Date" />
<dialog id="frmPriceListDlg" class="dlg" oncancel="return false;">
  <div class="form-std">
    <div class="dialog-title">
      ${srvI18n.getMsg("priceList", reqVars.lang)}
      <button onclick="closeDlgCareful('frmPriceList')" class="btn-close">x</button>
    </div>
    <form id="frmPriceListFrm" action="reportCsv/" method="GET" target="_blank">
      <input type="hidden" name="nmHnd" value="hndlCsvWriter">
      <input type="hidden" name="fileName" value="priceList${srvDate.toDdMmYy(now, null)}">
      <table class="tbl-fieldset">
        <tr>
          <td>
            <label for="priceCategory">${srvI18n.getMsg("priceCategory", reqVars.lang)}</label>
          </td>
          <td>
            <div class="input-line">
              <input class="picked-appearence" id="priceCategoryAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
              <input id="priceCategoryId" type="hidden" name="priceCategory">
              <button type="button" class="btn" onclick="openEntityPicker('PriceCategory','', 'priceCategory', '&nmHnd=handlerEntityRequest&mobile=${param.mobile}');">...</button>
              <button type="button" class="btn" onclick="clearSelectedEntity('priceCategory');">X</button>
            </div>
          </td>
        </tr>
        <tr>
          <td>
            <label for="csvMethod">${srvI18n.getMsg("csvMethod", reqVars.lang)}</label>
          </td>
          <td>
            <div class="input-line">
              <input class="picked-appearence" id="csvMethodAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
              <input id="csvMethodId" type="hidden" name="csvMethod">
              <button type="button" class="btn" onclick="openEntityPicker('CsvMethod','', 'csvMethod', '&nmHnd=handlerEntityRequest&mobile=${param.mobile}');">...</button>
              <button type="button" class="btn" onclick="clearSelectedEntity('csvMethod');">X</button>
            </div>
          </td>
        </tr>
        <tr>
          <td>
            <label for="unavailablePrice">${srvI18n.getMsg("unavailablePrice", reqVars.lang)}:</label>
          </td>
          <td>
            <input type="text" name="unavailablePrice" onchange="inputHasBeenChanged(this);"/> 
          </td>
        </tr>
        <tr>
          <td>
            <label for="optimisticQuantity">${srvI18n.getMsg("optimisticQuantity", reqVars.lang)}:</label>
          </td>
          <td>
            <input type="text" name="optimisticQuantity" onchange="inputHasBeenChanged(this);"/> 
          </td>
        </tr>
      </table>
      <div class="form-actions">
        <button type="button" onclick="submitFormForNewWindow('frmPriceListFrm', false);">${srvI18n.getMsg("Report", reqVars.lang)}</button>
        <button type="button" onclick="closeDlgCareful('frmPriceList');">${srvI18n.getMsg("Close", reqVars.lang)}</a>
      </div>
    </form>
  </div>
</dialog>
