<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>


<!--Modal I18N preferences-->
<div class="modal fade" id="i18nMdl" tabindex="-1" role="dialog" aria-labelledby="i18nMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="i18nMdlLabel"><span class="oi oi-globe" aria-hidden="true"></span> ${srvI18n.getMsg("changeLangPreferences", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="servicePublic${filterUrlFrm}" method="GET">
          <input type="hidden" name="nmRnd" value="webstore">
          <input type="hidden" name="nmPrc" value="PrcWebstorePage">
          <input type="hidden" name="nmHnd" value="hndPubWebStrTr">
          <input type="hidden" name="catalogId" value="${catalogId}">
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("lang", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="lang" class="form-control">
                <c:forEach var="it" items="${reqVars.languages}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.lang eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${it.itsName}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="dseparator"  class="form-control">
                <c:forEach var="it" items="${reqVars.decimalSeparators}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.dseparator eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalGroupSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="dgseparator"  class="form-control">
                <c:forEach var="it" items="${reqVars.decimalGroupSeparators}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.dgseparator eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("digitsInGroup", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="digitsInGroup"  class="form-control">
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 2}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="2" ${itmSel}>2 ${srvI18n.getMsg("Indian", reqVars.lang)}</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 3}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="3" ${itmSel}>3</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digitsInGroup == 4}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="4" ${itmSel}>4</option>
              </select>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

