<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<jsp:include page="webstoreStart.jsp"/>

<c:set var="filterUrl" value=""/>
<c:forEach items="${param}" var="par">
  <c:if test="${par.key.startsWith('flt')}">
    <c:set var="filterUrl" value="${filterUrl}&${par.key}=${par.value}"/>
  </c:if>
  <c:if test="${par.key eq 'page'}">
    <c:set var="filterUrl" value="${filterUrl}&${par.key}=${par.value}"/>
  </c:if>
</c:forEach>
<c:set var="catalogId" value="${param.catalogId}"/>
<div class="card cat-name">
  <div class="card-header">
    <a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${param.catalogId}${filterUrl}">${param.listFltAp}</a>
  </div>
</div>

<div class="py-3 bg-light">
  <div class="row">
    <c:if test="${not empty itemImage}">
      <div class="col-12 col-md-6 col-lg-4">
        <img class="img-fluid" src="${itemImage.stringValue1}">
      </div>
    </c:if>
    <c:if test="${not empty itemImage}">
      <div class="col-12 col-md-6 col-lg-8">
    </c:if>
    <c:if test="${empty itemImage}">
      <div class="col-12">
    </c:if>
      <h5>
        <c:if test="${not empty itemPrice}">
          <b><span class="autoNum${reqVars.pricePrecision}" data-a-sep="${reqVars.dgseparatorv}" data-a-dec="${reqVars.dseparatorv}">${itemPrice.itsPrice}</span> ${reqVars.accSettings.currency.itsName}</b>
        </c:if>
        ${itemSpecLst.get(0).item.itsName}
      </h5>
      <p>
        ${utlTradeJsp.itemSpecificsStr(reqVars, itemSpecLst)}
      </p>
    </div>
  </div>
</div>

<div class="py-1 text-center bg-light">
  <c:if test="${empty cartItem && not empty itemPrice}">
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#cartAddMdl" onclick="setCartItem(0, ${itemPrice.item.itsId}, '${itemPrice.item.itsName}', ${itemPrice.itsPrice}, 1)">${srvI18n.getMsg("buy_it", reqVars.lang)}</button>
  </c:if>
  <c:if test="${not empty cartItem}">
    <button type="button" class="btn btn-primary" onclick="$('#cartMdl').modal('toggle');">${srvI18n.getMsg("open_cart", reqVars.lang)} <span class="badge badge-secondary">${shoppingCart.totalItems}</span></button>
  </c:if>
</div>

<div class="py-3 bg-light">
  <div class="text-center text-muted">
    <h4>${srvI18n.getMsg("item_specifics", reqVars.lang)}</h4>
  </div>
  <div class="specifics">
    <div class="row">
      <c:forEach var="itSp" items="${itemSpecLst}">
        <div class="col-12 col-md-5">
          <b>${itSp.specifics.itsName}: </b>
        </div>
        <c:if test="${itSp.specifics.itsType eq 'TEXT'}">
          <div class="col-12 col-md-7">
            ${itSp.stringValue1}
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'BIGDECIMAL'}">
          <div class="col-12 col-md-7">
            ${itSp.numericValue1}
            <c:if test="${not empty itSp.stringValue1}">
              ${itSp.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'INTEGER'}">
          <div class="col-12 col-md-7">
            ${itSp.longValue1}
            <c:if test="${not empty itSp.stringValue1}">
              ${itSp.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'CHOOSEABLE_SPECIFICS'}">
          <div class="col-12 col-md-7">
            ${itSp.stringValue1}
          </div>
        </c:if>
      </c:forEach>
    </div>
  </div>
</div>

<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'FILE_EMBEDDED' && itSp.stringValue1.endsWith('html')}">
    <c:set var="embhtmlnm" value="${utlJsp.evalFileNameWithoutExtension(itSp.stringValue1)}"/>
    <div id="${embhtmlnm}" class="py-3 bg-light embed-html">
    </div>
    <script> $( "#${embhtmlnm}" ).load( "${itSp.stringValue1} #container" ); </script>
  </c:if>
</c:forEach>

<c:set var="currGroup" value=""/>
<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'IMAGE_IN_SET' && not empty itSp.specifics.itsGroop}">
    <c:if test="${empty currGroup || itSp.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
          </div>
        </div>
      </c:if>
      <c:set var="currGroup" value="${itSp.specifics.itsGroop}"/>
      <div class="album py-3 bg-light">
      <c:if test="${not empty itSp.stringValue4}">
        <div class="text-center text-muted">
          <h4>${itSp.stringValue4}</h4>
        </div>
      </c:if>
      <div class="row">
    </c:if>
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card mb-4 box-shadow">
        <img class="card-img-top" src="${itSp.stringValue1}" alt="Card image cap">
        <c:if test="${not empty itSp.stringValue3}">
          <div class="card-body">
            <p class="card-text">${itSp.stringValue3}</p>
          </div>
        </c:if>
      </div>
    </div>
  </c:if>
  <c:if test="${itSp.specifics.itsType ne 'IMAGE_IN_SET' || empty itSp.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
        </div>
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
    </div>
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'FILE' && not empty itSp.specifics.itsGroop}">
    <c:if test="${empty currGroup || itSp.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
        </div>
      </c:if>
      <c:set var="currGroup" value="${itSp.specifics.itsGroop}"/>
      <div class="py-3 bg-light text-center text-muted">
      <c:if test="${not empty itSp.stringValue4}">
        <h4>${itSp.stringValue4}</h4>
      </c:if>
    </c:if>
    <h6><a href="${itSp.stringValue1}">${itSp.stringValue3}</a></h6>
  </c:if>
  <c:if test="${itSp.specifics.itsType ne 'FILE' || empty itSp.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<jsp:include page="webstoreI18n.jsp"/>

<jsp:include page="webstoreCart.jsp"/>

<jsp:include page="webstoreEnd.jsp"/>
