<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="static/img/favicon.png">

    <title>Beigesoft™ Web Store</title>
    <link href="static/css/bootstrap.min.css" rel="stylesheet">
    <link href="static/css/bootstrap-grid.min.css" rel="stylesheet">
    <link href="static/css/bootstrap-reboot.min.css" rel="stylesheet">
    <link href="static/css/theme.css" rel="stylesheet">
    <link href="static/css/open-iconic-bootstrap.min.css" rel="stylesheet">
    <link href="static/css/flag-icon.min.css" rel="stylesheet">
    <script src="static/js/jquery-3.3.1.min.js"></script>
    <script src="static/js/beige.webstore.js"></script>
    <script src="static/js/popper.min.js"></script>
    <script src="static/js/bootstrap.min.js"></script>
    <script src="static/js/autoNumeric.js"></script>
    <script type="text/javascript">
    jQuery(function($) {
        $('.autoNum').autoNumeric('init');
        $('.autoNum0').autoNumeric('init', {mDec: '0'});
    });
    </script>
  </head>

  <body>

    <header id="top">
    <nav class="navbar navbar-expand-sm navbar-dark bg-dark fixed-top">
      <c:if test="${reqVars.tradingSettings.isShowLogo}">
        <a href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId" class="navbar-brand navbar-brand-img"><img src="static/img/logo-web-store.png"></a>
      </c:if>
      
      <a class="navbar-brand" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage">${utlTradeJsp.webstoreName(reqVars.tradingSettings, reqVars.i18nWebStoreList, reqVars.lang)}</a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar1" aria-controls="navbar1" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div id="navbar1" class="collapse navbar-collapse">
        <ul class="navbar-nav mr-auto">
            <c:forEach var="cat1l" items="${catalogs}" varStatus="status">
              <c:if test="${cat1l.subcatalogs.size() gt 0}">
                <li class="nav-item dropdown">
                  <a class="nav-link dropdown-toggle" href="#" id="dropdown${status.index}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${utlTradeJsp.catalogToStr(cat1l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                  <div class="dropdown-menu" aria-labelledby="dropdown${status.index}">
                    <a class="dropdown-item" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat1l.catalog.itsId}">${srvI18n.getMsg("All", reqVars.lang)}</a>
                    <c:forEach var="cat2l" items="${cat1l.subcatalogs}">
                      <c:if test="${cat2l.subcatalogs.size() gt 0}">
                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#subcatalogsMdl${cat2l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat2l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                      </c:if>
                      <c:if test="${cat2l.subcatalogs.size() eq 0}">
                        <a class="dropdown-item" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat2l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat2l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                      </c:if>
                    </c:forEach>
                  </div>
                </li>
              </c:if>
              <c:if test="${cat1l.subcatalogs.size() eq 0 && cat1l.catalog.isInMenu}">
                <li class="nav-item"><a class="nav-link" href="servicePublic?nmRnd=webstore&nmHnd=hndPubWebStrTr&nmPrc=PrcWebstorePage&catalogId=${cat1l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat1l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a></li>
              </c:if>
            </c:forEach>
          <c:if test="${not empty filterPrice || not empty filterCatalog || not empty filtersSpecifics}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="modal" data-target="#filterMdl"><span class="oi oi-sort-ascending" title="Filter, order" aria-hidden="true"></span></a></li>
          </c:if>
        </ul>
        <ul class="navbar-nav navbar-right">
          <c:if test="${empty logginIfo}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('log_in', reqVars.lang)}"><span class="oi oi-account-login" aria-hidden="true"></span></a></li>
          </c:if>
          <c:if test="${not empty logginIfo}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('log_out', reqVars.lang)}"><span class="oi oi-account-logout" aria-hidden="true"></span></a></li>
          </c:if>
          <c:if test="${not empty shoppingCart}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('shopping_cart', reqVars.lang)}" onclick="$('#cartMdl').modal('toggle');"><span class="oi oi-cart" title="cart" aria-hidden="true"></span><span class="badge badge-secondary">${shoppingCart.totalItems}</span></a></li>
          </c:if>
          <li class="nav-item"><a href="#about" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('About', reqVars.lang)}"><span class="oi oi-info" aria-hidden="true"></span></a></li>
          <c:if test="${empty countryFlag}">
            <c:if test="${reqVars.lang eq 'en'}">
              <c:set var="countryFlag" value="us"/>
            </c:if>
            <c:if test="${reqVars.lang ne 'en'}">
              <c:set var="countryFlag" value="${reqVars.lang}"/>
            </c:if>
          </c:if>
          <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('lang', reqVars.lang)}" onclick="$('#i18nMdl').modal('toggle');"><span class="flag-icon flag-icon-${countryFlag}"></span></a></li>
        </ul>
      </div>
    </nav>
    </header>

    <main role="main">
