select ACC as ACCID, ACCOUNT.ITSNUMBER as ITSNUMBER, ACCOUNT.ITSNAME as ITSNAME,
case when DEBTORCREDITOR.ITSNAME is not null then DEBTORCREDITOR.ITSNAME 
when DEBTORCREDITORCATEGORY.ITSNAME is not null then DEBTORCREDITORCATEGORY.ITSNAME
when INVITEMCATEGORY.ITSNAME is not null then INVITEMCATEGORY.ITSNAME
when EMPLOYEECATEGORY.ITSNAME is not null then EMPLOYEECATEGORY.ITSNAME
when EMPLOYEE.ITSNAME is not null then EMPLOYEE.ITSNAME
when TAX.ITSNAME is not null then TAX.ITSNAME
when EXPENSE.ITSNAME is not null then EXPENSE.ITSNAME
when PROPERTY.ITSNAME is not null then PROPERTY.ITSNAME
when WAGETYPE.ITSNAME is not null then WAGETYPE.ITSNAME
when SERVICETOSALECATEGORY.ITSNAME is not null then SERVICETOSALECATEGORY.ITSNAME
when BANKACCOUNT.ITSNAME is not null then BANKACCOUNT.ITSNAME end as SUBACC,
SUBACCID, SUBACCTYPE,
case when ACCOUNT.NORMALBALANCETYPE = 0 then ALL_RECORDS.DEBIT - ALL_RECORDS.CREDIT else 0 end as DEBIT,
case when ACCOUNT.NORMALBALANCETYPE = 1 then ALL_RECORDS.CREDIT - ALL_RECORDS.DEBIT else 0 end as CREDIT
from
  (
    select ACC, SUBACCT, SUBACCID, sum(DEBIT) as DEBIT, sum(CREDIT) as CREDIT
    from 
      (
        select ITSACCOUNT as ACC, BALANCEAT.SUBACCTYPE as SUBACCT, SUBACCID,
        case when ACCOUNTIN.NORMALBALANCETYPE = 0 then ITSBALANCE
        else 0 end as DEBIT,
        case when ACCOUNTIN.NORMALBALANCETYPE = 1 then ITSBALANCE
        else 0 end as CREDIT
        from  BALANCEAT
        join ACCOUNT as ACCOUNTIN on BALANCEAT.ITSACCOUNT = ACCOUNTIN.ITSID 
        where ITSDATE = :DATE1
        
        union all

        select ACCDEBIT as ACC, SUBACCDEBITTYPE as SUBACCT, SUBACCDEBITID as SUBACCID, sum(DEBIT) as DEBIT, 0.00 as CREDIT
        from  ACCOUNTINGENTRY 
        where ITSDATE >= :DATE1 and ITSDATE <= :DATE2
        group by ACC, SUBACCT, SUBACCID
        
        union all
        
        select ACCCREDIT as ACC, SUBACCCREDITTYPE as SUBACCT, SUBACCCREDITID as SUBACCID, 0 as DEBIT, sum(CREDIT) as CREDIT
        from  ACCOUNTINGENTRY 
        where ITSDATE >= :DATE1 and ITSDATE <= :DATE2
        group by ACC, SUBACCT, SUBACCID
      ) as UNION_RECORDS
    group by ACC, SUBACCT, SUBACCID
  ) as ALL_RECORDS
join ACCOUNT on ALL_RECORDS.ACC = ACCOUNT.ITSID
left join DEBTORCREDITOR on ALL_RECORDS.SUBACCID=DEBTORCREDITOR.ITSID and ALL_RECORDS.SUBACCT=2004
left join DEBTORCREDITORCATEGORY on ALL_RECORDS.SUBACCID=DEBTORCREDITORCATEGORY.ITSID and ALL_RECORDS.SUBACCT=2005
left join BANKACCOUNT on ALL_RECORDS.SUBACCID=BANKACCOUNT.ITSID and ALL_RECORDS.SUBACCT=2002
left join INVITEMCATEGORY on ALL_RECORDS.SUBACCID=INVITEMCATEGORY.ITSID and ALL_RECORDS.SUBACCT=2001
left join EMPLOYEECATEGORY on ALL_RECORDS.SUBACCID=EMPLOYEECATEGORY.ITSID and ALL_RECORDS.SUBACCT=2007
left join EMPLOYEE on ALL_RECORDS.SUBACCID=EMPLOYEE.ITSID and ALL_RECORDS.SUBACCT=2006
left join TAX on ALL_RECORDS.SUBACCID=TAX.ITSID and ALL_RECORDS.SUBACCT=2003
left join EXPENSE on ALL_RECORDS.SUBACCID=EXPENSE.ITSID and ALL_RECORDS.SUBACCT=2009
left join PROPERTY on ALL_RECORDS.SUBACCID=PROPERTY.ITSID and ALL_RECORDS.SUBACCT=2010
left join WAGETYPE on ALL_RECORDS.SUBACCID=WAGETYPE.ITSID and ALL_RECORDS.SUBACCT=2008
left join SERVICETOSALECATEGORY on ALL_RECORDS.SUBACCID=SERVICETOSALECATEGORY.ITSID and ALL_RECORDS.SUBACCT=2011
order by ACCOUNT.ITSNUMBER, SUBACC;
