<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurr}" scope="request"/>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <title>${srvI18n.getMsg("trial_balance", reqVars.lang)} <fmt:formatDate value="${date2}"/></title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${srvI18n.getMsg("trial_balance", reqVars.lang)} <fmt:formatDate value="${date2}" type="date" dateStyle="LONG"/> <br>
      ${reqVars.accSet.organization}
    </h4>
  </div>
  <table>
    <tr>
      <th colspan="2" align="left">${srvI18n.getMsg("Account", reqVars.lang)}</th>
      <th class="debit-credit-th">${srvI18n.getMsg("Debit", reqVars.lang)}</th>
      <th class="debit-credit-th">${srvI18n.getMsg("Credit", reqVars.lang)}</th>
    </tr>
    <c:set var="accCurr" value=""/>
    <c:set var="debitTotal" value="0"/>
    <c:set var="creditTotal" value="0"/>
    <c:forEach var="balanceLine" items="${balanceLines}">
      <tr>
        <td>
          <c:if test="${balanceLine.accNumber != accCurr}">
            <c:set var="accCurr" value="${balanceLine.accNumber}"/>
            ${balanceLine.accNumber}
            ${balanceLine.accName}
          </c:if>
        </td>
        <td class="subacc">
          ${balanceLine.subaccName}</td>
        <td class="debit-credit">${utlJsp.printNumber(balanceLine.debit.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.reportDp, reqVars.digInGr)}</td>
        <td class="debit-credit">${utlJsp.printNumber(balanceLine.credit.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.reportDp, reqVars.digInGr)}</td>
      </tr>
      <c:set var="debitTotal" value="${balanceLine.debit + debitTotal}"/>
      <c:set var="creditTotal" value="${balanceLine.credit + creditTotal}"/>
    </c:forEach>
    <tr>
      <td colspan="2" class="total"><b>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</b></td>
      <td class="total"><b>${utlJsp.printNumber(debitTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.reportDp, reqVars.digInGr)} ${reqVars.curSign}</b></td>
      <td class="total"><b>${utlJsp.printNumber(creditTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.reportDp, reqVars.digInGr)} ${reqVars.curSign}</b></td>
    </tr>
  </table>

</body>
</html>
