<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<dialog id="${namePlaceSubForm}EditDlg" class="dlg dlg-sub" oncancel="return false;">
  <div class="form-std">
    <div class="dialog-title">
      ${srvI18n.getMsg("AdjustBsl", reqVars.lang)}
      <button onclick="closeDlgCareful('${namePlaceSubForm}Edit')" class="btn-close">x</button>
    </div>
    <form id="${namePlaceSubForm}EditFrm" action="service" method="POST" enctype="multipart/form-data">
      <input type="hidden" name="nmsAct" value="entityFolSave,entityEdit">
      <input type="hidden" name="nmEnt" value="${entity.getClass().simpleName}">
      <input type="hidden" name="nmRnd" value="editEntityFolSavedNlJson">
      <input type="hidden" name="msgSuccess" value="edit_ok">
      <input type="hidden" name="page" value="${param.page}">
      <c:if test="${not empty param.mobile}">
        <input type="hidden" name="mobile" value="${param.mobile}">
      </c:if>
      <c:forEach items="${param}" var="par">
        <c:if test="${par.key.startsWith('fltordM')}">
          <input type="hidden" name="${par.key}" value="${par.value}">
        </c:if>
      </c:forEach>
      <table class="tbl-fieldset">
        <c:set var="fieldName" value="itsId" scope="request"/>
        <jsp:include page="${param.mobile}inputs/inputHidden.jsp"/>
        <c:set var="fieldName" value="idDatabaseBirth" scope="request"/>
        <jsp:include page="${param.mobile}inputs/inputHidden.jsp"/>
        <c:set var="fieldName" value="idBirth" scope="request"/>
        <jsp:include page="${param.mobile}inputs/inputHidden.jsp"/>
        <c:set var="fieldName" value="itsOwner" scope="request"/>
        <jsp:include page="${param.mobile}inputs/inputEntityHasIdVersionHidden.jsp"/>
        <c:set var="fieldName" value="itsAmount" scope="request"/>
        <jsp:include page="${param.mobile}inputs/inputPriceReadOnly.jsp"/>
        <tr>
          <td>
            <label for="description">${srvI18n.getMsg('description', reqVars.lang)}</label>
          </td>
          <c:if test="${not empty param.mobile}">
            </tr>
            <tr>
          </c:if>
          <td>
            <div class="input-line">
              <textarea rows="2" required name="description" onchange="inputHasBeenChanged(this);">${entity.descriptionStatus}</textarea>
            </div>
          </td>
        </tr>
      </table>
      <c:if test="${not empty prepayments}">
        <table class="tbl-fieldset" id="bnkStLnPrepMatch">
          <c:if test="${entity.itsAmount.doubleValue() gt 0}">
            <c:set var="prepnm" value="${srvI18n.getMsg('PrepaymentFrom', reqVars.lang)}"/>
          </c:if>
          <c:if test="${entity.itsAmount.doubleValue() lt 0}">
            <c:set var="prepnm" value="${srvI18n.getMsg('PrepaymentTo', reqVars.lang)}"/>
          </c:if>
          <tr>
            <td>
              <label for="description">${srvI18n.getMsg('Prepayments', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <select name="prepaymentId" onchange="inputHasBeenChanged(this);bnStLnPrepayMatchChanged(this);">
                  <option value="" selected>-</option>
                  <c:forEach items="${prepayments}" var="prepay">
                    <option value="${prepay.itsId}">
                      <c:if test="${entity.itsStatus == 'VOIDED' && prepay.reversedId == null}">
                        ${srvI18n.getMsg('AddReverse', reqVars.lang)}
                      </c:if>
                      <c:if test="${!(entity.itsStatus == 'VOIDED' && prepay.reversedId == null)}">
                        ${srvI18n.getMsg('AddMatching', reqVars.lang)}
                      </c:if>
                      - ${prepnm}
                      <c:set var="model" value="${prepay}" scope="request"/>
                      <jsp:include page="toString/toStrDocument.jsp"/>
                      ${prepay.description}
                    </option>
                  </c:forEach>
                </select>
              </div>
            </td>
          </tr>
        </table>
      </c:if>
      <c:if test="${not empty payments}">
        <table class="tbl-fieldset" id="bnkStLnPayMatch">
          <c:if test="${entity.itsAmount.doubleValue() gt 0}">
            <c:set var="paynm" value="${srvI18n.getMsg('PaymentFrom', reqVars.lang)}"/>
          </c:if>
          <c:if test="${entity.itsAmount.doubleValue() lt 0}">
            <c:set var="paynm" value="${srvI18n.getMsg('PaymentTo', reqVars.lang)}"/>
          </c:if>
          <tr>
            <td>
              <label for="description">${srvI18n.getMsg('Payments', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <select name="paymentId" onchange="inputHasBeenChanged(this);bnStLnPayMatchChanged(this);">
                  <option value="" selected>-</option>
                  <c:forEach items="${payments}" var="pay">
                    <option value="${pay.itsId}">
                      <c:if test="${entity.itsStatus == 'VOIDED' && pay.reversedId == null}">
                        ${srvI18n.getMsg('AddReverse', reqVars.lang)}
                      </c:if>
                      <c:if test="${!(entity.itsStatus == 'VOIDED' && pay.reversedId == null)}">
                        ${srvI18n.getMsg('AddMatching', reqVars.lang)}
                      </c:if>
                      - ${paynm}
                      <c:set var="model" value="${pay}" scope="request"/>
                      <jsp:include page="toString/toStrDocument.jsp"/>
                      ${pay.description}
                    </option>
                  </c:forEach>
                </select>
              </div>
            </td>
          </tr>
        </table>
      </c:if>
      <c:if test="${not empty accentries}">
        <table class="tbl-fieldset" id="bnkStLnAccentryMatch">
          <tr>
            <td>
              <label for="description">${srvI18n.getMsg('AccountingEntrys', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <select name="accentryId" onchange="inputHasBeenChanged(this);bnStLnAccentryMatchChanged(this);">
                  <option value="" selected>-</option>
                  <c:forEach items="${accentries}" var="accent">
                    <option value="${accent.itsId}">
                      <c:if test="${accent.sourceType==1010}">
                        ${srvI18n.getMsg('AlreadyDone', reqVars.lang)}
                      </c:if>
                      <c:if test="${accent.sourceType!=1010 && entity.itsStatus == 'VOIDED'}">
                        ${srvI18n.getMsg('AddReverse', reqVars.lang)}
                      </c:if>
                      <c:if test="${accent.sourceType!=1010 && entity.itsStatus != 'VOIDED'}">
                        ${srvI18n.getMsg('AddMatching', reqVars.lang)}
                      </c:if>
                      - ${srvI18n.getMsg('AccountingEntry', reqVars.lang)} # ${accent.idDatabaseBirth}-
                      <c:if test="${not idBirth}">
                        ${accent.itsId}
                      </c:if>
                      <c:if test="${not empty idBirth}">
                        ${accent.idBirth} (${accent.itsId})
                      </c:if>
                      , <fmt:formatDate value="${accent.itsDate}" type="both" timeStyle="short"/>, ${utlJsp.printNumber(entity.itsAmount.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
                      ${accent.description}
                    </option>
                  </c:forEach>
                </select>
              </div>
            </td>
          </tr>
        </table>
      </c:if>
      <c:if test="${entity.itsStatus != 'VOIDED'}">
        <table class="tbl-fieldset" id="bnkStLnDocType">
          <tr>
            <td>
              <label for="adjDocType">${srvI18n.getMsg("AddAdjusting", reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <select name="adjDocType" onchange="inputHasBeenChanged(this);bnStLnDocTypeChanged(this);">
                  <option value="" selected>-</option>
                  <option value="1">${srvI18n.getMsg("Prepayment", reqVars.lang)}</option>
                  <option value="2">${srvI18n.getMsg("Payment", reqVars.lang)}</option>
                  <option value="3">${srvI18n.getMsg("AccountingEntry", reqVars.lang)}</option>
                </select>
              </div>
            </td>
          </tr>
        </table>
        <table class="tbl-fieldset" id="bnkStLnPrep" style="display: none;">
          <tr>
            <td>
              <label for="debtorCreditor">${srvI18n.getMsg('debtorCreditor', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input class="picked-appearence" id="debtorCreditorAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
                <input id="debtorCreditorId" type="hidden" name="debtorCreditor">
                <button type="button" class="btn" onclick="openEntityPicker('DebtorCreditor','', 'debtorCreditor', '&mobile=${param.mobile}');">...</button>
                <button type="button" class="btn" onclick="clearSelectedEntity('debtorCreditor');">X</button>
              </div>
            </td>
          </tr>
        </table>
        <table class="tbl-fieldset" id="bnkStLnPay" style="display: none;">
          <tr>
            <td>
              <label for="invoice">${srvI18n.getMsg('Invoice', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input class="picked-appearence" id="invoiceAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
                <input id="invoiceId" type="hidden" name="invoice">
                <c:if test="${entity.itsAmount.doubleValue() gt 0}">
                  <c:set var="invoiceType" value="SalesInvoice"/>
                </c:if>
                <c:if test="${entity.itsAmount.doubleValue() lt 0}">
                  <c:set var="invoiceType" value="PurchaseInvoice"/>
                </c:if>
                <button type="button" class="btn" onclick="openEntityPicker('${invoiceType}','', 'invoice', '&fltordPhasMadeAccEntriesVal=true&fltordPforcedFor=hasMadeAccEntries&mobile=${param.mobile}');">...</button>
                <button type="button" class="btn" onclick="clearSelectedEntity('invoice');">X</button>
              </div>
            </td>
          </tr>
        </table>
        <table class="tbl-fieldset" id="bnkStLnEntry" style="display: none;">
          <tr>
            <td>
              <label for="corAcc">${srvI18n.getMsg('corAcc', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input class="picked-appearence" id="corAccAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this); clearSubacc('', 'corAcc', 'subcorAcc');">
                <input id="corAccId" type="hidden" name="corAcc">
                <button type="button" class="btn" onclick="openEntityPicker('Account','', 'corAcc', '&fltordPisUsedVal=true&fltordPforcedFor=isUsed&mobile=${param.mobile}');">...</button>
                <button type="button" class="btn" onclick="clearSelectedEntity('corAcc');">X</button>
              </div>
            </td>
          </tr>
          <tr>
            <td>
              <label for="subcorAccAppearanceVisible">${srvI18n.getMsg("subaccount", reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input class="picked-appearence" id="subcorAccAppearanceVisible" disabled type="text" onchange="inputHasBeenChanged(this);">
                <input id="subcorAccAppearance" type="hidden" name="subcorAcc">
                <input id="subcorAccId" type="hidden" name="subcorAccId">
                <input id="subcorAccType" type="hidden" name="subcorAccType">
                <button id="subcorAccChoose" type="button" class="btn" onclick="openPickerSubacc('', 'corAcc', 'subcorAcc', '&mobile=${param.mobile}');">...</button>
                <button id="subcorAccClear" type="button" class="btn" onclick="clearSubacc('', 'corAcc', 'subcorAcc');">X</button>
              </div>
            </td>
          </tr>
        </table>
        <table class="tbl-fieldset" id="bnkStLnPrepPayEntry" style="display: none;">
          <tr>
            <td>
              <label for="accCash">${srvI18n.getMsg('accCash', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input class="picked-appearence" id="accCashAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
                <input id="accCashId" type="hidden" name="accCash">
                <button type="button" class="btn" onclick="openEntityPicker('Account','', 'accCash', '&fltordPsubaccTypeOpr1=eq&fltordPsubaccTypeVal1=2002&fltordPisUsedVal=true&fltordPforcedFor=isUsed,subaccType&mobile=${param.mobile}');">...</button>
                <button type="button" class="btn" onclick="clearSelectedEntity('accCash');">X</button>
              </div>
            </td>
          </tr>
          <tr>
            <td>
              <label for="itsDate">${srvI18n.getMsg('itsDate', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input type="datetime-local" name="itsDate" value="${srvDate.toIso8601DateTimeNoTz(entity.itsDate, null)}" onchange="inputHasBeenChanged(this);"/> 
              </div>
            </td>
          </tr>
        </table>
        <table class="tbl-fieldset" id="bnkStLnPrepPay" style="display: none;">
          <tr>
            <td>
              <label for="foreignTotal">${srvI18n.getMsg('foreignTotal', reqVars.lang)}</label>
            </td>
            <c:if test="${not empty param.mobile}">
              </tr>
              <tr>
            </c:if>
            <td>
              <div class="input-line">
                <input type="text" name="foreignTotal" value="0.0" onchange="inputHasBeenChanged(this);" class="bsNum${reqVars.priceDp}"/> 
              </div>
            </td>
          </tr>
        </table>
      </c:if>
      <div class="form-actions">
        <input style="display: none" id="${namePlaceSubForm}EditFrmFakeSubmit" type="submit"/>
        <button type="button" onclick="submitFormByAjax('${namePlaceSubForm}EditFrm');">${srvI18n.getMsg("Save", reqVars.lang)}</button>
        <button type="button" onclick="closeDlgCareful('${namePlaceSubForm}Edit');">${srvI18n.getMsg("Close", reqVars.lang)}</a>
      </div>
    </form>
  </div>
</dialog>
