<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSet.isExtractSalesTaxFromPurchase && !entity.itsOwner.omitTaxes && !entity.itsOwner.vendor.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSet.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSet.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.vendor.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.vendor.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.vendor.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.invItemAppearanceVisible">${srvI18n.getMsg('invItem', reqVars.lang)}</label>
  </td>
  <td>
    <c:set var="invoiceLnItemId" value="${entity.getClass().simpleName}invItemId" scope="request"/>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}invItemAppearanceVisible" disabled="disabled" type="text" value="${entity.invItem.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}invItemId" required type="hidden" name="${entity.getClass().simpleName}.invItem" value="${entity.invItem.itsId}">
      <c:if test="${isTaxable}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','${entity.getClass().simpleName}', 'invItem','&fltordPknownCostOpr1=eq&fltordPknownCostVal1=0&fltordPforcedFor=knownCost&wdgPick=pickItemUomTax&flyPrIncTax=${entity.itsOwner.priceIncTax}&mobile=${param.mobile}');">...</button>
      </c:if>
      <c:if test="${!isTaxable}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','${entity.getClass().simpleName}', 'invItem','&fltordPknownCostOpr1=eq&fltordPknownCostVal1=0&fltordPforcedFor=knownCost&mobile=${param.mobile}');">...</button>
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.unitOfMeasureAppearanceVisible">${srvI18n.getMsg('unitOfMeasure', reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="${entity.getClass().simpleName}unitOfMeasureAppearanceVisible" disabled="disabled" type="text" value="${entity.unitOfMeasure.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="${entity.getClass().simpleName}unitOfMeasureId" required type="hidden" name="${entity.getClass().simpleName}.unitOfMeasure" value="${entity.unitOfMeasure.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('UnitOfMeasure','${entity.getClass().simpleName}', 'unitOfMeasure','&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}unitOfMeasure');">X</button>
    </div>
  </td>
</tr>
<jsp:include page="inpPurchaseInvLnTmp.jsp"/>
