<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSet.isExtractSalesTaxFromPurchase && !entity.itsOwner.purchaseInvoice.omitTaxes && !entity.itsOwner.purchaseInvoice.customer.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSet.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSet.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.purchaseInvoice.customer.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.purchaseInvoice.customer.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.purchaseInvoice.customer.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<c:if test="${not empty entity.purchaseInvoiceLine}">
  <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.itsId}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${entity.purchaseInvoiceLine.itsCost}, ${srvI18n.getMsg('rest_was', reqVars.lang)}=${entity.purchaseInvoiceLine.theRest}"/>
  <c:if test="${empty entity.purchaseInvoiceLine.idBirth}">
    <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.idDatabaseBirth}-${entity.purchaseInvoiceLine.itsId}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.itsCost.toString(), decSepv, decGrSepv, costDp, digInGr)}, ${srvI18n.getMsg('theRest', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.theRest.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}"/>
  </c:if>
  <c:if test="${not empty entity.purchaseInvoiceLine.idBirth}">
    <c:set var="docLineAppr" value="# ${entity.purchaseInvoiceLine.idDatabaseBirth}-${entity.purchaseInvoiceLine.idBirth}, ${entity.purchaseInvoiceLine.invItem.itsName}, ${srvI18n.getMsg('itsCost', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.itsCost.toString(), decSepv, decGrSepv, costDp, digInGr)}, ${srvI18n.getMsg('theRest', reqVars.lang)}=${utlJsp.printNumber(entity.purchaseInvoiceLine.theRest.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}"/>
  </c:if>
</c:if>
<tr>
  <td>
    <label for="PurchaseReturnLinepurchaseInvoiceLineAppearanceVisible">${srvI18n.getMsg(fieldName, reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="PurchaseReturnLinepurchaseInvoiceLineAppearanceVisible" disabled type="text" value="${docLineAppr}" onchange="inputHasBeenChanged(this);">
      <input id="PurchaseReturnLinepurchaseInvoiceLineId" type="hidden" required name="PurchaseReturnLine.purchaseInvoiceLine" value="${entity.purchaseInvoiceLine.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('PurchaseInvoiceLine', 'PurchaseReturnLine', 'purchaseInvoiceLine', '&fltordPitsOwnerValId=${entity.itsOwner.purchaseInvoice.itsId}&fltordPitsOwnerOpr=eq&fltordPreversedIdOpr1=isnull&flyPrIncTax=${entity.itsOwner.priceIncTax}&fltordPforcedFor=itsOwner,reversedId&mobile=${param.mobile}');">...</button>
    </div>
  </td>
</tr>
<c:if test="${isTaxable && isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax)}">
  <c:set var="calcTotalFnNm" value="calcTotalTax"/>
  <c:set var="calcCostFnNm" value="calcPriceTax"/>
  <c:set var="taxParam" value=",${entity.itsOwner.priceIncTax},${reqVars.priceDp},${reqVars.accSet.salTaxRoundMode.ordinal()}"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax))}">
  <c:set var="calcTotalFnNm" value="calcTotal"/>
  <c:set var="calcCostFnNm" value="calcPrice"/>
  <c:set var="taxParam" value=""/>
</c:if>
<tr>
  <td>
    <label for="PurchaseReturnLine.itsCost">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignPrice", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsCost", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && !entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="bsNum${reqVars.costDp} changingTot" readonly id="${entity.getClass().simpleName}itsCost" value="0.0" onchange="inputHasBeenChanged(this);"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="PurchaseReturnLine.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="bsNum${reqVars.quantityDp} changingTot" required id="PurchaseReturnLineitsQuantity" name="PurchaseReturnLine.itsQuantity" value="${entity.itsQuantity}"/> 
    </div>
  </td>
</tr>
<c:if test="${!isTaxable || entity.itsOwner.priceIncTax}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity.itsTotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${!(!isTaxable || entity.itsOwner.priceIncTax)}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${not empty entity.itsOwner.customer.taxDestination}">
          <button type="button" id="${entity.getClass().simpleName}btnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'nontransact/?nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&flyPrIncTax=${entity.itsOwner.priceIncTax}&nmEnt=${entity.getClass().simpleName}&taxDestId=${entity.itsOwner.customer.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" disabled id="${entity.getClass().simpleName}taxCategory"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax)}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <c:if test="${not empty entity.itsOwner.customer.taxDestination}">
            <c:set var="aggrOnlyPercent" value=""/>
          </c:if>
          <c:if test="${empty entity.itsOwner.customer.taxDestination}">
            <c:set var="aggrOnlyPercent" value="${utlJsp.printNumber('0.0', reqVars.decSepv, reqVars.decGrSepv, reqVars.taxDp, reqVars.digInGr)}"/>
          </c:if>
          <input type="text" disabled id="${entity.getClass().simpleName}itsPercentage" value="${aggrOnlyPercent}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}totalTaxes" required name="${entity.getClass().simpleName}.totalTaxes" class="bsNum${reqVars.priceDp}" value="${entity.totalTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>
<c:if test="${not empty usedPdStr && !usedPdStr.contains(reqVars.costDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.costDp.toString()}" scope="request"/>
</c:if>
<c:if test="${empty usedPdStr}">
  <c:set var="usedPdStr" value="${reqVars.costDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.priceDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.priceDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.quantityDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.quantityDp.toString()}" scope="request"/>
</c:if>
<c:set var="numJsAfl" value="jQuery('#${entity.getClass().simpleName}itsTotal').on('change', function(){${calcCostFnNm}(this,'${entity.getClass().simpleName}','itsCost',${reqVars.costDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:set var="numJsAfl" value="${numJsAfl}jQuery('.changingTot').on('change', function(){${calcTotalFnNm}(this,'${entity.getClass().simpleName}','itsCost',${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:if test="${not empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAf}${numJsAfl}" scope="request"/>
</c:if>
<c:if test="${empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAfl}" scope="request"/>
</c:if>
