<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="isTaxable" value="${reqVars.accSet.isExtractSalesTaxFromSales && !entity.itsOwner.omitTaxes && !entity.itsOwner.customer.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSet.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSet.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.itsOwner.customer.taxDestination != null}">
  <c:set var="isItemBasis" value="${!entity.itsOwner.customer.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.itsOwner.customer.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<tr>
  <td>
    <label for="SalesReturnLine.invItemAppearanceVisible">${srvI18n.getMsg('invItem', reqVars.lang)}</label>
  </td>
  <td>
    <c:set var="invoiceLnItemId" value="SalesReturnLineinvItemId" scope="request"/>
    <div class="input-line">
      <input class="picked-appearence" id="SalesReturnLineinvItemAppearanceVisible" disabled="disabled" type="text" value="${entity.invItem.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="SalesReturnLineinvItemId" required type="hidden" name="SalesReturnLine.invItem" value="${entity.invItem.itsId}">
      <c:if test="${isTaxable}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','SalesReturnLine', 'invItem','&wdgPick=pickItemUomTax&flyPrIncTax=${entity.itsOwner.priceIncTax}&mobile=${param.mobile}');">...</button>
      </c:if>
      <c:if test="${!isTaxable}">
        <button type="button" autofocus class="btn" onclick="openEntityPicker('InvItem','SalesReturnLine', 'invItem','&mobile=${param.mobile}');">...</button>
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.unitOfMeasureAppearanceVisible">${srvI18n.getMsg('unitOfMeasure', reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input class="picked-appearence" id="SalesReturnLineunitOfMeasureAppearanceVisible" disabled="disabled" type="text" value="${entity.unitOfMeasure.itsName}" onchange="inputHasBeenChanged(this);">
      <input id="SalesReturnLineunitOfMeasureId" required type="hidden" name="SalesReturnLine.unitOfMeasure" value="${entity.unitOfMeasure.itsId}">
      <button type="button" class="btn" onclick="openEntityPicker('UnitOfMeasure','SalesReturnLine', 'unitOfMeasure','&mobile=${param.mobile}');">...</button>
    </div>
  </td>
</tr>
<c:if test="${isTaxable && isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax)}">
  <c:set var="calcTotalFnNm" value="calcTotalTax"/>
  <c:set var="calcPriceFnNm" value="calcPriceTax"/>
  <c:set var="taxParam" value=",${entity.itsOwner.priceIncTax},${reqVars.priceDp},${reqVars.accSet.salTaxRoundMode.ordinal()}"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax))}">
  <c:set var="calcTotalFnNm" value="calcTotal"/>
  <c:set var="calcPriceFnNm" value="calcPrice"/>
  <c:set var="taxParam" value=""/>
</c:if>
<tr>
  <td>
    <label for="SalesReturnLine.itsCost">
      ${srvI18n.getMsg("itsCost", reqVars.lang)}
      <c:if test="${isTaxable}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="bsNum${reqVars.costDp} changingTot" required id="SalesReturnLineitsCost" name="SalesReturnLine.itsCost" value="${entity.itsCost}"/> 
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsPrice">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignPrice", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsPrice", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && !entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp} changingTot" required id="${entity.getClass().simpleName}itsPrice" name="${entity.getClass().simpleName}.foreignPrice" value="${entity.foreignPrice}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp} changingTot" required id="${entity.getClass().simpleName}itsPrice" name="${entity.getClass().simpleName}.itsPrice" value="${entity.itsPrice}"/> 
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="SalesReturnLine.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
  <td>
    <div class="input-line">
      <input type="text" class="bsNum${reqVars.quantityDp} changingTot" required id="SalesReturnLineitsQuantity" name="SalesReturnLine.itsQuantity" value="${entity.itsQuantity}"/> 
    </div>
  </td>
</tr>
<c:if test="${!isTaxable || entity.itsOwner.priceIncTax}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity.itsTotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${!(!isTaxable || entity.itsOwner.priceIncTax)}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.customer.taxDestination}">
          <button type="button" id="${entity.getClass().simpleName}btnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'nontransact/?nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&flyPrIncTax=${entity.itsOwner.priceIncTax}&nmEnt=${entity.getClass().simpleName}&taxDestId=${entity.itsOwner.customer.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
    <td>
      <div class="input-line">
        <input type="text" disabled id="${entity.getClass().simpleName}taxCategory" value="${entity.taxCategory.itsName}"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && (isAggrOnlyRate || entity.itsOwner.priceIncTax)}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
           <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.customer.taxDestination}">
            <c:set var="aggrOnlyPercent" value=""/>
          </c:if>
          <c:if test="${empty entity.taxCategory && empty entity.itsOwner.customer.taxDestination}">
            <c:set var="aggrOnlyPercent" value="${utlJsp.printNumber('0.0', reqVars.decSepv, reqVars.decGrSepv, reqVars.taxDp, reqVars.digInGr)}"/>
          </c:if>
          <c:if test="${not empty entity.taxCategory}">
            <c:set var="aggrOnlyPercent" value="${utlJsp.printNumber(entity.taxCategory.aggrOnlyPercent.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.taxDp, reqVars.digInGr)}"/>
          </c:if>
          <input type="text" disabled id="${entity.getClass().simpleName}itsPercentage" value="${aggrOnlyPercent}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
      <td>
        <div class="input-line">
          <input type="text" required id="${entity.getClass().simpleName}totalTaxes" name="${entity.getClass().simpleName}.totalTaxes" class="bsNum${reqVars.priceDp}" value="${entity.totalTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>
<c:if test="${not empty usedPdStr && !usedPdStr.contains(reqVars.priceDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.priceDp.toString()}" scope="request"/>
</c:if>
<c:if test="${empty usedPdStr}">
  <c:set var="usedPdStr" value="${reqVars.priceDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.quantityDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.quantityDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.costDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.costDp.toString()}" scope="request"/>
</c:if>
<c:set var="numJsAfl" value="jQuery('#${entity.getClass().simpleName}itsTotal').on('change', function(){${calcPriceFnNm}(this,'${entity.getClass().simpleName}','itsPrice',${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:set var="numJsAfl" value="${numJsAfl}jQuery('.changingTot').on('change', function(){${calcTotalFnNm}(this,'${entity.getClass().simpleName}','itsPrice',${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:if test="${not empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAf}${numJsAfl}" scope="request"/>
</c:if>
<c:if test="${empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAfl}" scope="request"/>
</c:if>
