<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:if test="${isTaxable && isItemBasis && isAggrOnlyRate}">
  <c:set var="calcTotalFnNm" value="calcTotalTax"/>
  <c:set var="calcCostFnNm" value="calcPriceTax"/>
  <c:set var="taxParam" value=",${entity.itsOwner.priceIncTax},${reqVars.priceDp},${reqVars.accSet.salTaxRoundMode.ordinal()}"/>
</c:if>
<c:if test="${!(isTaxable && isItemBasis && isAggrOnlyRate)}">
  <c:set var="calcTotalFnNm" value="calcTotal"/>
  <c:set var="calcCostFnNm" value="calcPrice"/>
  <c:set var="taxParam" value=""/>
</c:if>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsCost">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignPrice", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsCost", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("include_taxes", reqVars.lang)}
      </c:if>
      <c:if test="${isTaxable && !entity.itsOwner.priceIncTax}">
        ${srvI18n.getMsg("without_taxes", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.costDp} changingTot" required id="${entity.getClass().simpleName}itsCost" name="${entity.getClass().simpleName}.foreignPrice" value="${entity.foreignPrice}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.costDp} changingTot" required id="${entity.getClass().simpleName}itsCost" name="${entity.getClass().simpleName}.itsCost" value="${entity.itsCost}"/> 
      </c:if>
    </div>
  </td>
</tr>
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsQuantity">${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <input type="text" class="bsNum${reqVars.quantityDp} changingTot" required id="${entity.getClass().simpleName}itsQuantity" name="${entity.getClass().simpleName}.itsQuantity" value="${entity.itsQuantity}"/> 
    </div>
  </td>
</tr>
<c:if test="${!isTaxable || entity.itsOwner.priceIncTax}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("itsTotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.itsTotal" value="${entity.itsTotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${!(!isTaxable || entity.itsOwner.priceIncTax)}">
<tr>
  <td>
    <label for="${entity.getClass().simpleName}.itsTotal">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        ${srvI18n.getMsg("subtotal", reqVars.lang)}
      </c:if>
    </label>
  </td>
<tr>
</tr>
  <td>
    <div class="input-line">
      <c:if test="${not empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}"/> 
      </c:if>
      <c:if test="${empty entity.itsOwner.foreignCurrency}">
        <input type="text" class="bsNum${reqVars.priceDp}" id="${entity.getClass().simpleName}itsTotal" name="${entity.getClass().simpleName}.subtotal" value="${entity.subtotal}"/> 
      </c:if>
    </div>
  </td>
</tr>
</c:if>
<c:if test="${isTaxable}">
  <tr>
    <td>
      <label>
         ${srvI18n.getMsg("taxCategory", reqVars.lang)}
        <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination}">
          <button type="button" id="${entity.getClass().simpleName}btnTaxDestination" class="btn" onclick="if (document.getElementById('${invoiceLnItemId}').value != '') { getHtmlByAjax('GET', 'nontransact/?nmPrc=PrcRevealTaxCat&nmRnd=revealTaxCatJson&flyPrIncTax=${entity.itsOwner.priceIncTax}&nmEnt=${entity.getClass().simpleName}&taxDestId=${entity.itsOwner.vendor.taxDestination.itsId}&itemId=' + document.getElementById('${invoiceLnItemId}').value + '');}">${srvI18n.getMsg("reveal", reqVars.lang)}</button>
        </c:if>
      </label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input type="text" disabled id="${entity.getClass().simpleName}taxCategory" value="${entity.taxCategory.itsName}"/> 
      </div>
    </td>
  </tr>
  <c:if test="${isItemBasis && isAggrOnlyRate}">
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("itsPercentage", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <c:if test="${empty entity.taxCategory && not empty entity.itsOwner.vendor.taxDestination}">
            <c:set var="aggrOnlyPercent" value=""/>
          </c:if>
          <c:if test="${empty entity.taxCategory && empty entity.itsOwner.vendor.taxDestination}">
            <c:set var="aggrOnlyPercent" value="${utlJsp.printNumber('0.0', reqVars.decSepv, reqVars.decGrSepv, reqVars.taxDp, reqVars.digInGr)}"/>
          </c:if>
          <c:if test="${not empty entity.taxCategory}">
            <c:set var="aggrOnlyPercent" value="${utlJsp.printNumber(entity.taxCategory.aggrOnlyPercent.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.taxDp, reqVars.digInGr)}"/>
          </c:if>
          <input type="text" disabled id="${entity.getClass().simpleName}itsPercentage" value="${aggrOnlyPercent}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label>
           ${srvI18n.getMsg("totalTaxes", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}totalTaxes" required name="${entity.getClass().simpleName}.totalTaxes" class="bsNum${reqVars.priceDp}" value="${entity.totalTaxes}" onchange="inputHasBeenChanged(this);"/> 
        </div>
      </td>
    </tr>      
  </c:if>
</c:if>
<c:if test="${not empty usedPdStr && !usedPdStr.contains(reqVars.costDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.costDp.toString()}" scope="request"/>
</c:if>
<c:if test="${empty usedPdStr}">
  <c:set var="usedPdStr" value="${reqVars.costDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.quantityDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.quantityDp.toString()}" scope="request"/>
</c:if>
<c:if test="${!usedPdStr.contains(reqVars.priceDp.toString())}">
  <c:set var="usedPdStr" value="${usedPdStr},${reqVars.priceDp.toString()}" scope="request"/>
</c:if>
<c:set var="numJsAfl" value="jQuery('#${entity.getClass().simpleName}itsTotal').on('change', function(){${calcCostFnNm}(this,'${entity.getClass().simpleName}','itsCost',${reqVars.costDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:set var="numJsAfl" value="${numJsAfl}jQuery('.changingTot').on('change', function(){${calcTotalFnNm}(this,'${entity.getClass().simpleName}','itsCost',${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()}${taxParam});});"/>
<c:if test="${not empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAf}${numJsAfl}" scope="request"/>
</c:if>
<c:if test="${empty numJsAf}">
  <c:set var="numJsAf" value="${numJsAfl}" scope="request"/>
</c:if>

