<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:if test="${not empty entity.sourceName}">
  <jsp:include page="inputReadOnly.jsp"/>
</c:if>
<c:if test="${empty entity.sourceName}">
  <tr>
    <td>
      <label for="bankCsvMethod">${srvI18n.getMsg("BankCsvMethod", reqVars.lang)}</label>
    </td>
  </tr>
  <tr>
    <td>
    <div class="input-line">
      <input class="picked-appearence" id="bankCsvMethodAppearanceVisible" disabled="disabled" type="text" onchange="inputHasBeenChanged(this);">
      <input id="bankCsvMethodId" required type="hidden" name="bankCsvMethod">
      <input id="bankCsvMethodAppearance" type="hidden">
      <button type="button" class="btn" onclick="openEntityPicker('BankCsvMethod','', 'bankCsvMethod','&mobile=${param.mobile}');">...</button>
      <button type="button" class="btn" onclick="clearSelectedEntity('bankCsvMethod');">X</button>
    </div>
    </td>
  </tr>
  <tr>
    <td>
      <label for="csvFile">${srvI18n.getMsg("csvFile", reqVars.lang)}</label>
    </td>
  </tr>
  <tr>
    <td>
      <div class="input-line">
        <input type="file" required name="csvFile" onchange="inputHasBeenChanged(this);this.form.action='uploadSingle';"/> 
        <input type="hidden" name="paramNameFileToUpload" value="csvFile">
        <input type="hidden" name="fieldNameFileName" value="sourceName">
      </div>
    </td>
  </tr>
</c:if>
