<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<c:set var="isTaxable" value="${reqVars.accSet.isExtractSalesTaxFromPurchase && !entity.purchaseInvoice.omitTaxes && !entity.purchaseInvoice.vendor.isForeigner}" scope="request"/>
<c:set var="isItemBasis" value="${!reqVars.accSet.salTaxIsInvoiceBase}" scope="request"/>
<c:set var="isAggrOnlyRate" value="${reqVars.accSet.salTaxUseAggregItBas}" scope="request"/>
<c:if test="${entity.purchaseInvoice.vendor.taxDestination != null}">
  <c:set var="taxDestination" value="${entity.purchaseInvoice.vendor.taxDestination}" scope="request"/>
  <c:set var="isItemBasis" value="${!entity.purchaseInvoice.vendor.taxDestination.salTaxIsInvoiceBase}" scope="request"/>
  <c:set var="isAggrOnlyRate" value="${entity.purchaseInvoice.vendor.taxDestination.salTaxUseAggregItBas}" scope="request"/>
</c:if>
<c:if test="${not empty entity[fieldName]}">
  <fmt:formatDate value="${entity[fieldName].itsDate}" type="both" timeStyle="medium" var="dateAppr"/>
  <c:if test="${empty entity[fieldName].idBirth}">
    <c:set var="docAppr" value="# ${entity[fieldName].idDatabaseBirth}-${entity[fieldName].itsId}, ${dateAppr}, ${utlJsp.printNumber(entity[fieldName].itsTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}"/>
  </c:if>
  <c:if test="${not empty entity[fieldName].idBirth}">
    <c:set var="docAppr" value="# ${entity[fieldName].idDatabaseBirth}-${entity[fieldName].idBirth}, ${dateAppr}, ${utlJsp.printNumber(entity[fieldName].itsTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}"/>
  </c:if>
</c:if>
<c:if test="${entity.itsTotal.compareTo(java.math.BigDecimal.ZERO) == 0}">
  <tr>
    <td>
      <label for="${entity.getClass().simpleName}${fieldName}AppearanceVisible">${srvI18n.getMsg(fieldName, reqVars.lang)}</label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input class="picked-appearence" id="${entity.getClass().simpleName}${fieldName}AppearanceVisible" disabled="disabled" type="text" value="${docAppr}" onchange="inputHasBeenChanged(this);">
        <input id="${entity.getClass().simpleName}${fieldName}Id" type="hidden" name="${entity.getClass().simpleName}.${fieldName}" value="${entity[fieldName].itsId}">
        <button type="button" class="btn" onclick="openEntityPicker('${srvOrm.tablesMap[entity.getClass().simpleName].fieldsMap[fieldName].foreignEntity}','${entity.getClass().simpleName}', '${fieldName}', '&fltordPhasMadeAccEntriesVal=true&fltordPforcedFor=hasMadeAccEntries&mobile=${param.mobile}');">...</button>
        <button type="button" class="btn" onclick="clearSelectedEntity('${entity.getClass().simpleName}${fieldName}');">X</button>
      </div>
    </td>
  </tr>
</c:if>
<c:if test="${not empty entity[fieldName]}">
  <tr>
    <td>
      <label for="${entity.getClass().simpleName}${fieldName}AppearanceVisible">${srvI18n.getMsg(fieldName, reqVars.lang)}</label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input class="picked-appearence" id="${entity.getClass().simpleName}${fieldName}AppearanceVisible" disabled="disabled" type="text" value="${docAppr}" onchange="inputHasBeenChanged(this);">
        <input id="${entity.getClass().simpleName}${fieldName}Id" type="hidden" name="${entity.getClass().simpleName}.${fieldName}" value="${entity[fieldName].itsId}">
      </div>
    </td>
  </tr>
  <tr>
    <td>
      <label>${srvI18n.getMsg("omitTaxes", reqVars.lang)}
        <c:if test="${!entity.omitTaxes}">
          , ${srvI18n.getMsg("priceIncTax", reqVars.lang)}
        </c:if>
      </label>
    </td>
  <tr>
  </tr>
    <td>
      <div class="input-line">
        <input disabled value="${srvI18n.getMsg(entity.omitTaxes, reqVars.lang)}, ${srvI18n.getMsg(entity.priceIncTax, reqVars.lang)}"/> 
      </div>
    </td>
  </tr>
  <c:if test="${entity.foreignCurrency != null}">
    <tr>
      <td>
        <label for="${entity.getClass().simpleName}foreignCurrencyAppearanceVisible">
            ${srvI18n.getMsg("foreignCurrency", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input class="picked-appearence" id="${entity.getClass().simpleName}foreignCurrencyAppearanceVisible" disabled="disabled" type="text" value="${entity.foreignCurrency.itsName}"/>
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label for="${entity.getClass().simpleName}.exchangeRate">
            ${srvI18n.getMsg("exchangeRate", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}exchangeRate" disabled="disabled" class="bsNum4m" value="${entity.exchangeRate}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label for="${entity.getClass().simpleName}.foreignSubtotal">
            ${srvI18n.getMsg("foreignSubtotal", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}foreignSubtotal" disabled="disabled" class="bsNum${reqVars.priceDp}" value="${entity.foreignSubtotal}"/> 
          <input type="hidden" name="${entity.getClass().simpleName}.foreignSubtotal" value="${entity.foreignSubtotal}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label for="${entity.getClass().simpleName}.foreignTotalTaxes">
            ${srvI18n.getMsg("foreignTotalTaxes", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}foreignTotalTaxes" disabled="disabled" class="bsNum${reqVars.priceDp}" value="${entity.foreignTotalTaxes}"/> 
          <input type="hidden" name="${entity.getClass().simpleName}.foreignTotalTaxes" value="${entity.foreignTotalTaxes}"/> 
        </div>
      </td>
    </tr>
    <tr>
      <td>
        <label for="${entity.getClass().simpleName}.foreignTotal">
            ${srvI18n.getMsg("foreignTotal", reqVars.lang)}
        </label>
      </td>
    <tr>
    </tr>
      <td>
        <div class="input-line">
          <input type="text" id="${entity.getClass().simpleName}foreignTotal" disabled="disabled" class="bsNum${reqVars.priceDp}" value="${entity.foreignTotal}"/> 
          <input type="hidden" name="${entity.getClass().simpleName}.foreignTotal" value="${entity.foreignTotal}"/> 
        </div>
      </td>
    </tr>
  </c:if>
</c:if>
