<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:if test="${isTaxable && isItemBasis}">
  <c:if test="${not empty taxDestination}">
    ${taxDestination.itsName}: ${srvI18n.getMsg("salTaxRoundMode", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxRoundMode, reqVars.lang)},
    ${srvI18n.getMsg("salTaxIsInvoiceBase", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxIsInvoiceBase, reqVars.lang)},
    ${srvI18n.getMsg("salTaxUseAggregItBas", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxUseAggregItBas, reqVars.lang)}
    <br>
  </c:if>
  <c:set var="taxesTl" value="0"/>
  ${srvI18n.getMsg("taxes", reqVars.lang)}:
  <c:forEach var="entity" items="${ownedListsMapEntry.value}" varStatus="vs">
    <c:if test="${!vs.isFirst()}">; </c:if>
    ${entity.tax.itsName}
    <c:if test="${reqVars.accSet.salTaxIsInvoiceBase}">
      * ${utlJsp.printNumber(entity.taxableInvBas.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)} =
    </c:if>
    ${utlJsp.printNumber(entity.itsTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
    <c:set var="taxesTl" value="${entity.itsTotal + taxesTl}"/>
  </c:forEach>
  <br> <b>${srvI18n.getMsg("totalTaxes", reqVars.lang)}: ${utlJsp.printNumber(taxesTl.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)} ${reqVars.curSign}</b>
</c:if>
<c:if test="${isTaxable && !isItemBasis}">
  <div class="title-list">${srvI18n.getMsg("taxes", reqVars.lang)}:</div>
  <c:if test="${not empty taxDestination}">
    ${taxDestination.itsName}: ${srvI18n.getMsg("salTaxRoundMode", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxRoundMode, reqVars.lang)},
    ${srvI18n.getMsg("salTaxIsInvoiceBase", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxIsInvoiceBase, reqVars.lang)},
    ${srvI18n.getMsg("salTaxUseAggregItBas", reqVars.lang)}=${srvI18n.getMsg(taxDestination.salTaxUseAggregItBas, reqVars.lang)}
    <br>
  </c:if>
  <c:set var="taxesTl" value="0"/>
  <table>
    <tr>
      <th>${srvI18n.getMsg("tax", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("taxableInvBas", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("itsTotal", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("Actions", reqVars.lang)}</th>
    </tr>
    <c:forEach var="entity" items="${ownedListsMapEntry.value}">
      <tr>
        <td>
          ${entity.tax.itsName}
        </td>
        <td style="text-align: right;">
          ${utlJsp.printNumber(entity.taxableInvBas.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
        </td>
        <td style="text-align: right;">
          ${utlJsp.printNumber(entity.itsTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
        </td>
        <td>
          <button class="btn" onclick="getHtmlByAjaxCareful('GET', 'service?nmRnd=editEntityFolJson&nmsAct=entityEdit&nmEnt=${entity.getClass().simpleName}&${entity.getClass().simpleName}.itsId=${entity.itsId}${ownerVersion}${flyParams}');">${srvI18n.getMsg("Edit", reqVars.lang)}</button>
        </td>
      </tr>
      <c:set var="taxesTl" value="${entity.itsTotal + taxesTl}"/>
    </c:forEach>
  </table>
  <b>${srvI18n.getMsg("totalTaxes", reqVars.lang)}: ${utlJsp.printNumber(taxesTl.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)} ${reqVars.curSign}</b>
</c:if>
