<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../static/css/beige.print-a4.css" />
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <link rel="stylesheet" type="text/css" href="../static/css/beige.reports.css" />
  <title>${srvI18n.getMsg(entity.getClass().simpleName, reqVars.lang)}</title>
</head>
<body>


<div class="organizationData">
  <b>${reqVars.accSet.organization}</b><br/>
  <c:if test="${not empty reqVars.accSet.taxIdentificationNumber}">
    ${srvI18n.getMsg('taxIdentificationNumber', reqVars.lang)}: ${reqVars.accSet.taxIdentificationNumber}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regZip}">
    ${srvI18n.getMsg('regZip', reqVars.lang)}: ${reqVars.accSet.regZip}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regAddress1}">
    ${srvI18n.getMsg('regAddress1', reqVars.lang)}: ${reqVars.accSet.regAddress1}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regAddress2}">
    ${srvI18n.getMsg('regAddress2', reqVars.lang)}: ${reqVars.accSet.regAddress2}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regCity}">
    ${srvI18n.getMsg('regCity', reqVars.lang)}: ${reqVars.accSet.regCity}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regState}">
    ${srvI18n.getMsg('regState', reqVars.lang)}: ${reqVars.accSet.regState}<br/>
  </c:if>
  <c:if test="${not empty reqVars.accSet.regCountry}">
    ${srvI18n.getMsg('regCountry', reqVars.lang)}: ${reqVars.accSet.regCountry}<br/>
  </c:if>
</div>
<div class="doc-title">${srvI18n.getMsg('Invoice', reqVars.lang)} #
  <c:if test="${empty entity.idBirth}">
    ${entity.idDatabaseBirth}-${entity.itsId}
  </c:if>
  <c:if test="${not empty entity.idBirth}">
    ${entity.idDatabaseBirth}-${entity.idBirth}
  </c:if>
  <fmt:formatDate value="${entity.itsDate}" type="date" timeStyle="short"/>
</div>
<div class="entity">
  <b>${srvI18n.getMsg('customer', reqVars.lang)}:</b>
  <div class="customerData">
    ${entity.customer.itsName}
    <c:if test="${not empty entity.customer.taxIdentificationNumber}">
      <br/>${srvI18n.getMsg('taxIdentificationNumber', reqVars.lang)}: ${entity.customer.taxIdentificationNumber}
    </c:if>
    <c:if test="${not empty entity.customer.regZip}">
      <br/>${srvI18n.getMsg('regZip', reqVars.lang)}: ${entity.customer.regZip}
    </c:if>
    <c:if test="${not empty entity.customer.regAddress1}">
      <br/>${srvI18n.getMsg('regAddress1', reqVars.lang)}: ${entity.customer.regAddress1}
    </c:if>
    <c:if test="${not empty entity.customer.regAddress2}">
      <br/>${srvI18n.getMsg('regAddress2', reqVars.lang)}: ${entity.customer.regAddress2}
    </c:if>
    <c:if test="${not empty entity.customer.regCity}">
      <br/>${srvI18n.getMsg('regCity', reqVars.lang)}: ${entity.customer.regCity}
    </c:if>
    <c:if test="${not empty entity.customer.regState}">
      <br/>${srvI18n.getMsg('regState', reqVars.lang)}: ${entity.customer.regState}
    </c:if>
    <c:if test="${not empty entity.customer.regCountry}">
      <br/>${srvI18n.getMsg('regCountry', reqVars.lang)}: ${entity.customer.regCountry}
    </c:if>
  </div>
  <br/>
  <c:set var="doc" value="${entity}"/>
  <c:set var="orderPrintList" value="orderPrintList" scope="request"/>
  <jsp:include page="printOwnedList.jsp"/>
  <div>
    <div class="totals">
      <b>${srvI18n.getMsg('subtotal', reqVars.lang)}:</b>
      ${utlJsp.printNumber(doc.subtotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}<br/>
      <b>${srvI18n.getMsg('totalTaxes', reqVars.lang)}:</b>
      ${utlJsp.printNumber(doc.totalTaxes.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}<br/>
      <b>${srvI18n.getMsg('itsTotal', reqVars.lang)}:</b>
      ${utlJsp.printNumber(doc.itsTotal.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
    </div>
  </div>
</div>
</body>
</html>
