<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurr}" scope="request"/>
<jsp:useBean id="now" class="java.util.Date" />
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <title>${srvI18n.getMsg("RefreshItemsInList", reqVars.lang)} <fmt:formatDate value="${now}" type="both" timeStyle="short"/></title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${srvI18n.getMsg("RefreshItemsInList", reqVars.lang)} <fmt:formatDate value="${now}" type="both" timeStyle="short"/><br></br>
      ${reqVars.accSet.organization}
    </h4>
  </div>
  <p>
    <table>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedGdSp", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedGdSp}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedGdAv", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedGdAv}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedGdPr", reqVars.lang)}:
        </td>
        <td>
            ${totalUpdatedGdPr}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedServSp", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedServSp}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedServAv", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedServAv}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedServPr", reqVars.lang)}:
        </td>
        <td>
            ${totalUpdatedServPr}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeGoodSp", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedSeGoodSp}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeGoodAv", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedSeGoodAv}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeGoodPr", reqVars.lang)}:
        </td>
        <td>
            ${totalUpdatedSeGoodPr}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeServiceSp", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedSeServiceSp}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeServiceAv", reqVars.lang)}:
        </td>
        <td>
          ${totalUpdatedSeServiceAv}
        </td>
      </tr>
      <tr>
        <td>
          ${srvI18n.getMsg("totalUpdatedSeServicePr", reqVars.lang)}:
        </td>
        <td>
            ${totalUpdatedSeServicePr}
        </td>
      </tr>
    </table>
  </p>
</body>
</html>
