<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <script type="text/javascript" src="../static/js/beige.i18n.${reqVars.lang}.js"></script>
  <script type="text/javascript" src="../static/js/jquery-3.3.1.min.js"></script>
  <script type="text/javascript" src="../static/js/beige.num.js"></script>
  <script type="text/javascript" src="../static/js/bsNumeric.js"></script>
  <script type="text/javascript" src="../static/js/beige.ajax.js"></script>
  <script type="text/javascript" src="../static/js/beige.form.js"></script>
  <script type="text/javascript" src="../static/js/beige.accounting.js"></script>
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <link rel="stylesheet" href="../static/css/beige.common.css" />
  <title>Beigesoft™ Web Store Admin</title>
</head>
<body>

  <div class="navbar">
    <div class="dropdown">
      <a href="#" class="dropdown-btn">${srvI18n.getMsg("CatalogGs", reqVars.lang)}</a>
      <div class="dropdown-content">
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeGoods&page=1');">${srvI18n.getMsg("SeGoodss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeService&page=1');">${srvI18n.getMsg("SeServices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nSeGoods&page=1');">${srvI18n.getMsg("I18nSeGoodss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=I18nSeService&page=1');">${srvI18n.getMsg("I18nSeServices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeGoodsPlace&page=1');">${srvI18n.getMsg("SeGoodsPlaces", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeServicePlace&page=1');">${srvI18n.getMsg("SeServicePlaces", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeGoodsSpecifics&page=1');">${srvI18n.getMsg("SeGoodsSpecificss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeServiceSpecifics&page=1');">${srvI18n.getMsg("SeServiceSpecificss", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeGoodsPrice&page=1');">${srvI18n.getMsg("SeGoodsPrices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=SeServicePrice&page=1');">${srvI18n.getMsg("SeServicePrices", reqVars.lang)}</a>
         <a href="#" onclick="getHtmlByAjax('GET', 'service?nmsAct=list&nmRnd=listWholeJson&nmEnt=CuOrSe&page=1');">${srvI18n.getMsg("CuOrSes", reqVars.lang)}</a>
      </div>
    </div>
    <div class="dropdown">
      <a href="#" class="dropdown-btn">...</a>
      <div class="dropdown-content">
        <a href="../">${srvI18n.getMsg("exit", reqVars.lang)}</a>
        <c:if test="${not empty pageContext['request'].userPrincipal}">
          <a href="../?logoff=true">${pageContext['request'].userPrincipal.name} ${srvI18n.getMsg("logout", reqVars.lang)}</a>
        </c:if>
      </div>
    </div>
  </div>  

  <div id="lstMainPlace">
  </div>
  
  <div id="frmMainPlace">
  </div>

  <div id="frmSubPlace">
  </div>

  <div id="frmReport">
  </div>

  <div id="frmReplicate">
  </div>

  <div id="pickersPlace">
  </div>

  <div id="pickersPlaceDub">
  </div>

  <div id="targetInfo">
  </div>

  <dialog id="dlgConfirm" class="dlg dlg-alert">
      <div class="confirm">
        <div class="dialog-title confirm-title">
          Conformation.
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn-close btn-confirm">x</button>
        </div>
        <div id="confirmPlace" class="msg-place">
        </div>
        <div class="dlg-actions">
          <button id="confirmYes" class="btn btn-act btn-confirm">${srvI18n.getMsg("Yes", reqVars.lang)}</button>
          <button onclick="document.getElementById('dlgConfirm').close();" class="btn btn-act btn-confirm">${srvI18n.getMsg("No", reqVars.lang)}</button>
        </div>
     </div>
  </dialog>

  <dialog id="dlgError" class="dlg dlg-alert">
    <div class="error">
      <div class="dialog-title error-title">
        Error!
        <button onclick="document.getElementById('dlgError').close()" class="btn-close btn-error">x</button>
      </div>
      <div id="errorPlace" class="msg-place">
      </div>
   </div>
  </dialog>

  <dialog id="dlgWarning" class="dlg dlg-alert">
    <div class="warning">
      <div class="dialog-title warning-title">
        Warning!
        <button onclick="document.getElementById('dlgWarning').close()" class="btn-close btn-warning">x</button>
      </div>
      <div id="warningPlace" class="msg-place">
      </div>
   </div>
  </dialog>

  <div id="dlgSuccess" class="dlg-notifier">
    <div class="success">
      <div class="dialog-title success-title">
        Success!
        <button onclick="document.getElementById('dlgSuccess').close()" class="btn-close btn-success">x</button>
      </div>
      <div id="successPlace" class="msg-place">
      </div>
   </div>
  </div>

</body>
</html>
