<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<c:if test="${pur == null}">
  <jsp:include page="${param.nmRndRed}.jsp"/>
</c:if>
<c:if test="${pur != null}">
  <c:set var="urlPrf" value="../" scope="request"/>
  <c:set var="catalogId" value="${param.catalogId}" scope="request"/>
  <jsp:include page="webstoreStart.jsp"/>

  <div class="card cat-name">
    <div class="card-header">
      <h3>${srvI18n.getMsg("ACCEPTED", reqVars.lang)}</h3>
    </div>
    <div class="card-body">
      <c:forEach var="ord" items="${pur.ords}">
        <h5>${srvI18n.getMsg("CustOrder", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.itsName}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName}:</h5>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead>
              <tr>
                <th>${srvI18n.getMsg("item", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("uom", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("price", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("quant", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                  <th>${srvI18n.getMsg("totTx", reqVars.lang)}</th>
                </c:if>
              </tr>
            </thead>
            <tbody>
              <c:forEach var="il" items="${ord.goods}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
              <c:forEach var="il" items="${ord.servs}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
            </tbody>
          </table>
        </div>
        <c:if test="${ord.totTx.doubleValue() gt 0}">
          <h5>${srvI18n.getMsg("taxes", reqVars.lang)}
          <c:if test="${not empty txRules}">
            <c:if test="${txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("inv_basis", reqVars.lang)},
            </c:if>
            <c:if test="${!txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("it_basis", reqVars.lang)},
            </c:if>
            <c:if test="${txRules.salTaxUseAggregItBas}">
              ${srvI18n.getMsg("aggrOnly", reqVars.lang)},
            </c:if>
            ${srvI18n.getMsg(txRules.salTaxRoundMode, reqVars.lang)}):
          </c:if></h5>
          <div class="table-responsive">
            <table class="table table-sm">
              <thead>
                <tr>
                  <th>${srvI18n.getMsg("tax", reqVars.lang)}</th>
                  <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                </tr>
              </thead>
              <tbody>
                <c:forEach var="txLn" items="${ord.taxes}">
                  <tr>
                    <td>${txLn.tax.itsName}</td>
                    <td>${txLn.tot}${ord.curr.itsName}</td>
                  </tr>
                </c:forEach>
              </tbody>
            </table>
          </div>
        </c:if>
        <h6>${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)}</h6>
        <h6>${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}</h6>
        <c:if test="${not empty ord.place}">
          <h6>${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}</h6>
        </c:if>
      </c:forEach>
      <c:forEach var="ord" items="${pur.sords}">
        <h5>${srvI18n.getMsg("CustOrder", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg("seller", reqVars.lang)}: ${ord.sel.seller.itsName}, ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.itsName}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName}:</h5>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead>
              <tr>
                <th>${srvI18n.getMsg("item", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("uom", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("price", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("quant", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                  <th>${srvI18n.getMsg("totTx", reqVars.lang)}</th>
                </c:if>
              </tr>
            </thead>
            <tbody>
              <c:forEach var="il" items="${ord.goods}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
              <c:forEach var="il" items="${ord.servs}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
            </tbody>
          </table>
        </div>
        <c:if test="${ord.totTx.doubleValue() gt 0}">
          <h5>${srvI18n.getMsg("taxes", reqVars.lang)}
          <c:if test="${not empty txRules}">
            <c:if test="${txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("inv_basis", reqVars.lang)},
            </c:if>
            <c:if test="${!txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("it_basis", reqVars.lang)},
            </c:if>
            <c:if test="${txRules.salTaxUseAggregItBas}">
              ${srvI18n.getMsg("aggrOnly", reqVars.lang)},
            </c:if>
            ${srvI18n.getMsg(txRules.salTaxRoundMode, reqVars.lang)}):
          </c:if></h5>
          <div class="table-responsive">
            <table class="table table-sm">
              <thead>
                <tr>
                  <th>${srvI18n.getMsg("tax", reqVars.lang)}</th>
                  <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                </tr>
              </thead>
              <tbody>
                <c:forEach var="txLn" items="${ord.taxes}">
                  <tr>
                    <td>${txLn.tax.itsName}</td>
                    <td>${txLn.tot}${ord.curr.itsName}</td>
                  </tr>
                </c:forEach>
              </tbody>
            </table>
          </div>
        </c:if>
        <h6>${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)}</h6>
        <h6>${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}</h6>
        <c:if test="${not empty ord.place}">
          <h6>${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}</h6>
        </c:if>
      </c:forEach>
    </div>
  </div>

  <jsp:include page="webstoreI18n.jsp"/>
  <jsp:include page="webstoreEnd.jsp"/>
</c:if>
