<%@ page language="java" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${reqVars.localeCurr}" scope="request"/>
<jsp:useBean id="now" class="java.util.Date" />
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <link rel="stylesheet" type="text/css" media="print" href="../static/css/beige.print-a4.css" />
  <link rel="stylesheet" type="text/css" href="../static/css/beige.reports.css" />
  <link rel="icon" type="image/png" href="../static/img/favicon.png">
  <title>${srvI18n.getMsg("warehouse_site_rests", reqVars.lang)} <fmt:formatDate value="${now}" type="both" timeStyle="short"/></title>
</head>
<body>
  <div style="text-align: center;">
    <h4>
      ${srvI18n.getMsg("warehouse_site_rests", reqVars.lang)} <fmt:formatDate value="${now}" type="both" timeStyle="short"/> <br>
      ${reqVars.accSet.organization}
    </h4>
  </div>
  <table>
    <tr>
      <th>${srvI18n.getMsg("warehouse", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("warehouseSite", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("invItem", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("unitOfMeasure", reqVars.lang)}</th>
      <th>${srvI18n.getMsg("itsQuantity", reqVars.lang)}</th>
    </tr>
    <c:set var="warehouseCurr" value=""/>
    <c:set var="warehouseSiteCurr" value=""/>
    <c:forEach var="warehouseSiteRestsLine" items="${warehouseSiteRestsLines}">
      <tr>
        <td>
          <c:if test="${warehouseSiteRestsLine.warehouse != warehouseCurr}">
            <c:set var="warehouseCurr" value="${warehouseSiteRestsLine.warehouse}"/>
            ${warehouseSiteRestsLine.warehouse}
          </c:if>
        </td>
        <td>
          <c:if test="${warehouseSiteRestsLine.warehouseSite != warehouseSiteCurr}">
            <c:set var="warehouseSiteCurr" value="${warehouseSiteRestsLine.warehouseSite}"/>
            ${warehouseSiteRestsLine.warehouseSite}
          </c:if>
        </td>
        <td>${warehouseSiteRestsLine.invItem}</td>
        <td>${warehouseSiteRestsLine.unitOfMeasure}</td>
        <td align="right">${utlJsp.printNumber(warehouseSiteRestsLine.theRest.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
      </tr>
    </c:forEach>
  </table>
</body>
</html>
