<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<c:if test="${orders == null && sorders == null}">
  <jsp:include page="${param.nmRndRed}.jsp"/>
</c:if>
<c:if test="${orders != null || sorders != null}">
  <jsp:include page="webstoreStart.jsp"/>

  <c:set var="ifPayPal" value="${false}"/>
  <c:set var="ifDeliv" value="${false}"/>
  <div class="card cat-name">
    <div class="card-header">
      <h3>${srvI18n.getMsg("check_out", reqVars.lang)}</h3>
    </div>
    <div class="card-body">
      <c:forEach var="ord" items="${orders}">
        <h5>${srvI18n.getMsg("CustOrder", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.stCo}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName}:</h5>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead>
              <tr>
                <th>${srvI18n.getMsg("item", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("uom", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("price", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("quant", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                  <th>${srvI18n.getMsg("totTx", reqVars.lang)}</th>
                </c:if>
              </tr>
            </thead>
            <tbody>
              <c:forEach var="il" items="${ord.goods}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
              <c:forEach var="il" items="${ord.servs}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
            </tbody>
          </table>
        </div>
        <c:if test="${ord.totTx.doubleValue() gt 0}">
          <h5>${srvI18n.getMsg("taxes", reqVars.lang)}
          <c:if test="${not empty txRules}">
            <c:if test="${txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("inv_basis", reqVars.lang)},
            </c:if>
            <c:if test="${!txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("it_basis", reqVars.lang)},
            </c:if>
            <c:if test="${txRules.salTaxUseAggregItBas}">
              ${srvI18n.getMsg("aggrOnly", reqVars.lang)},
            </c:if>
            ${srvI18n.getMsg(txRules.salTaxRoundMode, reqVars.lang)}):
          </c:if></h5>
          <div class="table-responsive">
            <table class="table table-sm">
              <thead>
                <tr>
                  <th>${srvI18n.getMsg("tax", reqVars.lang)}</th>
                  <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                </tr>
              </thead>
              <tbody>
                <c:forEach var="txLn" items="${ord.taxes}">
                  <tr>
                    <td>${txLn.tax.itsName}</td>
                    <td>${txLn.tot}${ord.curr.itsName}</td>
                  </tr>
                </c:forEach>
              </tbody>
            </table>
          </div>
        </c:if>
        <h6>${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)}</h6>
        <h6>${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}</h6>
        <c:if test="${not empty ord.place}">
          <h6>${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}</h6>
        </c:if>
        <c:if test="${ord.deliv ne 'PICKUP'}">
          <c:set var="ifDeliv" value="${true}"/>
        </c:if>
        <c:if test="${ord.payMeth eq 'PAYPAL' || ord.payMeth eq 'PAYPAL_ANY'}">
          <c:set var="ifPayPal" value="${true}"/>
        </c:if>
      </c:forEach>
      <c:forEach var="ord" items="${sorders}">
        <h5>${srvI18n.getMsg("CustOrder", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg("seller", reqVars.lang)}: ${ord.sel.seller.itsName}, ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.stCo}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName}:</h5>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead>
              <tr>
                <th>${srvI18n.getMsg("item", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("uom", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("price", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("quant", reqVars.lang)}</th>
                <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                  <th>${srvI18n.getMsg("totTx", reqVars.lang)}</th>
                </c:if>
              </tr>
            </thead>
            <tbody>
              <c:forEach var="il" items="${ord.goods}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
              <c:forEach var="il" items="${ord.servs}">
                <tr>
                  <td>${il.itsName} ${il.descr}</td>
                  <td>${il.uom.itsName}</td>
                  <td>${utlJsp.printNumber(il.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.quantityDp, reqVars.digInGr)}</td>
                  <td>${utlJsp.printNumber(il.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl && !txRules.salTaxIsInvoiceBase}">
                    <td>${utlJsp.printNumber(il.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${ord.curr.itsName}</td>
                  </c:if>
                </tr>
              </c:forEach>
            </tbody>
          </table>
        </div>
        <c:if test="${ord.totTx.doubleValue() gt 0}">
          <h5>${srvI18n.getMsg("taxes", reqVars.lang)}
          <c:if test="${not empty txRules}">
            <c:if test="${txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("inv_basis", reqVars.lang)},
            </c:if>
            <c:if test="${!txRules.salTaxIsInvoiceBase}">
              (${srvI18n.getMsg("it_basis", reqVars.lang)},
            </c:if>
            <c:if test="${txRules.salTaxUseAggregItBas}">
              ${srvI18n.getMsg("aggrOnly", reqVars.lang)},
            </c:if>
            ${srvI18n.getMsg(txRules.salTaxRoundMode, reqVars.lang)}):
          </c:if></h5>
          <div class="table-responsive">
            <table class="table table-sm">
              <thead>
                <tr>
                  <th>${srvI18n.getMsg("tax", reqVars.lang)}</th>
                  <th>${srvI18n.getMsg("tot", reqVars.lang)}</th>
                </tr>
              </thead>
              <tbody>
                <c:forEach var="txLn" items="${ord.taxes}">
                  <tr>
                    <td>${txLn.tax.itsName}</td>
                    <td>${txLn.tot}${ord.curr.itsName}</td>
                  </tr>
                </c:forEach>
              </tbody>
            </table>
          </div>
        </c:if>
        <h6>${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)}</h6>
        <h6>${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}</h6>
        <c:if test="${not empty ord.place}">
          <h6>${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}</h6>
        </c:if>
        <c:if test="${ord.deliv ne 'PICKUP'}">
          <c:set var="ifDeliv" value="${true}"/>
        </c:if>
        <c:if test="${ord.payMeth eq 'PAYPAL' || ord.payMeth eq 'PAYPAL_ANY'}">
          <c:set var="ifPayPal" value="${true}"/>
        </c:if>
      </c:forEach>
      <c:if test="${ifDeliv}">
        <h5>${srvI18n.getMsg("shipping_address", reqVars.lang)}:</h5>
        <div class="table-responsive">
          <table class="table table-sm">
            <tbody>
              <tr>
                <td>${srvI18n.getMsg("Erecipient", reqVars.lang)}</td>
                <td>${buyr.itsName}</td>
              </tr>
              <c:if test="${not empty buyr.regCountry}">
                <tr>
                  <td>${srvI18n.getMsg("regCountry", reqVars.lang)}</td>
                  <td>${buyr.regCountry}</td>
                </tr>
              </c:if>
              <c:if test="${not empty buyr.regState}">
                <tr>
                  <td>${srvI18n.getMsg("regState", reqVars.lang)}</td>
                  <td>${buyr.regState}</td>
                </tr>
              </c:if>
              <c:if test="${not empty buyr.regCity}">
                <tr>
                  <td>${srvI18n.getMsg("regCity", reqVars.lang)}</td>
                  <td>${buyr.regCity}</td>
                </tr>
              </c:if>
              <tr>
                <td>${srvI18n.getMsg("regZip", reqVars.lang)}</td>
                <td>${buyr.regZip}</td>
              </tr>
              <tr>
                <td>${srvI18n.getMsg("regAddress1", reqVars.lang)}</td>
                <td>${buyr.regAddress1}</td>
              </tr>
              <c:if test="${not empty buyr.regAddress2}">
                <tr>
                  <td>${srvI18n.getMsg("regAddress2", reqVars.lang)}</td>
                  <td>${buyr.regAddress2}</td>
                </tr>
              </c:if>
              <c:if test="${not empty buyr.regPhone}">
                <tr>
                  <td>${srvI18n.getMsg("regPhone", reqVars.lang)}</td>
                  <td>${buyr.regPhone}</td>
                </tr>
              </c:if>
              <tr>
                <td>${srvI18n.getMsg("regEmail", reqVars.lang)}</td>
                <td>${buyr.regEmail}</td>
              </tr>
            </tbody>
          </table>
        </div>
      </c:if>
      <c:if test="${ifPayPal}">
        <div id="paypal-button"></div>
      </c:if>
      <c:if test="${!ifPayPal}">
        <a href="ntr/?nmPrc=PrPur&nmRnd=waor&nmRndRed=webstore&nmPrcRed=PrcWebstorePage" type="button" class="btn btn-lg btn-block btn-primary">${srvI18n.getMsg("accept", reqVars.lang)}</a>
      </c:if>
    </div>
  </div>


  <jsp:include page="webstoreI18n.jsp"/>

  <jsp:include page="webstoreCart.jsp"/>
  
  <c:if test="${ifPayPal}">
    <script src="https://www.paypalobjects.com/api/checkout.js"></script>
    <script>
      paypal.Button.render({
        env: '${pmde}', // 'sandbox' or 'production'
        // Set up the payment:
        // 1. Add a payment callback
        payment: function(data, actions) {
          // 2. Make a request to your server
          return actions.request.post('ntr/?nmPrc=PrPpl&nmRnd=ppl&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}&catalogId=${catalogId}')
            .then(function(res) {
              // 3. Return res.id from the response
              return res.id;
            });
        },
        // Execute the payment:
        // 1. Add an onAuthorize callback
        onAuthorize: function(data, actions) {
          // 2. Make a request to your server
          return actions.request.post('ntr/?nmPrc=PrPpl&nmRnd=ppl&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}&catalogId=${catalogId}', {
            paymentID: data.paymentID,
            payerID:   data.payerID
          })
            .then(function(res) {
              // 3. Show the buyer a confirmation message:
              window.location.assign('ntr/?nmPrc=PrBur&nmRnd=waor&pur=${orders[0].pur}&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}&catalogId=${catalogId}');
            });
        }
      }, '#paypal-button');
    </script>
  </c:if>

  <jsp:include page="webstoreEnd.jsp"/>
</c:if>
