<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<c:if test="${isUnSign}">
<!-- Buyer sign-in/up -->
  <div class="modal fade" id="signMdl" tabindex="-1" role="dialog" aria-labelledby="signMdlLabel">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="signMdlLabel"><span class="oi oi-account-login" aria-hidden="true"></span>
            <c:if test="${empty buyr.registeredPassword}">
              ${srvI18n.getMsg("signUp", reqVars.lang)}/${srvI18n.getMsg("signIn", reqVars.lang)}
            </c:if>
            <c:if test="${not empty buyr.registeredPassword}">
              ${srvI18n.getMsg("signIn", reqVars.lang)}
            </c:if>
          </h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
          <form action="${urlPrf}?" method="POST">
            <input type="hidden" name="nmRnd" value="${param.nmRnd}">
            <input type="hidden" name="nmRndRed" value="${nmRndRed}">
            <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
            <input type="hidden" name="nmPrc" value="PrLog">
            <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
              <c:if test="${enr.key ne 'fltCtVal'}">
                <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                  <input type="hidden" name="${enr.key}" value="${enr.value}">
                </c:if>
                <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                  <c:forEach var="cv" items="${enr.value.split(';')}">
                    <input type="hidden" name="${enr.key}" value="${cv}">
                  </c:forEach>
                </c:if>
              </c:if>
              <c:if test="${enr.key eq 'fltCtVal'}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="fltCtVal" value="${cv}">
                </c:forEach>
              </c:if>
            </c:forEach>
            <c:if test="${not empty buyr.registeredPassword}">
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  ${srvI18n.getMsg("itsName", reqVars.lang)}
                </div>
                <div class="col-12 col-md-8 mb-3">
                  ${buyr.itsName}
                </div>
              </div>
            </c:if>
            <c:if test="${empty buyr.registeredPassword}">
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  <label>${srvI18n.getMsg("itsName", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-8 mb-3">
                  <input required name="nm" class="form-control" value="${buyr.itsName}">
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  <label>${srvI18n.getMsg("itsEmail", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-8 mb-3">
                  <input required type="email" name="em" class="form-control" value="${buyr.regEmail}">
                </div>
              </div>
            </c:if>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("user_pass", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input type="password" required name="pw" class="form-control">
              </div>
            </div>
            <c:if test="${empty buyr.registeredPassword}">
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  <label>${srvI18n.getMsg("user_pass_rep", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-8 mb-3">
                  <input type="password" required name="pwc" class="form-control">
                </div>
              </div>
            </c:if>
            <div class="modal-footer">
              <button type="submit" class="btn btn-primary">
                <c:if test="${empty buyr.registeredPassword}">
                  ${srvI18n.getMsg("signUp", reqVars.lang)}
                </c:if>
                <c:if test="${not empty buyr.registeredPassword}">
                  ${srvI18n.getMsg("signIn", reqVars.lang)}
                </c:if>
              </button>
              <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            </div>
          </form>
        </div>
        <c:if test="${empty buyr.registeredPassword}">
          <div class="modal-body">
            <form action="${urlPrf}?" method="POST">
              <input type="hidden" name="nmRnd" value="${param.nmRnd}">
              <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
              <input type="hidden" name="nmRndRed" value="${nmRndRed}">
              <input type="hidden" name="nmPrc" value="PrLog">
              <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
                <c:if test="${enr.key ne 'fltCtVal'}">
                  <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                    <input type="hidden" name="${enr.key}" value="${enr.value}">
                  </c:if>
                  <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                    <c:forEach var="cv" items="${enr.value.split(';')}">
                      <input type="hidden" name="${enr.key}" value="${cv}">
                    </c:forEach>
                  </c:if>
                </c:if>
                <c:if test="${enr.key eq 'fltCtVal'}">
                  <c:forEach var="cv" items="${enr.value.split(';')}">
                    <input type="hidden" name="fltCtVal" value="${cv}">
                  </c:forEach>
                </c:if>
              </c:forEach>
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  <label>${srvI18n.getMsg("itsEmail", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-8 mb-3">
                  <input required type="email" name="em" class="form-control" value="${buyr.regEmail}">
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-4 mb-3">
                  <label>${srvI18n.getMsg("user_pass", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-8 mb-3">
                  <input type="password" required name="pw" class="form-control">
                </div>
              </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-primary">${srvI18n.getMsg("signIn", reqVars.lang)}</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
              </div>
            </form>
          </div>
        </c:if>
      </div>
    </div>
  </div>
</c:if>

<!-- Modal cart item adder -->
<div class="modal fade" id="cartAddMdl" tabindex="-1" role="dialog" aria-labelledby="cartAddMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartAddMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span> ${srvI18n.getMsg("add_item_to_cart", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="${urlPrf}?" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmRndRed" value="${nmRndRed}">
          <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
          <input type="hidden" name="nmPrc" value="PrcItemInCart">
          <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
            <c:if test="${enr.key ne 'fltCtVal'}">
              <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                <input type="hidden" name="${enr.key}" value="${enr.value}">
              </c:if>
              <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="${enr.key}" value="${cv}">
                </c:forEach>
              </c:if>
            </c:if>
            <c:if test="${enr.key eq 'fltCtVal'}">
              <c:forEach var="cv" items="${enr.value.split(';')}">
                <input type="hidden" name="fltCtVal" value="${cv}">
              </c:forEach>
            </c:if>
          </c:forEach>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("item", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <textarea id="itNm" readonly class="form-control">
              </textarea>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("itsPrice", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="price" readonly class="form-control">
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("unitOfMeasure", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="uomNm" readonly class="form-control">
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-3 mb-3">
              <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
            </div>
            <div class="col-3 col-md-1 mb-3">
              <a href="#" onclick="$('#quant').trigger('decrease').trigger('change');"><span class="oi oi-minus oi-horh" aria-hidden="true"></span></a>
            </div>
            <div class="col-6 col-md-4 mb-3">
              <input id="quant" name="quant" class="form-control">
            </div>
            <div class="col-3 col-md-1 mb-3">
              <a href="#" onclick="$('#quant').trigger('increase').trigger('change');"><span class="oi oi-plus oi-horh" aria-hidden="true"></span></a>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("itsTotal", reqVars.lang)} (${reqVars.wscurr.itsSign})</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="total" readonly class="form-control">
            </div>
          </div>
          <input type="hidden" id="unStep" name="unStep">
          <input type="hidden" id="avQuan" name="avQuan">
          <input type="hidden" id="itTyp" name="itTyp">
          <input type="hidden" id="itId" name="itId">
          <input type="hidden" id="uomId" name="uomId">
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Save", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart item edit -->
<div class="modal fade" id="cartEditMdl" tabindex="-1" role="dialog" aria-labelledby="cartEditMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartEditMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span> ${srvI18n.getMsg("item_change_quantity", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" onclick="$('#cartMdl').modal('show');" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="${urlPrf}?" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
          <input type="hidden" name="nmRndRed" value="${nmRndRed}">
          <input type="hidden" name="nmPrc" value="PrcItemInCart">
          <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
            <c:if test="${enr.key ne 'fltCtVal'}">
              <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                <input type="hidden" name="${enr.key}" value="${enr.value}">
              </c:if>
              <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="${enr.key}" value="${cv}">
                </c:forEach>
              </c:if>
            </c:if>
            <c:if test="${enr.key eq 'fltCtVal'}">
              <c:forEach var="cv" items="${enr.value.split(';')}">
                <input type="hidden" name="fltCtVal" value="${cv}">
              </c:forEach>
            </c:if>
          </c:forEach>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("item", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <textarea id="itNmEdit" readonly class="form-control">
              </textarea>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("itsPrice", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="priceEdit" readonly class="form-control">
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("unitOfMeasure", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="uomNmEdit" readonly class="form-control">
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-3 mb-3">
              <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}</label>
            </div>
            <div class="col-3 col-md-1 mb-3">
              <a href="#" onclick="$('#quantEdit').trigger('decrease').trigger('change');"><span class="oi oi-minus oi-horh" aria-hidden="true"></span></a>
            </div>
            <div class="col-6 col-md-4 mb-3">
              <input id="quantEdit" name="quant" class="form-control">
            </div>
            <div class="col-3 col-md-1 mb-3">
              <a href="#" onclick="$('#quantEdit').trigger('increase').trigger('change');"><span class="oi oi-plus oi-horh" aria-hidden="true"></span></a>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-4 mb-3">
              <label>${srvI18n.getMsg("itsTotal", reqVars.lang)} (${reqVars.wscurr.itsSign})</label>
            </div>
            <div class="col-12 col-md-8 mb-3">
              <input id="totalEdit" readonly class="form-control">
            </div>
          </div>
          <input type="hidden" id="unStepEdit" name="unStep">
          <input type="hidden" id="avQuanEdit" name="avQuan">
          <input type="hidden" id="itTypEdit" name="itTyp">
          <input type="hidden" id="itIdEdit" name="itId">
          <input type="hidden" id="lnIdEdit" name="lnId">
          <input type="hidden" id="uomIdEdit" name="uomId">
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Save", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="$('#cartMdl').modal('show');">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart item remove -->
<div class="modal fade" id="cartDelMdl" tabindex="-1" role="dialog" aria-labelledby="cartDelMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartDelMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span> ${srvI18n.getMsg("item_remove", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" onclick="$('#cartMdl').modal('show');" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="${urlPrf}?" method="POST">
          <input type="hidden" name="nmRnd" value="${param.nmRnd}">
          <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
          <input type="hidden" name="nmRndRed" value="${nmRndRed}">
          <input type="hidden" name="nmPrc" value="PrcDelItemFromCart">
          <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
            <c:if test="${enr.key ne 'fltCtVal'}">
              <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                <input type="hidden" name="${enr.key}" value="${enr.value}">
              </c:if>
              <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="${enr.key}" value="${cv}">
                </c:forEach>
              </c:if>
            </c:if>
            <c:if test="${enr.key eq 'fltCtVal'}">
              <c:forEach var="cv" items="${enr.value.split(';')}">
                <input type="hidden" name="fltCtVal" value="${cv}">
              </c:forEach>
            </c:if>
          </c:forEach>
          <div class="form-group">
            <label>${srvI18n.getMsg("item", reqVars.lang)}:</label>
            <textarea id="itNmDel" readonly class="form-control">
            </textarea>
            <label>Price:</label>
            <input id="priceDel" readonly class="form-control">
            <label>${srvI18n.getMsg("itsQuantity", reqVars.lang)}:</label>
            <input readonly id="quantDel" class="form-control">
            <label>${srvI18n.getMsg("itsTotal", reqVars.lang)}:</label>
            <input id="totalDel" readonly class="form-control">
            <input type="hidden" id="lnIdDel" name="lnId">
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Delete", reqVars.lang)}</button>
            <button type="button" class="btn btn-default" data-dismiss="modal" onclick="$('#cartMdl').modal('show');">${srvI18n.getMsg("Close", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal cart -->
<div class="modal fade" id="cartMdl" tabindex="-1" role="dialog" aria-labelledby="cartMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="cartMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span> ${srvI18n.getMsg("shopping_cart", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <c:forEach var="cartLn" items="${cart.items}">
          <c:if test="${!cartLn.disab}">
            <div class="row">
              <div class="col-4">
                <b>${srvI18n.getMsg("item", reqVars.lang)}:</b>
              </div>
              <div class="col-8">
                <b>${cartLn.itsName}</b>
              </div>
            </div>
            <div class="row">
              <div class="col-4">
                ${srvI18n.getMsg("itsPrice", reqVars.lang)}:
              </div>
              <div class="col-8">
                ${utlJsp.printNumber(cartLn.price.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
              </div>
            </div>
            <div class="row">
              <c:if test="${cartLn.forc}">
                <div class="col-6">
                  ${srvI18n.getMsg("itsQuantity", reqVars.lang)}:
                </div>
                <div class="col-6">
                  ${utlJsp.prnNumberNtz(cartLn.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.digInGr)}
                </div>
              </c:if>
              <c:if test="${!cartLn.forc}">
                <div class="col-4">
                  ${srvI18n.getMsg("itsQuantity", reqVars.lang)}:
                </div>
                <div class="col-4">
                  ${utlJsp.prnNumberNtz(cartLn.quant.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.digInGr)}
                </div>
                <div class="col-2">
                  <a href="#" data-dismiss="modal" onclick="setCartItem(${cartLn.itTyp.ordinal()},${cartLn.itId},'${cartLn.itsName}',${cartLn.price},${cartLn.quant},${cartLn.avQuan},${cartLn.itsId},${cartLn.uom.itsId},'${cartLn.uom.itsName}',${cartLn.unStep},${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()});"><span class="oi oi-pencil" title="${srvI18n.getMsg('edit', reqVars.lang)}" aria-hidden="true"></span></a>
                </div>
                <div class="col-2">
                  <a href="#" data-dismiss="modal" onclick="$('#cartDelMdl').modal({keyboard: false, backdrop: false}); delCartItem(${cartLn.itTyp.ordinal()},${cartLn.itId},'${cartLn.itsName}',${cartLn.price},${cartLn.quant},${cartLn.itsId},${reqVars.priceDp});"><span class="oi oi-x" title="${srvI18n.getMsg('delete', reqVars.lang)}" aria-hidden="true"></span></a>
                </div>
              </c:if>
            </div>
            <div class="row">
              <div class="col-4">
                ${srvI18n.getMsg("itsTotal", reqVars.lang)}:
              </div>
              <div class="col-8">
                ${utlJsp.printNumber(cartLn.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}
              </div>
            </div>
          </c:if>
        </c:forEach>
        <c:if test="${cart.totTx.doubleValue() gt 0}">
          <div class="row">
            <div class="col-6">
              ${srvI18n.getMsg("totalTaxes", reqVars.lang)}:
            </div>
            <div class="col-6">
              <b>${utlJsp.printNumber(cart.totTx.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)} ${reqVars.wscurr.itsSign}</b>
            </div>
          </div>
        </c:if>
        <div class="row">
          <div class="col-6">
            ${srvI18n.getMsg("itsTotal", reqVars.lang)}
            <c:if test="${cart.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)})</c:if>
            <c:if test="${cart.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)})</c:if>:
          </div>
          <div class="col-6">
            <b>${utlJsp.printNumber(cart.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${reqVars.wscurr.itsSign}</b>
          </div>
        </div>
        <c:if test="${cart.totTx.doubleValue() gt 0 && reqVars.shTxDet}">
          <c:forEach var="cartTxLn" items="${cart.taxes}">
            <c:if test="${!cartTxLn.disab}">
              <c:if test="${not empty txs}">
                <c:set var="txs" value="${txs} ${cartTxLn.tax.itsName}=${cartTxLn.tot}"/>
              </c:if>
              <c:if test="${empty txs}">
                <c:set var="txs" value="${cartTxLn.tax.itsName}=${cartTxLn.tot}"/>
              </c:if>
            </c:if>
          </c:forEach>
          <div class="row">
            <div class="col-6">
              ${srvI18n.getMsg("taxes", reqVars.lang)}
              <c:if test="${not empty txRules}">
                <c:if test="${txRules.salTaxIsInvoiceBase}">
                  (${srvI18n.getMsg("inv_basis", reqVars.lang)},
                </c:if>
                <c:if test="${!txRules.salTaxIsInvoiceBase}">
                  (${srvI18n.getMsg("it_basis", reqVars.lang)},
                </c:if>
                <c:if test="${txRules.salTaxUseAggregItBas}">
                  ${srvI18n.getMsg("aggrOnly", reqVars.lang)},
                </c:if>
                ${srvI18n.getMsg(txRules.salTaxRoundMode, reqVars.lang)})</c:if>:
            </div>
            <div class="col-6">
              ${txs}
            </div>
          </div>
        </c:if>
      </div>
      <c:if test="${reqVars.payMts.size() eq 1}">
        <div class="row">
          <div class="col-6">
            ${srvI18n.getMsg("payMeth", reqVars.lang)}:
          </div>
          <div class="col-6">
            ${cart.payMeth}
          </div>
        </div>
      </c:if>
      <c:if test="${reqVars.dlvMts.size() eq 1}">
        <div class="row">
          <div class="col-6">
            ${srvI18n.getMsg("deliv", reqVars.lang)}:
          </div>
          <div class="col-6">
            ${cart.deliv}
          </div>
        </div>
      </c:if>
      <c:if test="${reqVars.payMts.size() gt 1 || reqVars.dlvMts.size() gt 1}">
        <div class="modal-body">
          <form action="${urlPrf}?" method="POST">
            <input type="hidden" name="nmRnd" value="${param.nmRnd}">
            <input type="hidden" name="nmRndRed" value="${nmRndRed}">
            <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
            <input type="hidden" name="nmPrc" value="PrCart">
            <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
              <c:if test="${enr.key ne 'fltCtVal'}">
                <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                  <input type="hidden" name="${enr.key}" value="${enr.value}">
                </c:if>
                <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                  <c:forEach var="cv" items="${enr.value.split(';')}">
                    <input type="hidden" name="${enr.key}" value="${cv}">
                  </c:forEach>
                </c:if>
              </c:if>
              <c:if test="${enr.key eq 'fltCtVal'}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="fltCtVal" value="${cv}">
                </c:forEach>
              </c:if>
            </c:forEach>
            <c:if test="${reqVars.payMts.size() gt 1}">
              <div class="row">
                <div class="col-12 col-md-6 mb-3">
                  <label>${srvI18n.getMsg("payMeth", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-6 mb-3">
                  <select name="payMeth"  class="form-control">
                    <c:forEach var="it" items="${reqVars.payMts}">
                      <c:set var="itmSel" value=""/>
                      <c:if test="${cart.payMeth eq it}">
                        <c:set var="itmSel" value="selected"/>
                      </c:if>
                      <option value="${it.ordinal()}" ${itmSel}>${srvI18n.getMsg(it, reqVars.lang)}</option>
                    </c:forEach>
                  </select>
                </div>
              </div>
            </c:if>
            <c:if test="${reqVars.dlvMts.size() gt 1}">
              <div class="row">
                <div class="col-12 col-md-6 mb-3">
                  <label>${srvI18n.getMsg("Deliv", reqVars.lang)}</label>
                </div>
                <div class="col-12 col-md-6 mb-3">
                  <select name="deliv"  class="form-control">
                    <c:forEach var="it" items="${reqVars.dlvMts}">
                      <c:set var="itmSel" value=""/>
                      <c:if test="${cart.deliv eq it.itsId}">
                        <c:set var="itmSel" value="selected"/>
                      </c:if>
                      <option value="${it.itsId.ordinal()}" ${itmSel}>
                        <c:if test="${empty it.frcSr}">
                          ${srvI18n.getMsg(it.itsId, reqVars.lang)}
                        </c:if>
                        <c:if test="${not empty it.frcSr}">
                          ${it.frcSr.itsName}
                        </c:if>
                      </option>
                    </c:forEach>
                  </select>
                </div>
              </div>
            </c:if>
            <div class="modal-footer">
              <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
            </div>
          </form>
        </div>
      </c:if>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
        <c:if test="${!isUnSign && param.nmPrc ne 'PrcCheckOut'}">
          <a href="${urlPrf}?nmRnd=wchou&nmPrc=PrcCheckOut&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}" type="button" class="btn btn-primary">${srvI18n.getMsg("check_out", reqVars.lang)}</a>
        </c:if>
      </div>
    </div>
  </div>
</div>
