<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<c:if test="${not empty errMsg}">
  <div class="modal fade" id="errDlg" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">${srvI18n.getMsg("Error", reqVars.lang)}!</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
          <h5>${srvI18n.getMsg(errMsg, reqVars.lang)}</h5>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
        </div>
      </div>
    </div>
  </div>
  <script>
    $("#errDlg").modal("show");
  </script>
</c:if>

<div class="modal fade" id="infoDlg" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">${srvI18n.getMsg("About", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <h4>${srvI18n.getMsg("app_name", reqVars.lang)}</h4>
        <h5><a href="https://sites.google.com/site/beigesoftware" target="_blank">Beigesoft™ https://beigesoft.org</a></h5>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
      </div>
    </div>
  </div>
</div>

<c:if test="${!isUnSign}">
  <div class="modal fade" id="logoutDlg" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title"><span class="oi oi-book" aria-hidden="true"></span> ${srvI18n.getMsg("CustOrders", reqVars.lang)} / <span class="oi oi-account-logout" aria-hidden="true"></span> ${srvI18n.getMsg("logout", reqVars.lang)}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
          <h5><a href="${urlPrf}?nmPrc=PrBuOr&nmRnd=wors&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}">${srvI18n.getMsg('CustOrders', reqVars.lang)} <span class="oi oi-book" aria-hidden="true"></span></a></h5>
          <h5><a href="#" data-dismiss="modal" data-toggle="tooltip" title="${srvI18n.getMsg('shipping_address', reqVars.lang)}" onclick="$('#buyrMdl').modal('show');">${srvI18n.getMsg("shipping_address", reqVars.lang)} <span class="oi oi-pencil" aria-hidden="true"></span></a></h5>
        </div>
        <div class="modal-footer">
          <a type="button" class="btn btn-outline-primary" href="${urlPrf}?nmRnd=${nmRndRed}&nmPrc=PrLog&nmPrcRed=${nmPrcRed}">${buyr.itsName} <span class="oi oi-account-logout" aria-hidden="true"></span> ${srvI18n.getMsg("logout", reqVars.lang)}</a>
          <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="buyrMdl" tabindex="-1" role="dialog" aria-labelledby="buyrMdlLabel">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="buyrMdlLabel"><span class="oi oi-cart" aria-hidden="true"></span> ${srvI18n.getMsg("shipping_address", reqVars.lang)}</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
          <form action="${urlPrf}?" method="POST">
            <input type="hidden" name="nmRnd" value="${param.nmRnd}">
            <input type="hidden" name="nmPrcRed" value="${nmPrcRed}">
            <input type="hidden" name="nmRndRed" value="${nmRndRed}">
            <input type="hidden" name="nmPrc" value="PrLog">
            <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
              <c:if test="${enr.key ne 'fltCtVal'}">
                <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                  <input type="hidden" name="${enr.key}" value="${enr.value}">
                </c:if>
                <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                  <c:forEach var="cv" items="${enr.value.split(';')}">
                    <input type="hidden" name="${enr.key}" value="${cv}">
                  </c:forEach>
                </c:if>
              </c:if>
              <c:if test="${enr.key eq 'fltCtVal'}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="fltCtVal" value="${cv}">
                </c:forEach>
              </c:if>
            </c:forEach>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("itsName", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input required name="nm" class="form-control" value="${buyr.itsName}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regCountry", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input name="cnt" class="form-control" value="${buyr.regCountry}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regCity", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input name="cit" class="form-control" value="${buyr.regCity}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regZip", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input required name="zip" class="form-control" value="${buyr.regZip}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regAddress1", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input required name="adr1" class="form-control" value="${buyr.regAddress1}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regAddress2", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input name="adr2" class="form-control" value="${buyr.regAddress2}">
              </div>
            </div>
            <div class="row">
              <div class="col-12 col-md-4 mb-3">
                <label>${srvI18n.getMsg("regPhone", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-8 mb-3">
                <input name="phn" class="form-control" value="${buyr.regPhone}">
              </div>
            </div>
            <div class="modal-footer">
              <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Save", reqVars.lang)}</button>
              <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</c:if>

    </main>

    <button id="toTop">^</button>

    <script>
      $(window).scroll(function() { if ($(this).scrollTop() > 200) { $("#toTop").fadeIn(); } else { $("#toTop").fadeOut(); } });
      $("#toTop").click(function() { $("html, body").animate({scrollTop: 0}, 1000); });
    </script>

  </body>
</html>
