<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>


<!--Modal buyer's preferences-->
<div class="modal fade" id="i18nMdl" tabindex="-1" role="dialog" aria-labelledby="i18nMdlLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="i18nMdlLabel"><span class="oi oi-globe" aria-hidden="true"></span> ${srvI18n.getMsg("changeLangPreferences", reqVars.lang)}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <form action="${urlPrf}?" method="POST">
          <input type="hidden" name="nmRnd" value="${nmRndRed}">
          <input type="hidden" name="nmPrc" value="${nmPrcRed}">
          <c:forEach var="enr" items="${filterUrlFrm.entrySet()}">
            <c:if test="${enr.key ne 'fltCtVal'}">
              <c:if test="${!(enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1)}">
                <input type="hidden" name="${enr.key}" value="${enr.value}">
              </c:if>
              <c:if test="${enr.key.startsWith('fltSp') && enr.value.indexOf(';') != -1}">
                <c:forEach var="cv" items="${enr.value.split(';')}">
                  <input type="hidden" name="${enr.key}" value="${cv}">
                </c:forEach>
              </c:if>
            </c:if>
            <c:if test="${enr.key eq 'fltCtVal'}">
              <c:forEach var="cv" items="${enr.value.split(';')}">
                <input type="hidden" name="fltCtVal" value="${cv}">
              </c:forEach>
            </c:if>
          </c:forEach>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("lang", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="lang" class="form-control">
                <c:forEach var="it" items="${reqVars.languages}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.lang eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${it.itsName}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="decSep"  class="form-control">
                <c:forEach var="it" items="${reqVars.decSeps}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.decSep eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("decimalGroupSep", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="decGrSep"  class="form-control">
                <c:forEach var="it" items="${reqVars.decGrSeps}">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.decGrSep eq it.itsId}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${it.itsId}" ${itmSel}>${srvI18n.getMsg(it.itsName, reqVars.lang)}</option>
                </c:forEach>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("digitsInGroup", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="digInGr"  class="form-control">
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digInGr == 2}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="2" ${itmSel}>2 ${srvI18n.getMsg("Indian", reqVars.lang)}</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digInGr == 3}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="3" ${itmSel}>3</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.digInGr == 4}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="4" ${itmSel}>4</option>
              </select>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-6 mb-3">
              <label>${srvI18n.getMsg("shTxDet", reqVars.lang)}</label>
            </div>
            <div class="col-12 col-md-6 mb-3">
              <select name="shTxDet"  class="form-control">
                <c:set var="itmSel" value=""/>
                <c:if test="${reqVars.shTxDet}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="true" ${itmSel}>${srvI18n.getMsg("true", reqVars.lang)}</option>
                <c:set var="itmSel" value=""/>
                <c:if test="${!reqVars.shTxDet}">
                  <c:set var="itmSel" value="selected"/>
                </c:if>
                <option value="false" ${itmSel}>${srvI18n.getMsg("false", reqVars.lang)}</option>
              </select>
            </div>
          </div>
          <c:if test="${reqVars.currRates.size() gt 0}">
            <div class="row">
              <div class="col-12 col-md-6 mb-3">
                <label>${srvI18n.getMsg("currency", reqVars.lang)}</label>
              </div>
              <div class="col-12 col-md-6 mb-3">
                <select name="wscurr"  class="form-control">
                  <c:set var="itmSel" value=""/>
                  <c:if test="${reqVars.wscurr.itsId.equals(reqVars.accSet.currency.itsId)}">
                    <c:set var="itmSel" value="selected"/>
                  </c:if>
                  <option value="${reqVars.accSet.currency.itsId}" ${itmSel}>${reqVars.accSet.currency.itsName}</option>
                  <c:forEach var="cr" items="${reqVars.currRates}">
                    <c:set var="itmSel" value=""/>
                    <c:if test="${reqVars.wscurr.itsId.equals(cr.curr.itsId)}">
                      <c:set var="itmSel" value="selected"/>
                    </c:if>
                    <option value="${cr.curr.itsId}" ${itmSel}>${cr.curr.itsName} ${srvI18n.getMsg("crate", reqVars.lang)} ${utlJsp.printNumber(cr.rate.toString(), reqVars.decSepv, reqVars.decGrSepv, 4, reqVars.digInGr)}</option>
                  </c:forEach>
                </select>
              </div>
            </div>
          </c:if>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">${srvI18n.getMsg("Close", reqVars.lang)}</button>
            <button type="submit" class="btn btn-primary">${srvI18n.getMsg("Apply", reqVars.lang)}</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

