<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<jsp:useBean id="filterUrlFrm" class="java.util.HashMap" scope="request"/>
<jsp:include page="webstoreStart.jsp"/>

<c:set target="${filterUrlFrm}" property="itemId" value="${param.itemId}"/>
<c:set target="${filterUrlFrm}" property="itemType" value="${param.itemType}"/>
<c:set target="${filterUrlFrm}" property="avQu" value="${param.avQu}"/>
<c:set target="${filterUrlFrm}" property="uoId" value="${param.uoId}"/>
<c:set target="${filterUrlFrm}" property="uoNm" value="${param.uoNm}"/>

<c:if test="${reqVars.wscurr.itsId.equals(reqVars.accSet.currency.itsId)}">
  <c:set var="itPrice" value="${itemPrice.itsPrice}"/>
</c:if>
<c:if test="${!reqVars.wscurr.itsId.equals(reqVars.accSet.currency.itsId)}">
  <c:forEach var="cr" items="${reqVars.currRates}">
    <c:if test="${reqVars.wscurr.itsId.equals(cr.curr.itsId)}">
      <c:if test="${cr.rate.doubleValue() gt 0}">
        <c:set var="curRate" value="${cr.rate}"/>
      </c:if>
      <c:if test="${cr.rate.doubleValue() lt 0}">
        <c:set var="curRate" value="${java.math.BigDecimal.ONE.divide(cr.rate, 15, java.math.RoundingMode.HALF_UP)}"/>
      </c:if>
    </c:if>
  </c:forEach>
  <c:set var="itPrice" value="${itemPrice.itsPrice.multiply(curRate).setScale(reqVars.accSet.pricePrecision,reqVars.accSet.roundingMode)}"/>
</c:if>

<div class="py-3 bg-light">
  <div class="row">
    <c:if test="${not empty itemImage}">
      <div class="col-12 col-md-6 col-lg-4">
        <img class="img-fluid" src="${itemImage.stringValue1}">
      </div>
    </c:if>
    <c:if test="${not empty itemImage}">
      <div class="col-12 col-md-6 col-lg-8">
    </c:if>
    <c:if test="${empty itemImage}">
      <div class="col-12">
    </c:if>
      <h5>
        <c:if test="${not empty itemPrice}">
          <b>${utlJsp.printNumber(itPrice.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)} ${reqVars.wscurr.itsName}</b>
        </c:if>
        ${itemSpecLst.get(0).item.itsName}
      </h5>
      <p>
        ${utlTradeJsp.itemSpecificsStr(reqVars, itemSpecLst)}
      </p>
    </div>
  </div>
</div>

<div class="py-1 text-center bg-light">
  <c:if test="${empty cartItem && not empty itemPrice}">
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#cartAddMdl" onclick="setCartItem(${itType}, ${itemPrice.item.itsId}, '${itemPrice.item.itsName}', ${itPrice}, 1, ${param.avQu}, null,${param.uoId},'${param.uoNm}',${itemPrice.unStep},${reqVars.priceDp},${reqVars.accSet.roundingMode.ordinal()})">${srvI18n.getMsg("buy_it", reqVars.lang)}</button>
  </c:if>
  <c:if test="${not empty cartItem}">
    <button type="button" class="btn btn-primary" onclick="$('#cartMdl').modal('toggle');">${srvI18n.getMsg("open_cart", reqVars.lang)} <span class="badge badge-secondary">${shoppingCart.totalItems}</span></button>
  </c:if>
</div>

<div class="py-3 bg-light">
  <div class="text-center text-muted">
    <h4>${srvI18n.getMsg("item_specifics", reqVars.lang)}</h4>
  </div>
  <div class="specifics">
    <div class="row">
      <c:forEach var="itSp" items="${itemSpecLst}">
        <c:if test="${itSp.specifics.itsType eq 'TEXT'}">
          <div class="col-12 col-md-5">
            <b>${itSp.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${itSp.stringValue1}
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'BIGDECIMAL'}">
          <div class="col-12 col-md-5">
            <b>${itSp.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${itSp.numericValue1}
            <c:if test="${not empty itSp.stringValue1}">
              ${itSp.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'INTEGER'}">
          <div class="col-12 col-md-5">
            <b>${itSp.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${itSp.longValue1}
            <c:if test="${not empty itSp.stringValue1}">
              ${itSp.stringValue1}
            </c:if>
          </div>
        </c:if>
        <c:if test="${itSp.specifics.itsType eq 'CHOOSEABLE_SPECIFICS'}">
          <div class="col-12 col-md-5">
            <b>${itSp.specifics.itsName}: </b>
          </div>
          <div class="col-12 col-md-7">
            ${itSp.stringValue1}
          </div>
        </c:if>
      </c:forEach>
    </div>
  </div>
</div>

<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'FILE_EMBEDDED' && itSp.stringValue1.endsWith('html')}">
    <c:set var="embhtmlnm" value="${utlJsp.evalFileNameWithoutExtension(itSp.stringValue1)}"/>
    <c:set var="flUrl" value="${itSp.stringValue1}"/>
    <c:set var="flNsf" value="_${reqVars.lang}.html"/>
    <c:if test="${not empty itSp.stringValue3 && itSp.stringValue3.contains(reqVars.lang)}">
      <c:set var="flUrl" value="${itSp.stringValue1.replace('.html',flNsf)}"/>
    </c:if>
    <div id="${embhtmlnm}" class="py-3 bg-light embed-html">
    </div>
    <script> $( "#${embhtmlnm}" ).load( "${flUrl} #container" ); </script>
  </c:if>
</c:forEach>

<c:set var="currGroup" value=""/>
<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'IMAGE_IN_SET' && not empty itSp.specifics.itsGroop}">
    <c:if test="${empty currGroup || itSp.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
          </div>
        </div>
      </c:if>
      <c:set var="currGroup" value="${itSp.specifics.itsGroop}"/>
      <div class="album py-3 bg-light">
      <c:if test="${not empty itSp.stringValue4}">
        <div class="text-center text-muted">
          <h4>${itSp.stringValue4}</h4>
        </div>
      </c:if>
      <div class="row">
    </c:if>
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card mb-4 box-shadow">
        <img class="card-img-top" src="${itSp.stringValue1}" alt="Card image cap">
        <c:if test="${not empty itSp.stringValue3}">
          <div class="card-body">
            <p class="card-text">${itSp.stringValue3}</p>
          </div>
        </c:if>
      </div>
    </div>
  </c:if>
  <c:if test="${itSp.specifics.itsType ne 'IMAGE_IN_SET' || empty itSp.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
        </div>
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
    </div>
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<c:forEach var="itSp" items="${itemSpecLst}">
  <c:if test="${itSp.specifics.itsType eq 'FILE' && not empty itSp.specifics.itsGroop}">
    <c:if test="${empty currGroup || itSp.specifics.itsGroop.itsId ne currGroup.itsId}">
      <c:if test="${not empty currGroup}">
        </div>
      </c:if>
      <c:set var="currGroup" value="${itSp.specifics.itsGroop}"/>
      <div class="py-3 bg-light text-center text-muted">
      <c:if test="${not empty itSp.stringValue4}">
        <h4>${itSp.stringValue4}</h4>
      </c:if>
    </c:if>
    <h6><a href="${itSp.stringValue1}">${itSp.stringValue3}</a></h6>
  </c:if>
  <c:if test="${itSp.specifics.itsType ne 'FILE' || empty itSp.specifics.itsGroop}">
    <c:if test="${not empty currGroup}">
      </div>
    </c:if>
    <c:set var="currGroup" value=""/>
  </c:if>
</c:forEach>
<c:if test="${not empty currGroup}">
  </div>
  <c:set var="currGroup" value=""/>
</c:if>

<jsp:include page="webstoreI18n.jsp"/>

<jsp:include page="webstoreCart.jsp"/>

<jsp:include page="webstoreEnd.jsp"/>
