<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<jsp:useBean id="now" class="java.util.Date" />
<fmt:setLocale value="${reqVars.localeCurr}" scope="request"/>
<c:if test="${now.time - buyr.lsTm lt 1800000}">
  <c:set var="isUnSign" value="${false}" scope="request"/>
</c:if>
<c:if test="${now.time - buyr.lsTm gt 1800000}">
  <c:set var="isUnSign" value="${true}" scope="request"/>
</c:if>
<c:if test="${not empty param.nmPrcRed}">
  <c:set var="nmPrcRed" value="${param.nmPrcRed}" scope="request"/>
</c:if>
<c:if test="${empty param.nmPrcRed}">
  <c:set var="nmPrcRed" value="${param.nmPrc}" scope="request"/>
</c:if>
<c:if test="${not empty param.nmRndRed}">
  <c:set var="nmRndRed" value="${param.nmRndRed}" scope="request"/>
</c:if>
<c:if test="${empty param.nmRndRed}">
  <c:set var="nmRndRed" value="${param.nmRnd}" scope="request"/>
</c:if>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="${urlPrf}static/img/favicon.png">

    <title>Beigesoft™ Web Store</title>
    <link href="${urlPrf}static/css/bootstrap.min.css" rel="stylesheet">
    <link href="${urlPrf}static/css/bootstrap-grid.min.css" rel="stylesheet">
    <link href="${urlPrf}static/css/bootstrap-reboot.min.css" rel="stylesheet">
    <link href="${urlPrf}static/css/theme.css" rel="stylesheet">
    <link href="${urlPrf}static/css/open-iconic-bootstrap.min.css" rel="stylesheet">
    <link href="${urlPrf}static/css/flag-icon.min.css" rel="stylesheet">
    <script src="${urlPrf}static/js/jquery-3.3.1.min.js"></script>
    <script src="${urlPrf}static/js/beige.num.js"></script>
    <script src="${urlPrf}static/js/bsInpNumber.js"></script>
    <script src="${urlPrf}static/js/beige.webstore.js"></script>
    <script src="${urlPrf}static/js/popper.min.js"></script>
    <script src="${urlPrf}static/js/bootstrap.min.js"></script>
    <script type="text/javascript">
    jQuery(function($) {
      setVarsNum('${reqVars.decSepv}','${reqVars.decGrSepv}',${reqVars.digInGr});
      $('#quant').bsInpNumber({step: 1});
      $('.bsNum${reqVars.priceDp}').bsInpNumber({decPl: ${reqVars.priceDp}});
      $('.bsNum0').bsInpNumber({decPl: 0});
      $('#quant').on("change", function () {
        refreshCartItemTotal('', ${reqVars.priceDp}, ${reqVars.accSet.roundingMode.ordinal()});
      });
      $('#quantEdit').on("change", function () {
        refreshCartItemTotal('Edit', ${reqVars.priceDp}, ${reqVars.accSet.roundingMode.ordinal()});
      });
    });
    </script>
  </head>

  <body>

    <header id="top">
    <nav class="navbar navbar-expand-sm navbar-dark bg-dark fixed-top">
      <c:if test="${reqVars.tradSet.isShowLogo}">
        <a href="${urlPrf}?nmRnd=webstore&nmPrc=PrcWebstorePage" class="navbar-brand navbar-brand-img"><img src="${urlPrf}static/img/logo-web-store.png"></a>
      </c:if>
      
      <a class="navbar-brand" href="${urlPrf}?nmRnd=webstore&nmPrc=PrcWebstorePage">${utlTradeJsp.webstoreName(reqVars.tradSet, reqVars.i18nWebStoreList, reqVars.lang)}</a>
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbar1" aria-controls="navbar1" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div id="navbar1" class="collapse navbar-collapse">
        <ul class="navbar-nav mr-auto">
          <c:if test="${not empty catalogs}">
            <c:forEach var="cat1l" items="${catalogs}" varStatus="status">
              <c:if test="${cat1l.subcatalogs.size() gt 0}">
                <li class="nav-item dropdown">
                  <a class="nav-link dropdown-toggle" href="#" id="dropdown${status.index}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${utlTradeJsp.catalogToStr(cat1l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                  <div class="dropdown-menu" aria-labelledby="dropdown${status.index}">
                    <a class="dropdown-item" href="${urlPrf}?nmRnd=webstore&nmPrc=PrcWebstorePage&catalogId=${cat1l.catalog.itsId}">${srvI18n.getMsg("All", reqVars.lang)}</a>
                    <c:forEach var="cat2l" items="${cat1l.subcatalogs}">
                      <c:if test="${cat2l.subcatalogs.size() gt 0}">
                        <a class="dropdown-item" href="#" data-toggle="modal" data-target="#subcatalogsMdl${cat2l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat2l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                      </c:if>
                      <c:if test="${cat2l.subcatalogs.size() eq 0}">
                        <a class="dropdown-item" href="${urlPrf}?nmRnd=webstore&nmPrc=PrcWebstorePage&catalogId=${cat2l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat2l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a>
                      </c:if>
                    </c:forEach>
                  </div>
                </li>
              </c:if>
              <c:if test="${cat1l.subcatalogs.size() eq 0 && cat1l.catalog.isInMenu}">
                <li class="nav-item"><a class="nav-link" href="${urlPrf}?nmRnd=webstore&nmPrc=PrcWebstorePage&catalogId=${cat1l.catalog.itsId}">${utlTradeJsp.catalogToStr(cat1l.catalog, reqVars.i18nCatalogs, reqVars.lang)}</a></li>
              </c:if>
            </c:forEach>
          </c:if>
          <c:if test="${not empty filterPrice || not empty filterCatalog || not empty filtersSpecifics}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="modal" data-target="#filterMdl"><span class="oi oi-sort-ascending" title="Filter, order" aria-hidden="true"></span></a></li>
          </c:if>
        </ul>
        <ul class="navbar-nav navbar-right">
          <c:if test="${isUnSign}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('log_in', reqVars.lang)}" onclick="$('#signMdl').modal('toggle');"><span class="oi oi-account-login" aria-hidden="true"></span></a></li>
          </c:if>
          <c:if test="${!isUnSign}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('log_out', reqVars.lang)}" onclick="$('#logoutDlg').modal('toggle');">${buyr.itsName} <span class="oi oi-account-logout" aria-hidden="true"></span></a></li>
          </c:if>
          <c:if test="${not empty cart}">
            <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('shopping_cart', reqVars.lang)}" onclick="$('#cartMdl').modal('toggle');"><span class="oi oi-cart" title="cart" aria-hidden="true"></span><span class="badge badge-secondary">${utlJsp.printNumber(cart.tot.toString(), reqVars.decSepv, reqVars.decGrSepv, reqVars.priceDp, reqVars.digInGr)}${reqVars.wscurr.itsSign}</span></a></li>
          </c:if>
          <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('About', reqVars.lang)}" onclick="$('#infoDlg').modal('toggle');"><span class="oi oi-info" aria-hidden="true"></span></a></li>
          <c:if test="${empty countryFlag}">
            <c:if test="${reqVars.lang eq 'en'}">
              <c:set var="countryFlag" value="us"/>
            </c:if>
            <c:if test="${reqVars.lang ne 'en'}">
              <c:set var="countryFlag" value="${reqVars.lang}"/>
            </c:if>
          </c:if>
          <li class="nav-item"><a href="#" class="nav-link" data-toggle="tooltip" title="${srvI18n.getMsg('lang', reqVars.lang)}" onclick="$('#i18nMdl').modal('toggle');"><span class="flag-icon flag-icon-${countryFlag}"></span></a></li>
        </ul>
      </div>
    </nav>
    </header>

    <main role="main">
