<%@ page language="java" pageEncoding="UTF-8" session="false"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<c:if test="${ords == null && sords == null}">
  <jsp:include page="${param.nmRndRed}.jsp"/>
</c:if>
<c:if test="${ords != null  ||  sords != null}">
  <c:set var="catalogId" value="${param.catalogId}" scope="request"/>
  <jsp:include page="webstoreStart.jsp"/>

  <c:if test="${ords != null}">
    <div class="card cat-name">
      <div class="card-header">
        <h5>${srvI18n.getMsg("CustOrders", reqVars.lang)}</h5>
      </div>
      <div class="card-body">

    <c:set var="divCnt">
      <div class="col-12">
    </c:set>
    <c:if test="${reqVars.tradSet.columnsCount != 1}">
      <c:set var="divCnt">
        <div class="col-12 col-lg-6">
      </c:set>
    </c:if>

    <c:forEach var="ord" items="${ords}" varStatus="status">

      <c:if test="${reqVars.tradSet.columnsCount == 1 || (status.index mod 2) == 0}">
        <div class="row">
      </c:if>
      ${divCnt}
        <h6>${srvI18n.getMsg("CustOrder", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg(ord.stat, reqVars.lang)}, ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.stCo}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName},
        ${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)},
        ${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}
        <c:if test="${not empty ord.place}">
          , ${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}
        </c:if></h6>
        <a href="#" onclick="window.open('?nmRnd=printEntity&nmPrc=PrBuOr&orId=${ord.itsId}&unSc=1');" type="button" class="btn btn-outline-primary">${srvI18n.getMsg("print", reqVars.lang)}</a>
      </div>
      <c:if test="${reqVars.tradSet.columnsCount == 1 || (status.index mod 2) != 0}">
        </div>
      </c:if>
    </c:forEach>
    <c:if test="${reqVars.tradSet.columnsCount != 1 && ords.size() mod 2 != 0}">
      </div>
    </c:if>

    <c:if test="${not empty pgs}">
      <nav aria-label="Page navigation">
        <ul class="pagination justify-content-center">
          <c:forEach var="pg" items="${pgs}">
            <c:if test="${pg.isCurrent}">
              <li class="page-item active"><a class="page-link" href="?nmRnd=wors&nmPrc=PrBuOr&pg=${pg.value}&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}">${pg.value}</a></li>
            </c:if>
            <c:if test="${!pg.isCurrent}">
              <li class="page-item"><a class="page-link" href="?nmRnd=wors&nmPrc=PrBuOr&pg=${pg.value}&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}">${pg.value}</a></li>
            </c:if>
          </c:forEach>
        </ul>
      </nav>
    </c:if>

      </div>
    </div>
  </c:if>

  <c:if test="${sords != null}">
    <div class="card cat-name">
      <div class="card-header">
        <h5>${srvI18n.getMsg("CuOrSes", reqVars.lang)}</h5>
      </div>
      <div class="card-body">

    <c:set var="divCnt">
      <div class="col-12">
    </c:set>
    <c:if test="${reqVars.tradSet.columnsCount != 1}">
      <c:set var="divCnt">
        <div class="col-12 col-lg-6">
      </c:set>
    </c:if>

    <c:forEach var="ord" items="${sords}" varStatus="status">

      <c:if test="${reqVars.tradSet.columnsCount == 1 || (status.index mod 2) == 0}">
        <div class="row">
      </c:if>
      ${divCnt}
        <h6>${srvI18n.getMsg("CuOrSe", reqVars.lang)}#${ord.itsId}, <fmt:formatDate value="${ord.dat}" type="both" timeStyle="short"/>,
        ${srvI18n.getMsg("seller", reqVars.lang)}: ${ord.sel.seller.itsName}, ${srvI18n.getMsg(ord.stat, reqVars.lang)}, ${srvI18n.getMsg("tot", reqVars.lang)} ${ord.tot}${ord.curr.stCo}
        <c:if test="${ord.totTx.doubleValue() gt 0 && tradSet.txExcl}">(${srvI18n.getMsg("txExcl", reqVars.lang)}),</c:if>
        <c:if test="${ord.totTx.doubleValue() gt 0 && !tradSet.txExcl}">(${srvI18n.getMsg("txIncl", reqVars.lang)}),</c:if>
        ${srvI18n.getMsg("totTx", reqVars.lang)} ${ord.totTx}${ord.curr.itsName},
        ${srvI18n.getMsg("payMeth", reqVars.lang)}: ${srvI18n.getMsg(ord.payMeth, reqVars.lang)},
        ${srvI18n.getMsg("deliv", reqVars.lang)}: ${srvI18n.getMsg(ord.deliv, reqVars.lang)}
        <c:if test="${not empty ord.place}">
          , ${srvI18n.getMsg("place", reqVars.lang)}: ${ord.place.itsName}
        </c:if></h6>
        <a href="#" onclick="window.open('?nmRnd=printEntity&nmPrc=PrBuOr&sorId=${ord.itsId}&unSc=1');" type="button" class="btn btn-outline-primary">${srvI18n.getMsg("print", reqVars.lang)}</a>
      </div>
      <c:if test="${reqVars.tradSet.columnsCount == 1 || (status.index mod 2) != 0}">
        </div>
      </c:if>
    </c:forEach>
    <c:if test="${reqVars.tradSet.columnsCount != 1 && ords.size() mod 2 != 0}">
      </div>
    </c:if>

    <c:if test="${not empty pgs}">
      <nav aria-label="Page navigation">
        <ul class="pagination justify-content-center">
          <c:forEach var="pg" items="${spgs}">
            <c:if test="${pg.isCurrent}">
              <li class="page-item active"><a class="page-link" href="?nmRnd=wors&nmPrc=PrBuOr&spg=${pg.value}&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}">${pg.value}</a></li>
            </c:if>
            <c:if test="${!pg.isCurrent}">
              <c:if test="${pg.value ne '...'}">
                <li class="page-item"><a class="page-link" href="?nmRnd=wors&nmPrc=PrBuOr&spg=${pg.value}&nmRndRed=${nmRndRed}&nmPrcRed=${nmPrcRed}">${pg.value}</a></li>
              </c:if>
              <c:if test="${pg.value eq '...'}">
                <li class="page-item"><a class="page-link" href="#">${pg.value}</a></li>
              </c:if>
            </c:if>
          </c:forEach>
        </ul>
      </nav>
    </c:if>

      </div>
    </div>
  </c:if>

  <jsp:include page="webstoreI18n.jsp"/>

  <jsp:include page="webstoreEnd.jsp"/>
</c:if>
