select TAX as TAXID,  sum(SUBTOTAL * ITSPERCENTAGE / 100) as TOTALTAX
from
(
  select INVITEM.TAXCATEGORY as TAXCATEGORY, SUBTOTAL
  from PURCHASEINVOICELINE 
  join INVITEM on INVITEM.ITSID = PURCHASEINVOICELINE.INVITEM
  where PURCHASEINVOICELINE.REVERSEDID is null and PURCHASEINVOICELINE.ITSOWNER = :ITSOWNER

  union all

  select SERVICEPURCHASED.TAXCATEGORY as TAXCATEGORY, ITSCOST as SUBTOTAL
  from PURCHASEINVOICESERVICELINE 
  join SERVICEPURCHASED on SERVICEPURCHASED.ITSID = PURCHASEINVOICESERVICELINE.SERVICE
  where PURCHASEINVOICESERVICELINE.ITSOWNER = :ITSOWNER
) as ALL_LINES
join INVITEMTAXCATEGORY on INVITEMTAXCATEGORY.ITSID = TAXCATEGORY
join INVITEMTAXCATEGORYLINE on INVITEMTAXCATEGORYLINE.ITSOWNER = INVITEMTAXCATEGORY.ITSID
group by TAX;
