/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccountingEntries;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.converter.IConverterToFromString;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDate;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.settings.IMngSettings;

public class PrcAccEntryCreate<RS>
implements IEntityProcessor<AccountingEntry, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;
    private IMngSettings mngUvdSettings;
    private ISrvDate srvDate;
    private IFactoryAppBeansByName<IConverterToFromString<?>> convertersFieldsFatory;
    private IHolderForClassByName<String> fieldConverterNamesHolder;
    private ISrvI18n srvI18n;
    private DateFormat dateFormatter;
    private final Integer accountingEntriesTypeCode = new AccountingEntries().constTypeCode();

    public final AccountingEntry process(Map<String, Object> pAddParam, AccountingEntry pEntity, IRequestData pRequestData) throws Exception {
        AccountingEntries doc = (AccountingEntries)((Object)this.getSrvOrm().retrieveEntityById(pAddParam, AccountingEntries.class, (Object)pEntity.getSourceId()));
        if (!doc.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_entry_for_foreign_src");
        }
        pEntity.setIsNew(true);
        pEntity.setItsDate(new Date());
        pEntity.setSourceType(this.accountingEntriesTypeCode);
        pEntity.setSourceDatabaseBirth(doc.getIdDatabaseBirth());
        String docDescription = doc.getDescription() != null ? doc.getDescription() : "";
        pEntity.setDescription(this.getSrvI18n().getMsg(AccountingEntries.class.getSimpleName() + "short") + " #" + doc.getIdDatabaseBirth() + "-" + doc.getItsId() + ", " + this.getDateFormatter().format(doc.getItsDate()) + ". " + docDescription);
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        pEntity.setIsNew(true);
        pRequestData.setAttribute("entity", (Object)pEntity);
        pRequestData.setAttribute("AccountingEntriesVersion", (Object)doc.getItsVersion());
        pRequestData.setAttribute("mngUvds", (Object)this.mngUvdSettings);
        pRequestData.setAttribute("srvOrm", this.srvOrm);
        pRequestData.setAttribute("srvDate", (Object)this.srvDate);
        pRequestData.setAttribute("hldCnvFtfsNames", this.fieldConverterNamesHolder);
        pRequestData.setAttribute("fctCnvFtfs", this.convertersFieldsFatory);
        return pEntity;
    }

    public final Integer getAccountingEntriesTypeCode() {
        return this.accountingEntriesTypeCode;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public final void setDateFormatter(DateFormat pDateFormatter) {
        this.dateFormatter = pDateFormatter;
    }

    public final IMngSettings getMngUvdSettings() {
        return this.mngUvdSettings;
    }

    public final void setMngUvdSettings(IMngSettings pMngUvdSettings) {
        this.mngUvdSettings = pMngUvdSettings;
    }

    public final ISrvDate getSrvDate() {
        return this.srvDate;
    }

    public final void setSrvDate(ISrvDate pSrvDate) {
        this.srvDate = pSrvDate;
    }

    public final IFactoryAppBeansByName<IConverterToFromString<?>> getConvertersFieldsFatory() {
        return this.convertersFieldsFatory;
    }

    public final void setConvertersFieldsFatory(IFactoryAppBeansByName<IConverterToFromString<?>> pConvertersFieldsFatory) {
        this.convertersFieldsFatory = pConvertersFieldsFatory;
    }

    public final IHolderForClassByName<String> getFieldConverterNamesHolder() {
        return this.fieldConverterNamesHolder;
    }

    public final void setFieldConverterNamesHolder(IHolderForClassByName<String> pFieldConverterNamesHolder) {
        this.fieldConverterNamesHolder = pFieldConverterNamesHolder;
    }
}

