/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.CogsEntry;
import org.beigesoft.accounting.persistable.GoodsLoss;
import org.beigesoft.accounting.persistable.GoodsLossLine;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcGoodsLossLineSave<RS>
implements IEntityProcessor<GoodsLossLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<CogsEntry> srvCogsEntry;
    private ISrvAccSettings srvAccSettings;

    public final GoodsLossLine process(Map<String, Object> pAddParam, GoodsLossLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() <= 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
            }
            pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getInvItem())));
            pEntity.setItsOwner((GoodsLoss)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(GoodsLoss.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            if (pEntity.getReversedId() != null) {
                GoodsLossLine reversed = (GoodsLossLine)this.getSrvOrm().retrieveEntityById(pAddParam, GoodsLossLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pAddParam.get("user"));
                }
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
                this.srvWarehouseEntry.reverseDraw(pAddParam, pEntity);
                this.srvCogsEntry.reverseDraw(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                this.srvWarehouseEntry.withdrawal(pAddParam, pEntity, pEntity.getWarehouseSiteFo());
                this.srvCogsEntry.withdrawal(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            }
            String query = "select  sum(ITSTOTAL) as ITSTOTAL from COGSENTRY where REVERSEDID is null and DRAWINGTYPE=1005 and DRAWINGOWNERID=" + pEntity.getItsOwner().getItsId();
            Double total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
            if (total == null) {
                total = 0.0;
            }
            pEntity.getItsOwner().setItsTotal(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
            pAddParam.put("nextEntity", pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", GoodsLoss.class.getSimpleName());
            pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<CogsEntry> getSrvCogsEntry() {
        return this.srvCogsEntry;
    }

    public final void setSrvCogsEntry(ISrvDrawItemEntry<CogsEntry> pSrvCogsEntry) {
        this.srvCogsEntry = pSrvCogsEntry;
    }
}

