/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.processor.UtlPurchaseGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseInvoiceLineSave<RS>
implements IEntityProcessor<PurchaseInvoiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private UtlPurchaseGoodsServiceLine<RS> utlPurchaseGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;

    public final PurchaseInvoiceLine process(Map<String, Object> pAddParam, PurchaseInvoiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() <= 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
            }
            if (pEntity.getItsCost().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pAddParam.get("user"));
            }
            pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getInvItem())));
            pEntity.setItsOwner((PurchaseInvoice)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            if (!InvItem.MATERIAL_ID.equals(pEntity.getInvItem().getItsType().getItsId()) && !InvItem.MERCHANDISE_ID.equals(pEntity.getInvItem().getItsType().getItsId())) {
                throw new ExceptionWithCode(1003, "type_must_be_material_or_merchandise::" + pAddParam.get("user"));
            }
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsCost(pEntity.getItsCost().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setSubtotal(pEntity.getItsTotal().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setTheRest(pEntity.getItsQuantity());
            BigDecimal totalTaxes = BigDecimal.ZERO;
            String taxesDescription = "";
            if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue() && pEntity.getInvItem().getTaxCategory() != null) {
                InvItemTaxCategoryLine iitcLn = new InvItemTaxCategoryLine();
                iitcLn.setItsOwner(pEntity.getInvItem().getTaxCategory());
                List iitcll = this.getSrvOrm().retrieveListForField(pAddParam, (Object)iitcLn, "itsOwner");
                BigDecimal bigDecimal100 = new BigDecimal("100.00");
                StringBuffer sb = new StringBuffer();
                int i = 0;
                for (InvItemTaxCategoryLine iitcl : iitcll) {
                    if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)iitcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)iitcl.getTax().getItsType())) continue;
                    BigDecimal addTx = pEntity.getSubtotal().multiply(iitcl.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                    totalTaxes = totalTaxes.add(addTx);
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(iitcl.getTax().getItsName() + " " + iitcl.getItsPercentage() + "%=" + addTx);
                }
                taxesDescription = sb.toString();
            }
            pEntity.setTaxesDescription(taxesDescription);
            pEntity.setTotalTaxes(totalTaxes);
            pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
            if (pEntity.getReversedId() != null) {
                pEntity.setTheRest(BigDecimal.ZERO);
            }
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            if (pEntity.getReversedId() != null) {
                PurchaseInvoiceLine reversed = (PurchaseInvoiceLine)this.getSrvOrm().retrieveEntityById(pAddParam, PurchaseInvoiceLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed::" + pAddParam.get("user"));
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source::" + pAddParam.get("user"));
                }
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
            }
            this.srvWarehouseEntry.load(pAddParam, pEntity, pEntity.getWarehouseSite());
            this.utlPurchaseGoodsServiceLine.updateOwner(pAddParam, pEntity.getItsOwner());
            pAddParam.put("nextEntity", pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
            pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlPurchaseGoodsServiceLine<RS> getUtlPurchaseGoodsServiceLine() {
        return this.utlPurchaseGoodsServiceLine;
    }

    public final void setUtlPurchaseGoodsServiceLine(UtlPurchaseGoodsServiceLine<RS> pUtlPurchaseGoodsServiceLine) {
        this.utlPurchaseGoodsServiceLine = pUtlPurchaseGoodsServiceLine;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }
}

