/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnLine;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseReturnLineSave<RS>
implements IEntityProcessor<PurchaseReturnLine, Long> {
    private ISrvI18n srvI18n;
    private ISrvDatabase<RS> srvDatabase;
    private String queryPurchaseReturnLineTaxes;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<UseMaterialEntry> srvUseMaterialEntry;
    private ISrvAccSettings srvAccSettings;

    public final PurchaseReturnLine process(Map<String, Object> pAddParam, PurchaseReturnLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() == 0.0) {
                throw new ExceptionWithCode(1003, "Quantity is 0!" + pAddParam.get("user"));
            }
            if (pEntity.getItsQuantity().doubleValue() < 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "Reversed Line is null!" + pAddParam.get("user"));
            }
            if (pEntity.getPurchaseInvoiceLine() == null) {
                throw new ExceptionWithCode(1003, "wrong_purchaseInvoiceLine");
            }
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setPurchaseInvoiceLine((PurchaseInvoiceLine)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getPurchaseInvoiceLine()));
            pEntity.setItsOwner((PurchaseReturn)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            if (pEntity.getPurchaseInvoiceLine() == null) {
                throw new ExceptionWithCode(1003, "wrong_purchaseInvoiceLine");
            }
            pEntity.setPurchInvLnAppearance(this.getSrvI18n().getMsg(PurchaseInvoiceLine.class.getSimpleName() + "short") + " #" + pEntity.getPurchaseInvoiceLine().getIdDatabaseBirth() + "-" + pEntity.getPurchaseInvoiceLine().getItsId() + ", " + pEntity.getPurchaseInvoiceLine().getInvItem().getItsName() + ", " + pEntity.getPurchaseInvoiceLine().getUnitOfMeasure().getItsName() + ", " + this.getSrvI18n().getMsg("itsCost") + "=" + pEntity.getPurchaseInvoiceLine().getItsCost() + ", " + this.getSrvI18n().getMsg("rest_was") + "=" + pEntity.getPurchaseInvoiceLine().getTheRest());
            pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getPurchaseInvoiceLine().getItsCost()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            BigDecimal totalTaxes = BigDecimal.ZERO;
            if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue()) {
                String taxesDescription = "";
                if (pEntity.getPurchaseInvoiceLine().getInvItem().getTaxCategory() != null) {
                    List pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getPurchaseInvoiceLine().getInvItem().getTaxCategory().getItsId());
                    BigDecimal bigDecimal100 = new BigDecimal("100.00");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine pst : pstl) {
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                        BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                        totalTaxes = totalTaxes.add(addTx);
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        sb.append(pst.getTax().getItsName() + " " + pst.getItsPercentage() + "%=" + addTx);
                    }
                    taxesDescription = sb.toString();
                }
                pEntity.setTaxesDescription(taxesDescription);
                pEntity.setTotalTaxes(totalTaxes);
            }
            pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            if (pEntity.getReversedId() != null) {
                PurchaseReturnLine reversed = (PurchaseReturnLine)this.getSrvOrm().retrieveEntityById(pAddParam, PurchaseReturnLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pAddParam.get("user"));
                }
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
                this.srvWarehouseEntry.reverseDraw(pAddParam, pEntity);
                this.srvUseMaterialEntry.reverseDraw(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                this.srvWarehouseEntry.withdrawal(pAddParam, pEntity, pEntity.getWarehouseSiteFo());
                this.srvUseMaterialEntry.withdrawalFrom(pAddParam, pEntity, pEntity.getPurchaseInvoiceLine(), pEntity.getItsQuantity());
            }
            String query = "select sum(SUBTOTAL) as SUBTOTAL, sum(TOTALTAXES) as TOTALTAXES from PURCHASERETURNLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
            String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
            Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
            if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue()) {
                this.updateTaxLines(pAddParam, pEntity.getItsOwner());
            }
        } else {
            throw new ExceptionWithCode(403, "Attempt to update sales invoice line by " + pAddParam.get("user"));
        }
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", PurchaseReturn.class.getSimpleName());
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pAddParam, PurchaseReturn pItsOwner) throws Exception {
        List citl = this.getSrvOrm().retrieveListWithConditions(pAddParam, PurchaseReturnTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        String query = this.lazyGetQueryPurchaseReturnLineTaxes().replace(":ITSOWNER", pItsOwner.getItsId().toString());
        int countUpdatedSitl = 0;
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    PurchaseReturnTaxLine cit;
                    Long taxId = recordSet.getLong("TAXID");
                    Double totalTax = recordSet.getDouble("TOTALTAX");
                    if (citl.size() > countUpdatedSitl) {
                        cit = (PurchaseReturnTaxLine)((Object)citl.get(countUpdatedSitl));
                        ++countUpdatedSitl;
                    } else {
                        cit = new PurchaseReturnTaxLine();
                        cit.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        cit.setItsOwner(pItsOwner);
                        cit.setIsNew(true);
                    }
                    Tax tax = new Tax();
                    tax.setItsId(taxId);
                    cit.setTax(tax);
                    cit.setItsTotal(BigDecimal.valueOf(totalTax).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (cit.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pAddParam, (Object)cit);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pAddParam, (Object)cit);
                } while (recordSet.moveToNext());
            }
        }
        if (countUpdatedSitl < citl.size()) {
            for (int j = countUpdatedSitl; j < citl.size(); ++j) {
                this.getSrvOrm().deleteEntity(pAddParam, citl.get(j));
            }
        }
    }

    public final String lazyGetQueryPurchaseReturnLineTaxes() throws Exception {
        if (this.queryPurchaseReturnLineTaxes == null) {
            String flName = "/accounting/trade/purchaseReturnLineTaxes.sql";
            this.queryPurchaseReturnLineTaxes = this.loadString(flName);
        }
        return this.queryPurchaseReturnLineTaxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcPurchaseReturnLineSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcPurchaseReturnLineSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<UseMaterialEntry> getSrvUseMaterialEntry() {
        return this.srvUseMaterialEntry;
    }

    public final void setSrvUseMaterialEntry(ISrvDrawItemEntry<UseMaterialEntry> pSrvUseMaterialEntry) {
        this.srvUseMaterialEntry = pSrvUseMaterialEntry;
    }

    public final void setQueryPurchaseReturnLineTaxes(String pQueryPurchaseReturnLineTaxes) {
        this.queryPurchaseReturnLineTaxes = pQueryPurchaseReturnLineTaxes;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

