/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.PaymentFrom;
import org.beigesoft.accounting.persistable.PrepaymentFrom;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.processor.APrcAccDocCogsSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcSalesInvoiceSave<RS>
extends APrcAccDocCogsSave<RS, SalesInvoice> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getPrepaymentFrom() != null) {
            pEntity.setPrepaymentFrom((PrepaymentFrom)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getPrepaymentFrom()));
            if (pEntity.getReversedId() == null && pEntity.getPrepaymentFrom().getSalesInvoiceId() != null && !pEntity.getHasMadeAccEntries().booleanValue()) {
                throw new ExceptionWithCode(1003, "prepayment_already_in_use");
            }
            if (pEntity.getReversedId() == null && !pEntity.getPrepaymentFrom().getCustomer().getItsId().equals(pEntity.getCustomer().getItsId())) {
                throw new ExceptionWithCode(1003, "prepayment_for_different_vendor");
            }
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentFrom() != null && pEntity.getPaymentTotal().compareTo(pEntity.getPrepaymentFrom().getItsTotal()) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() != null && pEntity.getPrepaymentFrom() == null && pEntity.getPaymentTotal().compareTo(BigDecimal.ZERO) != 0) {
            throw new ExceptionWithCode(1003, "reverse_payments_first");
        }
        if (pEntity.getReversedId() == null) {
            this.calculateTotalPayment(pAddParam, pEntity);
        }
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd)) {
            if (pEntity.getReversedId() != null) {
                SalesInvoiceLine sil = new SalesInvoiceLine();
                SalesInvoice reversed = new SalesInvoice();
                reversed.setItsId(pEntity.getReversedId());
                sil.setItsOwner(reversed);
                List reversedLines = this.getSrvOrm().retrieveListForField(pAddParam, (Object)sil, "itsOwner");
                for (SalesInvoiceLine reversedLine : reversedLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceLine reversingLine = new SalesInvoiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setInvItem(reversedLine.getInvItem());
                    reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                    reversingLine.setItsPrice(reversedLine.getItsPrice());
                    reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setSubtotal(reversedLine.getSubtotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_n") + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                    this.getSrvOrm().insertEntity(pAddParam, (Object)reversingLine);
                    this.getSrvWarehouseEntry().reverseDraw(pAddParam, reversingLine);
                    this.getSrvCogsEntry().reverseDraw(pAddParam, reversingLine, pEntity.getItsDate(), pEntity.getItsId());
                    String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                    reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_n") + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, (Object)reversedLine);
                }
                SalesInvoiceServiceLine sisl = new SalesInvoiceServiceLine();
                sisl.setItsOwner(reversed);
                List revServLines = this.getSrvOrm().retrieveListForField(pAddParam, (Object)sisl, "itsOwner");
                for (SalesInvoiceServiceLine reversedLine : revServLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceServiceLine reversingLine = new SalesInvoiceServiceLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setService(reversedLine.getService());
                    reversingLine.setItsPrice(reversedLine.getItsPrice().negate());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setTotalTaxes(reversedLine.getTotalTaxes().negate());
                    reversingLine.setTaxesDescription(reversedLine.getTaxesDescription());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pAddParam, (Object)reversingLine);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, (Object)reversedLine);
                }
                SalesInvoiceTaxLine sitl = new SalesInvoiceTaxLine();
                sitl.setItsOwner(reversed);
                List reversedTaxLines = this.getSrvOrm().retrieveListForField(pAddParam, (Object)sitl, "itsOwner");
                for (SalesInvoiceTaxLine reversedLine : reversedTaxLines) {
                    if (reversedLine.getReversedId() != null) continue;
                    SalesInvoiceTaxLine reversingLine = new SalesInvoiceTaxLine();
                    reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                    reversingLine.setReversedId(reversedLine.getItsId());
                    reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                    reversingLine.setTax(reversedLine.getTax());
                    reversingLine.setIsNew(true);
                    reversingLine.setItsOwner(pEntity);
                    this.getSrvOrm().insertEntity(pAddParam, (Object)reversingLine);
                    reversedLine.setReversedId(reversingLine.getItsId());
                    this.getSrvOrm().updateEntity(pAddParam, (Object)reversedLine);
                }
            }
            if (pEntity.getPrepaymentFrom() != null) {
                if (pEntity.getReversedId() != null) {
                    pEntity.getPrepaymentFrom().setSalesInvoiceId(null);
                } else {
                    pEntity.getPrepaymentFrom().setSalesInvoiceId(pEntity.getItsId());
                }
                this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getPrepaymentFrom());
            }
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData, SalesInvoice pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, SalesInvoice pEntity, IRequestData pRequestData) throws Exception {
    }

    public final void calculateTotalPayment(Map<String, Object> pAddParam, SalesInvoice pEntity) throws Exception {
        if (pEntity.getPrepaymentFrom() != null) {
            pEntity.setPaymentTotal(pEntity.getPrepaymentFrom().getItsTotal());
            pEntity.setPaymentDescription(this.getSrvI18n().getMsg(PrepaymentFrom.class.getSimpleName() + "short") + " #" + pEntity.getPrepaymentFrom().getIdDatabaseBirth() + "-" + pEntity.getPrepaymentFrom().getItsId() + ", " + this.getDateFormatter().format(pEntity.getPrepaymentFrom().getItsDate()) + ", " + pEntity.getPaymentTotal());
        } else {
            pEntity.setPaymentTotal(BigDecimal.ZERO);
            pEntity.setPaymentDescription("");
        }
        List payments = this.getSrvOrm().retrieveListWithConditions(pAddParam, PaymentFrom.class, "where PAYMENTFROM.HASMADEACCENTRIES=1 and PAYMENTFROM.REVERSEDID is null and SALESINVOICE=" + pEntity.getItsId());
        for (PaymentFrom payment : payments) {
            pEntity.setPaymentTotal(pEntity.getPaymentTotal().add(payment.getItsTotal()));
            pEntity.setPaymentDescription(pEntity.getPaymentDescription() + " " + this.getSrvI18n().getMsg(PaymentFrom.class.getSimpleName() + "short") + " #" + payment.getIdDatabaseBirth() + "-" + payment.getItsId() + ", " + this.getDateFormatter().format(payment.getItsDate()) + ", " + payment.getItsTotal());
        }
    }
}

