/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.Wage;
import org.beigesoft.accounting.persistable.WageLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcWageLineDelete<RS>
implements IEntityProcessor<WageLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;

    public final WageLine process(Map<String, Object> pAddParam, WageLine pEntity, IRequestData pRequestData) throws Exception {
        if (!pEntity.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_change_foreign_src");
        }
        pEntity.setItsOwner((Wage)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(Wage.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        if (pEntity.getItsOwner().getHasMadeAccEntries().booleanValue()) {
            throw new ExceptionWithCode(403, "attempt_to_change_accounted_document");
        }
        this.getSrvOrm().deleteEntity(pAddParam, (Object)pEntity);
        this.updateOwner(pAddParam, pEntity);
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", Wage.class.getSimpleName());
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        return null;
    }

    public final void updateOwner(Map<String, Object> pAddParam, WageLine pEntity) throws Exception {
        String query = "select sum(GROSSWAGE) as GROSSWAGE from " + WageLine.class.getSimpleName().toUpperCase() + " where ITSOWNER=" + pEntity.getItsOwner().getItsId();
        Double total = this.getSrvDatabase().evalDoubleResult(query, "GROSSWAGE");
        if (total == null) {
            total = 0.0;
        }
        pEntity.getItsOwner().setItsTotal(BigDecimal.valueOf(total).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

