/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class UtlPurchaseGoodsServiceLine<RS> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private String fileQueryPurchaseInvoiceTaxes = "purchaseInvoiceTaxes.sql";
    private String queryPurchaseInvoiceTaxes;
    private String fileQueryPurchaseInvoiceTotals = "purchaseInvoiceTotals.sql";
    private String queryPurchaseInvoiceTotals;
    private ISrvAccSettings srvAccSettings;

    public final void updateOwner(Map<String, Object> pAddParam, PurchaseInvoice pItsOwner) throws Exception {
        String query = this.lazyGetQueryPurchaseInvoiceTotals();
        query = query.replace(":ITSOWNER", pItsOwner.getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        pItsOwner.setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pItsOwner.setItsTotal(pItsOwner.getSubtotal().add(pItsOwner.getTotalTaxes()));
        this.getSrvOrm().updateEntity(pAddParam, (Object)pItsOwner);
        if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue()) {
            this.updateTaxLines(pAddParam, pItsOwner);
        }
    }

    public final String lazyGetQueryPurchaseInvoiceTaxes() throws Exception {
        if (this.queryPurchaseInvoiceTaxes == null) {
            String flName = "/accounting/trade/" + this.fileQueryPurchaseInvoiceTaxes;
            this.queryPurchaseInvoiceTaxes = this.loadString(flName);
        }
        return this.queryPurchaseInvoiceTaxes;
    }

    public final String lazyGetQueryPurchaseInvoiceTotals() throws Exception {
        if (this.queryPurchaseInvoiceTotals == null) {
            String flName = "/accounting/trade/" + this.fileQueryPurchaseInvoiceTotals;
            this.queryPurchaseInvoiceTotals = this.loadString(flName);
        }
        return this.queryPurchaseInvoiceTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = UtlPurchaseGoodsServiceLine.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = UtlPurchaseGoodsServiceLine.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pAddParam, PurchaseInvoice pItsOwner) throws Exception {
        PurchaseInvoiceTaxLine pit = new PurchaseInvoiceTaxLine();
        pit.setItsOwner(pItsOwner);
        List pitl = this.getSrvOrm().retrieveListForField(pAddParam, (Object)pit, "itsOwner");
        String query = this.lazyGetQueryPurchaseInvoiceTaxes().replace(":ITSOWNER", pItsOwner.getItsId().toString());
        int countUpdatedSitl = 0;
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    Long taxId = recordSet.getLong("TAXID");
                    Double totalTax = recordSet.getDouble("TOTALTAX");
                    if (pitl.size() > countUpdatedSitl) {
                        pit = (PurchaseInvoiceTaxLine)((Object)pitl.get(countUpdatedSitl));
                        ++countUpdatedSitl;
                    } else {
                        pit = new PurchaseInvoiceTaxLine();
                        pit.setItsOwner(pItsOwner);
                        pit.setIsNew(true);
                        pit.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                    }
                    Tax tax = new Tax();
                    tax.setItsId(taxId);
                    pit.setTax(tax);
                    pit.setItsTotal(BigDecimal.valueOf(totalTax).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (pit.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pAddParam, (Object)pit);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pAddParam, (Object)pit);
                } while (recordSet.moveToNext());
            }
        }
        if (countUpdatedSitl < pitl.size()) {
            for (int j = countUpdatedSitl; j < pitl.size(); ++j) {
                this.getSrvOrm().deleteEntity(pAddParam, pitl.get(j));
            }
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getFileQueryPurchaseInvoiceTaxes() {
        return this.fileQueryPurchaseInvoiceTaxes;
    }

    public final void setFileQueryPurchaseInvoiceTaxes(String pFileQueryPurchaseInvoiceTaxes) {
        this.fileQueryPurchaseInvoiceTaxes = pFileQueryPurchaseInvoiceTaxes;
    }

    public final String getQueryPurchaseInvoiceTaxes() {
        return this.queryPurchaseInvoiceTaxes;
    }

    public final void setQueryPurchaseInvoiceTaxes(String pQueryPurchaseInvoiceTaxes) {
        this.queryPurchaseInvoiceTaxes = pQueryPurchaseInvoiceTaxes;
    }

    public final String getFileQueryPurchaseInvoiceTotals() {
        return this.fileQueryPurchaseInvoiceTotals;
    }

    public final void setFileQueryPurchaseInvoiceTotals(String pFileQueryPurchaseInvoiceTotals) {
        this.fileQueryPurchaseInvoiceTotals = pFileQueryPurchaseInvoiceTotals;
    }

    public final String getQueryPurchaseInvoiceTotals() {
        return this.queryPurchaseInvoiceTotals;
    }

    public final void setQueryPurchaseInvoiceTotals(String pQueryPurchaseInvoiceTotals) {
        this.queryPurchaseInvoiceTotals = pQueryPurchaseInvoiceTotals;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

