/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.Map;
import org.beigesoft.accounting.persistable.BeginningInventory;
import org.beigesoft.accounting.persistable.BeginningInventoryLine;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcBeginningInventoryLineSave<RS>
implements IEntityProcessor<BeginningInventoryLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvAccSettings srvAccSettings;

    public final BeginningInventoryLine process(Map<String, Object> pAddParam, BeginningInventoryLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() <= 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pAddParam.get("user"));
            }
            if (pEntity.getItsCost().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pAddParam.get("user"));
            }
            pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getInvItem())));
            pEntity.setItsOwner((BeginningInventory)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(BeginningInventory.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsCost(pEntity.getItsCost().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setTheRest(pEntity.getItsQuantity());
            pEntity.setItsTotal(pEntity.getItsTotal().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            if (pEntity.getReversedId() != null) {
                pEntity.setTheRest(BigDecimal.ZERO);
            }
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            if (pEntity.getReversedId() != null) {
                BeginningInventoryLine reversed = (BeginningInventoryLine)this.getSrvOrm().retrieveEntityById(pAddParam, BeginningInventoryLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "attempt_to_reverse_reversed");
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
                }
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
            }
            this.srvWarehouseEntry.load(pAddParam, pEntity, pEntity.getWarehouseSite());
            String query = "select sum(ITSTOTAL) as ITSTOTAL from BEGINNINGINVENTORYLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
            Double total = this.getSrvDatabase().evalDoubleResult(query, "ITSTOTAL");
            BigDecimal totalBdcm = BigDecimal.valueOf(total);
            pEntity.getItsOwner().setItsTotal(totalBdcm.setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
            pAddParam.put("nextEntity", pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", BeginningInventory.class.getSimpleName());
            pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
            return null;
        }
        throw new ExceptionWithCode(403, "edit_not_allowed::" + pAddParam.get("user"));
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }
}

