/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AdditionCostLine;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.ManufacturingProcess;
import org.beigesoft.accounting.persistable.UsedMaterialLine;
import org.beigesoft.accounting.processor.APrcAccDocUseMaterialSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcManufacturingProcessSave<RS>
extends APrcAccDocUseMaterialSave<RS, ManufacturingProcess> {
    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, ManufacturingProcess pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsQuantity().doubleValue() == 0.0) {
            throw new ExceptionWithCode(1003, "Quantity is 0! " + pAddParam.get("user"));
        }
        pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getInvItem())));
        if (!InvItem.WORK_IN_PROGRESS_ID.equals(pEntity.getInvItem().getItsType().getItsId())) {
            throw new ExceptionWithCode(1003, "type_must_be_work_in_progress");
        }
        if (pEntity.getReversedId() != null) {
            pEntity.setIsComplete(true);
            pEntity.setTheRest(BigDecimal.ZERO);
        } else {
            pEntity.setTheRest(pEntity.getItsQuantity());
        }
        pEntity.setItsCost(pEntity.getItsTotal().divide(pEntity.getItsQuantity(), (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, ManufacturingProcess pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd) && pEntity.getReversedId() != null) {
            pEntity.setTheRest(BigDecimal.ZERO);
            ManufacturingProcess reversed = (ManufacturingProcess)this.getSrvOrm().retrieveEntityById(pAddParam, ManufacturingProcess.class, (Object)pEntity.getReversedId());
            reversed.setTheRest(BigDecimal.ZERO);
            this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
            UsedMaterialLine umlrd = new UsedMaterialLine();
            umlrd.setItsOwner(reversed);
            List reversedMaterials = this.getSrvOrm().retrieveListForField(pAddParam, (Object)umlrd, "itsOwner");
            for (UsedMaterialLine reversedLine : reversedMaterials) {
                if (reversedLine.getReversedId() != null) continue;
                UsedMaterialLine reversingLine = new UsedMaterialLine();
                reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                reversingLine.setReversedId(reversedLine.getItsId());
                reversingLine.setItsCost(reversedLine.getItsCost());
                reversingLine.setInvItem(reversedLine.getInvItem());
                reversingLine.setUnitOfMeasure(reversedLine.getUnitOfMeasure());
                reversingLine.setItsQuantity(reversedLine.getItsQuantity().negate());
                reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                reversingLine.setIsNew(true);
                reversingLine.setItsOwner(pEntity);
                reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_n") + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                this.getSrvOrm().insertEntity(pAddParam, (Object)reversingLine);
                this.getSrvWarehouseEntry().reverseDraw(pAddParam, reversingLine);
                this.getSrvUseMaterialEntry().reverseDraw(pAddParam, reversingLine, pEntity.getItsDate(), pEntity.getItsId());
                String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_n") + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                reversedLine.setReversedId(reversingLine.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversedLine);
            }
            AdditionCostLine acl = new AdditionCostLine();
            acl.setItsOwner(reversed);
            List reversedAcl = this.getSrvOrm().retrieveListForField(pAddParam, (Object)acl, "itsOwner");
            for (AdditionCostLine reversedLine : reversedAcl) {
                if (reversedLine.getReversedId() != null) continue;
                AdditionCostLine reversingLine = new AdditionCostLine();
                reversingLine.setIdDatabaseBirth(this.getSrvOrm().getIdDatabase());
                reversingLine.setReversedId(reversedLine.getItsId());
                reversingLine.setSubaccExpense(reversedLine.getSubaccExpense());
                reversingLine.setSubaccExpenseId(reversedLine.getSubaccExpenseId());
                reversingLine.setSubaccExpenseType(reversedLine.getSubaccExpenseType());
                reversingLine.setAccExpense(reversedLine.getAccExpense());
                reversingLine.setItsTotal(reversedLine.getItsTotal().negate());
                reversingLine.setIsNew(true);
                reversingLine.setItsOwner(pEntity);
                reversingLine.setDescription(this.getSrvI18n().getMsg("reversed_n") + reversedLine.getIdDatabaseBirth() + "-" + reversedLine.getItsId());
                this.getSrvOrm().insertEntity(pAddParam, (Object)reversingLine);
                String descr = reversedLine.getDescription() == null ? "" : reversedLine.getDescription();
                reversedLine.setDescription(descr + " " + this.getSrvI18n().getMsg("reversing_n") + reversingLine.getIdDatabaseBirth() + "-" + reversingLine.getItsId());
                reversedLine.setReversedId(reversingLine.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversedLine);
            }
        }
        if (pEntity.getIsComplete().booleanValue()) {
            if (pEntity.getItsCost().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "cost_less_or_eq_zero");
            }
            this.getSrvWarehouseEntry().load(pAddParam, pEntity, pEntity.getWarehouseSite());
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, ManufacturingProcess pEntity, IRequestData pRequestData, ManufacturingProcess pOldEntity) throws Exception {
        if (pOldEntity.getIsComplete().booleanValue()) {
            throw new ExceptionWithCode(403, "attempt_to_change_completed_manufacturing_process");
        }
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, ManufacturingProcess pEntity, IRequestData pRequestData) throws Exception {
        if (!pEntity.getIsComplete().booleanValue()) {
            throw new ExceptionWithCode(1003, "manufacturing_must_be_completed");
        }
    }
}

