/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.MoveItems;
import org.beigesoft.accounting.persistable.MoveItemsLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcMoveItemsLineSave<RS>
implements IEntityProcessor<MoveItemsLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvAccSettings srvAccSettings;

    public final MoveItemsLine process(Map<String, Object> pAddParam, MoveItemsLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero");
            }
            AccSettings accSettings = this.getSrvAccSettings().lazyGetAccSettings(pAddParam);
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)accSettings.getQuantityPrecision(), accSettings.getRoundingMode()));
            pEntity.setItsOwner((MoveItems)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner())));
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            this.srvWarehouseEntry.move(pAddParam, pEntity, pEntity.getWarehouseSiteFrom(), pEntity.getWarehouseSiteTo());
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(MoveItems.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
            pAddParam.put("nextEntity", (Object)pEntity.getItsOwner());
            pAddParam.put("nameOwnerEntity", MoveItems.class.getSimpleName());
            pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
            return null;
        }
        throw new ExceptionWithCode(403, "Attempt to update Sales Return line by " + pAddParam.get("user"));
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

