/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.accounting.processor.UtlSalesGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesInvoiceServiceLineSave<RS>
implements IEntityProcessor<SalesInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlSalesGoodsServiceLine<RS> utlSalesGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;

    public final SalesInvoiceServiceLine process(Map<String, Object> pAddParam, SalesInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "price_less_or_eq_zero");
        }
        pEntity.setService((ServiceToSale)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getService())));
        pEntity.setItsPrice(pEntity.getItsPrice().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        BigDecimal totalTaxes = BigDecimal.ZERO;
        String taxesDescription = "";
        if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue() && pEntity.getService().getTaxCategory() != null) {
            List pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getService().getTaxCategory().getItsId());
            BigDecimal bigDecimal100 = new BigDecimal("100.00");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (InvItemTaxCategoryLine pst : pstl) {
                if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                BigDecimal addTx = pEntity.getItsPrice().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                totalTaxes = totalTaxes.add(addTx);
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(pst.getTax().getItsName() + " " + pst.getItsPercentage() + "%=" + addTx);
            }
            taxesDescription = sb.toString();
        }
        pEntity.setTaxesDescription(taxesDescription);
        pEntity.setTotalTaxes(totalTaxes);
        pEntity.setItsTotal(pEntity.getItsPrice().add(totalTaxes));
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity);
        }
        pEntity.setItsOwner((SalesInvoice)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlSalesGoodsServiceLine.updateOwner(pAddParam, pEntity.getItsOwner());
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", SalesInvoice.class.getSimpleName());
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        return null;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlSalesGoodsServiceLine<RS> getUtlSalesGoodsServiceLine() {
        return this.utlSalesGoodsServiceLine;
    }

    public final void setUtlSalesGoodsServiceLine(UtlSalesGoodsServiceLine<RS> pUtlSalesGoodsServiceLine) {
        this.utlSalesGoodsServiceLine = pUtlSalesGoodsServiceLine;
    }
}

