/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesReturn;
import org.beigesoft.accounting.persistable.SalesReturnLine;
import org.beigesoft.accounting.persistable.SalesReturnTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesReturnLineSave<RS>
implements IEntityProcessor<SalesReturnLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private String querySalesReturnLineTaxes;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvAccSettings srvAccSettings;

    public final SalesReturnLine process(Map<String, Object> pAddParam, SalesReturnLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            if (pEntity.getItsQuantity().doubleValue() == 0.0) {
                throw new ExceptionWithCode(1003, "quantity_is_0");
            }
            if (pEntity.getItsQuantity().doubleValue() < 0.0 && pEntity.getReversedId() == null) {
                throw new ExceptionWithCode(1003, "Reversed_Line_is_null");
            }
            if (pEntity.getItsCost().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "cost_less_or_eq_zero" + pAddParam.get("user"));
            }
            if (pEntity.getItsPrice().doubleValue() <= 0.0) {
                throw new ExceptionWithCode(1003, "price_less_eq_0");
            }
            pEntity.setInvItem((InvItem)((Object)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getInvItem())));
            pEntity.setItsOwner((SalesReturn)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsPrice(pEntity.getItsPrice().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setItsCost(pEntity.getItsCost().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setSubtotal(pEntity.getItsTotal().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.setTheRest(pEntity.getItsQuantity());
            BigDecimal totalTaxes = BigDecimal.ZERO;
            String taxesDescription = "";
            if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue() && pEntity.getInvItem().getTaxCategory() != null) {
                List pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getInvItem().getTaxCategory().getItsId());
                BigDecimal bigDecimal100 = new BigDecimal("100.00");
                StringBuffer sb = new StringBuffer();
                int i = 0;
                for (InvItemTaxCategoryLine pst : pstl) {
                    if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                    BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                    totalTaxes = totalTaxes.add(addTx);
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(pst.getTax().getItsName() + " " + pst.getItsPercentage() + "%=" + addTx);
                }
                taxesDescription = sb.toString();
            }
            pEntity.setTaxesDescription(taxesDescription);
            pEntity.setTotalTaxes(totalTaxes);
            pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
            if (pEntity.getReversedId() != null) {
                pEntity.setTheRest(BigDecimal.ZERO);
            }
            this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
            if (pEntity.getReversedId() != null) {
                SalesReturnLine reversed = (SalesReturnLine)this.getSrvOrm().retrieveEntityById(pAddParam, SalesReturnLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pAddParam.get("user"));
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
                }
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
            }
            this.srvWarehouseEntry.load(pAddParam, pEntity, pEntity.getWarehouseSite());
            String query = "select sum(SUBTOTAL) as SUBTOTAL, sum(TOTALTAXES) as TOTALTAXES from SALESRETURNLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
            String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
            Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
            pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
            this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
            if (this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromSales().booleanValue()) {
                this.updateTaxLines(pAddParam, pEntity.getItsOwner());
            }
        } else {
            throw new ExceptionWithCode(403, "Attempt to update Sales Return line by " + pAddParam.get("user"));
        }
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", SalesReturn.class.getSimpleName());
        pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(pAddParam));
        return null;
    }

    public final String lazyGetQuerySalesReturnLineTaxes() throws Exception {
        if (this.querySalesReturnLineTaxes == null) {
            String flName = "/accounting/trade/salesReturnLineTaxes.sql";
            this.querySalesReturnLineTaxes = this.loadString(flName);
        }
        return this.querySalesReturnLineTaxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcSalesReturnLineSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcSalesReturnLineSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pAddParam, SalesReturn pItsOwner) throws Exception {
        List sitl = this.getSrvOrm().retrieveListWithConditions(pAddParam, SalesReturnTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        String query = this.lazyGetQuerySalesReturnLineTaxes().replace(":ITSOWNER", pItsOwner.getItsId().toString());
        int countUpdatedSitl = 0;
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    SalesReturnTaxLine sit;
                    Long taxId = recordSet.getLong("TAXID");
                    Double totalTax = recordSet.getDouble("TOTALTAX");
                    if (sitl.size() > countUpdatedSitl) {
                        sit = (SalesReturnTaxLine)((Object)sitl.get(countUpdatedSitl));
                        ++countUpdatedSitl;
                    } else {
                        sit = new SalesReturnTaxLine();
                        sit.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        sit.setItsOwner(pItsOwner);
                        sit.setIsNew(true);
                    }
                    Tax tax = new Tax();
                    tax.setItsId(taxId);
                    sit.setTax(tax);
                    sit.setItsTotal(BigDecimal.valueOf(totalTax).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (sit.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pAddParam, (Object)sit);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pAddParam, (Object)sit);
                } while (recordSet.moveToNext());
            }
        }
        if (countUpdatedSitl < sitl.size()) {
            for (int j = countUpdatedSitl; j < sitl.size(); ++j) {
                this.getSrvOrm().deleteEntity(pAddParam, sitl.get(j));
            }
        }
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final void setQuerySalesReturnLineTaxes(String pQuerySalesReturnLineTaxes) {
        this.querySalesReturnLineTaxes = pQuerySalesReturnLineTaxes;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

