/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Map;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.report.IBalanceSheetPdf;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EPageOrientation;
import org.beigesoft.doc.model.EPageSize;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.pdf.model.ERegisteredTtfFont;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.ISrvI18n;

public class BalanceSheetPdf<RS, WI>
implements IBalanceSheetPdf {
    private IPdfFactory<WI> pdfFactory;
    private DateFormat dateFormat = DateFormat.getDateInstance(1);
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;

    @Override
    public final void makeReport(Map<String, Object> pAddParam, BalanceSheet pBalance, OutputStream pOus) throws Exception {
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(EPageSize.A4, EPageOrientation.PORTRAIT);
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pAddParam);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF.toString());
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF_BOLD.toString());
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContentPaddingBottom(0.5);
        doc.setAlignHoriCont(EAlignHorizontal.CENTER);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 3);
        ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(accSet.getOrganization());
        ((TableCell)tblTitle.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("balance_sheet"));
        ((TableCell)tblTitle.getItsCells().get(2)).setItsContent(this.dateFormat.format(pBalance.getItsDate()));
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        docMaker.makeDocTableWrapping(tblTitle);
        doc.setContentPadding(1.0);
        doc.setAlignHoriCont(EAlignHorizontal.LEFT);
        DocTable tblBal = docMaker.addDocTable(doc, 4, pBalance.getDetailRowsCount() + 2);
        ((TableColumn)tblBal.getItsColumns().get(0)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(0)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(1)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(1)).setWidthInPercentage(20.0);
        ((TableColumn)tblBal.getItsColumns().get(2)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(2)).setWidthInPercentage(30.0);
        ((TableColumn)tblBal.getItsColumns().get(3)).setIsWidthFixed(true);
        ((TableColumn)tblBal.getItsColumns().get(3)).setWidthInPercentage(20.0);
        ((TableCell)tblBal.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("AssetsTitle"));
        ((TableCell)tblBal.getItsCells().get(0)).setMergedCell((TableCell)tblBal.getItsCells().get(1));
        ((TableCell)tblBal.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("LiabilitiesTitle"));
        ((TableCell)tblBal.getItsCells().get(2)).setMergedCell((TableCell)tblBal.getItsCells().get(3));
        int row = 1;
        for (int i = 0; i < pBalance.getTotalLinesAssets(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getDebit().compareTo(BigDecimal.ZERO) != 0 ? pBalance.getItsLines().get(i).getDebit().toString() : "(" + pBalance.getItsLines().get(i).getCredit() + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 1)).setFontNumber(1);
            ++row;
        }
        int totLeabOwnEq = pBalance.getTotalLinesLiabilities() + pBalance.getTotalLinesOwnersEquity();
        int lastRowIdx = Math.max(pBalance.getTotalLinesAssets() + 1, totLeabOwnEq + 4);
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4)).setItsContent(this.srvI18n.getMsg("total_assets"));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 1)).setItsContent(pBalance.getTotalAssets().toString() + " " + accSet.getCurrency().getItsName());
        row = 1;
        int totAssLeab = pBalance.getTotalLinesAssets() + pBalance.getTotalLinesLiabilities();
        for (int i = pBalance.getTotalLinesAssets().intValue(); i < totAssLeab; ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? pBalance.getItsLines().get(i).getCredit().toString() : "(" + pBalance.getItsLines().get(i).getDebit() + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 6)).setItsContent(this.srvI18n.getMsg("total_l"));
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get(pBalance.getTotalLinesLiabilities() * 4 + 7)).setItsContent(pBalance.getTotalLiabilities().toString());
        int oetIdx = pBalance.getTotalLinesLiabilities() * 4 + 10;
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setItsContent(this.srvI18n.getMsg("OwnersEquityTitle"));
        ((TableCell)tblBal.getItsCells().get(oetIdx)).setMergedCell((TableCell)tblBal.getItsCells().get(oetIdx + 1));
        row = 1 + pBalance.getTotalLinesLiabilities() + 2;
        for (int i = totAssLeab; i < totAssLeab + pBalance.getTotalLinesOwnersEquity(); ++i) {
            String cnt = pBalance.getItsLines().get(i).getCredit().compareTo(BigDecimal.ZERO) != 0 ? pBalance.getItsLines().get(i).getCredit().toString() : "(" + pBalance.getItsLines().get(i).getDebit() + ")";
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setItsContent(pBalance.getItsLines().get(i).getAccName());
            ((TableCell)tblBal.getItsCells().get(row * 4 + 2)).setFontNumber(1);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setItsContent(cnt);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
            ((TableCell)tblBal.getItsCells().get(row * 4 + 3)).setFontNumber(1);
            ++row;
        }
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 2)).setItsContent(this.srvI18n.getMsg("total_oe"));
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get((totLeabOwnEq + 3) * 4 + 3)).setItsContent(pBalance.getTotalOwnersEquity().toString());
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 2)).setItsContent(this.srvI18n.getMsg("total_l_oe"));
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setAlignHorizontal(EAlignHorizontal.RIGHT);
        ((TableCell)tblBal.getItsCells().get(lastRowIdx * 4 + 3)).setItsContent(pBalance.getTotalOwnersEquity().add(pBalance.getTotalLiabilities()).toString() + " " + accSet.getCurrency().getItsName());
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat pDateFormat) {
        this.dateFormat = pDateFormat;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }
}

