/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EPageOrientation;
import org.beigesoft.doc.model.EPageSize;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.model.TableRow;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.model.IRequestData;
import org.beigesoft.pdf.model.ERegisteredTtfFont;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.IEntityFileReporter;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public class InvoiceReportPdf<RS, WI>
implements IEntityFileReporter<SalesInvoice, Long> {
    private IPdfFactory<WI> pdfFactory;
    private DateFormat dateFormat = DateFormat.getDateInstance(2);
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;

    public final void makeReport(Map<String, Object> pAddParam, SalesInvoice pInvoice, IRequestData pRequestData, OutputStream pOus) throws Exception {
        int i;
        int j;
        int i2;
        SalesInvoice inv = (SalesInvoice)this.srvOrm.retrieveEntity(pAddParam, (Object)pInvoice);
        SalesInvoiceLine sil = new SalesInvoiceLine();
        sil.setItsOwner(inv);
        inv.setItsLines(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sil, "itsOwner"));
        SalesInvoiceTaxLine sitl = new SalesInvoiceTaxLine();
        sitl.setItsOwner(inv);
        inv.setTaxesLines(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sitl, "itsOwner"));
        SalesInvoiceServiceLine sisl = new SalesInvoiceServiceLine();
        sisl.setItsOwner(inv);
        inv.setServices(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sisl, "itsOwner"));
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(EPageSize.A4, EPageOrientation.PORTRAIT);
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pAddParam);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF_BOLD.toString());
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF.toString());
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContentPaddingBottom(0.5);
        DocTable tblOwner = docMaker.addDocTableNoBorder(doc, 1, 1);
        ((TableCell)tblOwner.getItsCells().get(0)).setItsContent(accSet.getOrganization());
        if (accSet.getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber") + ": " + accSet.getTaxIdentificationNumber());
        }
        int n = 0;
        if (accSet.getRegZip() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regZip") + ": " + accSet.getRegZip());
        }
        if (accSet.getRegAddress1() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress1") + ": " + accSet.getRegAddress1());
        }
        if (accSet.getRegAddress2() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress2") + ": " + accSet.getRegAddress2());
        }
        if (accSet.getRegCity() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCity") + ": " + accSet.getRegCity());
        }
        if (accSet.getRegState() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regState") + ": " + accSet.getRegState());
        }
        if (accSet.getRegCountry() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCountry") + ": " + accSet.getRegCountry());
        }
        ((TableCell)tblOwner.getItsCells().get(0)).setFontNumber(1);
        docMaker.makeDocTableWrapping(tblOwner);
        tblOwner.setAlignHorizontal(EAlignHorizontal.RIGHT);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 1);
        String invNum = inv.getIdBirth() != null ? inv.getIdDatabaseBirth().toString() + "-" + inv.getIdBirth() : inv.getIdDatabaseBirth().toString() + "-" + inv.getItsId();
        String title = this.srvI18n.getMsg("Invoice") + " #" + invNum + " " + this.dateFormat.format(inv.getItsDate());
        ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(title);
        ((TableCell)tblTitle.getItsCells().get(0)).setFontNumber(1);
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        doc.setContainerMarginBottom(1.0);
        docMaker.makeDocTableWrapping(tblTitle);
        DocTable tblCustomer = docMaker.addDocTableNoBorder(doc, 1, 1);
        ((TableCell)tblCustomer.getItsCells().get(0)).setItsContent(inv.getCustomer().getItsName());
        n = 0;
        if (inv.getCustomer().getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber") + ": " + inv.getCustomer().getTaxIdentificationNumber());
        }
        if (inv.getCustomer().getRegZip() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regZip") + ": " + inv.getCustomer().getRegZip());
        }
        if (inv.getCustomer().getRegAddress1() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress1") + ": " + inv.getCustomer().getRegAddress1());
        }
        if (inv.getCustomer().getRegAddress2() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress2") + ": " + inv.getCustomer().getRegAddress2());
        }
        if (inv.getCustomer().getRegCity() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCity") + ": " + inv.getCustomer().getRegCity());
        }
        if (inv.getCustomer().getRegState() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regState") + ": " + inv.getCustomer().getRegState());
        }
        if (inv.getCustomer().getRegCountry() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCountry") + ": " + inv.getCustomer().getRegCountry());
        }
        ((TableCell)tblCustomer.getItsCells().get(0)).setFontNumber(1);
        if (inv.getItsLines() != null && inv.getItsLines().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiGoods = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiGoods.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceLine.class.getSimpleName() + "s"));
            ((TableCell)tblTiGoods.getItsCells().get(0)).setFontNumber(1);
            tblTiGoods.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiGoods);
            doc.setContentPadding(1.0);
            DocTable tblGoods = docMaker.addDocTable(doc, 8, inv.getItsLines().size() + 1);
            tblGoods.setIsRepeatHead(true);
            ((TableRow)tblGoods.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblGoods.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("invItem"));
            ((TableColumn)tblGoods.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblGoods.getItsColumns().get(0)).setWidthInPercentage(60.0);
            ((TableCell)tblGoods.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("unitOfMeasure"));
            ((TableColumn)tblGoods.getItsColumns().get(1)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("itsPrice"));
            ((TableColumn)tblGoods.getItsColumns().get(2)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(3)).setItsContent(this.srvI18n.getMsg("itsQuantity"));
            ((TableColumn)tblGoods.getItsColumns().get(3)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(4)).setItsContent(this.srvI18n.getMsg("subtotal"));
            ((TableColumn)tblGoods.getItsColumns().get(4)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(5)).setItsContent(this.srvI18n.getMsg("taxesDescription"));
            ((TableCell)tblGoods.getItsCells().get(6)).setItsContent(this.srvI18n.getMsg("totalTaxes").replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(6)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(7)).setItsContent(this.srvI18n.getMsg("itsTotal"));
            ((TableColumn)tblGoods.getItsColumns().get(7)).setWraping(EWraping.WRAP_CONTENT);
            for (i2 = 0; i2 < 8; ++i2) {
                ((TableCell)tblGoods.getItsCells().get(i2)).setFontNumber(1);
                ((TableCell)tblGoods.getItsCells().get(i2)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceLine salesInvoiceLine : inv.getItsLines()) {
                i = 0;
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getInvItem().getItsName());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getUnitOfMeasure().getItsName());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getItsPrice().toString());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getItsQuantity().toString());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getSubtotal().toString());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getTaxesDescription());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getTotalTaxes().toString());
                ((TableCell)tblGoods.getItsCells().get(j * 8 + i++)).setItsContent(salesInvoiceLine.getItsTotal().toString());
                ++j;
            }
        }
        if (inv.getServices() != null && inv.getServices().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiServices = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiServices.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceServiceLine.class.getSimpleName() + "s"));
            ((TableCell)tblTiServices.getItsCells().get(0)).setFontNumber(1);
            tblTiServices.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiServices);
            doc.setContentPadding(1.0);
            DocTable tblServices = docMaker.addDocTable(doc, 5, inv.getServices().size() + 1);
            tblServices.setIsRepeatHead(true);
            ((TableRow)tblServices.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblServices.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("service"));
            ((TableColumn)tblServices.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(0)).setWidthInPercentage(35.0);
            ((TableCell)tblServices.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("itsPrice"));
            ((TableColumn)tblServices.getItsColumns().get(1)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(1)).setWidthInPercentage(15.0);
            ((TableCell)tblServices.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("taxesDescription"));
            ((TableColumn)tblServices.getItsColumns().get(2)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(2)).setWidthInPercentage(20.0);
            ((TableCell)tblServices.getItsCells().get(3)).setItsContent(this.srvI18n.getMsg("totalTaxes"));
            ((TableColumn)tblServices.getItsColumns().get(3)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(3)).setWidthInPercentage(15.0);
            ((TableCell)tblServices.getItsCells().get(4)).setItsContent(this.srvI18n.getMsg("itsTotal"));
            ((TableColumn)tblServices.getItsColumns().get(4)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(4)).setWidthInPercentage(15.0);
            for (i2 = 0; i2 < 5; ++i2) {
                ((TableCell)tblServices.getItsCells().get(i2)).setFontNumber(1);
                ((TableCell)tblServices.getItsCells().get(i2)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceServiceLine salesInvoiceServiceLine : inv.getServices()) {
                i = 0;
                ((TableCell)tblServices.getItsCells().get(j * 5 + i++)).setItsContent(salesInvoiceServiceLine.getService().getItsName());
                ((TableCell)tblServices.getItsCells().get(j * 5 + i++)).setItsContent(salesInvoiceServiceLine.getItsPrice().toString());
                ((TableCell)tblServices.getItsCells().get(j * 5 + i++)).setItsContent(salesInvoiceServiceLine.getTaxesDescription());
                ((TableCell)tblServices.getItsCells().get(j * 5 + i++)).setItsContent(salesInvoiceServiceLine.getTotalTaxes().toString());
                ((TableCell)tblServices.getItsCells().get(j * 5 + i++)).setItsContent(salesInvoiceServiceLine.getItsTotal().toString());
                ++j;
            }
        }
        if (inv.getTaxesLines() != null && inv.getTaxesLines().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiTaxes = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiTaxes.setIsRepeatHead(true);
            ((TableRow)tblTiTaxes.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceTaxLine.class.getSimpleName() + "s"));
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setFontNumber(1);
            tblTiTaxes.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiTaxes);
            doc.setContentPadding(1.0);
            DocTable tblTaxes = docMaker.addDocTable(doc, 2, inv.getTaxesLines().size() + 1);
            ((TableCell)tblTaxes.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("tax"));
            ((TableColumn)tblTaxes.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblTaxes.getItsColumns().get(0)).setWidthInPercentage(70.0);
            ((TableCell)tblTaxes.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("itsTotal"));
            for (int i22 = 0; i22 < 2; ++i22) {
                ((TableCell)tblTaxes.getItsCells().get(i22)).setFontNumber(1);
                ((TableCell)tblTaxes.getItsCells().get(i22)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceTaxLine salesInvoiceTaxLine : inv.getTaxesLines()) {
                i = 0;
                ((TableCell)tblTaxes.getItsCells().get(j * 2 + i++)).setItsContent(salesInvoiceTaxLine.getTax().getItsName());
                ((TableCell)tblTaxes.getItsCells().get(j * 2 + i++)).setItsContent(salesInvoiceTaxLine.getItsTotal().toString());
                ++j;
            }
        }
        doc.setAlignHoriCont(EAlignHorizontal.RIGHT);
        DocTable tblRez = docMaker.addDocTableNoBorder(doc, 1, 3);
        ((TableCell)tblRez.getItsCells().get(0)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("subtotal") + ": " + inv.getSubtotal() + " " + accSet.getCurrency().getItsName());
        ((TableCell)tblRez.getItsCells().get(1)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("totalTaxes") + ": " + inv.getTotalTaxes() + " " + accSet.getCurrency().getItsName());
        ((TableCell)tblRez.getItsCells().get(2)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("itsTotal") + ": " + inv.getItsTotal() + " " + accSet.getCurrency().getItsName());
        tblRez.setAlignHorizontal(EAlignHorizontal.RIGHT);
        docMaker.makeDocTableWrapping(tblRez);
        docMaker.addPagination(doc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat pDateFormat) {
        this.dateFormat = pDateFormat;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }
}

