/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.beigesoft.accounting.model.BalanceLine;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.report.ISrvBalanceSheet;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;

public class SrvBalanceSheet<RS>
implements ISrvBalanceSheet {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private ISrvBalance srvBalance;
    private String queryBalance;

    public SrvBalanceSheet() {
    }

    public SrvBalanceSheet(ISrvDatabase<RS> pSrvDatabase, ISrvAccSettings pSrvAccSettings, ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
        this.srvDatabase = pSrvDatabase;
        this.srvAccSettings = pSrvAccSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized BalanceSheet retrieveBalance(Map<String, Object> pAddParam, Date pDate) throws Exception {
        this.getSrvBalance().recalculateAllIfNeed(pAddParam, pDate);
        BalanceSheet result = new BalanceSheet();
        result.setItsDate(pDate);
        String query = this.evalQueryBalance(pAddParam, pDate);
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    String accName = recordSet.getString("ACCOUNTNAME");
                    Integer accType = recordSet.getInteger("ITSTYPE");
                    String accNumber = recordSet.getString("ITSNUMBER");
                    Double debit = recordSet.getDouble("DEBIT");
                    Double credit = recordSet.getDouble("CREDIT");
                    if (debit == 0.0 && credit == 0.0) continue;
                    BalanceLine bl = new BalanceLine();
                    bl.setAccName(accName);
                    bl.setAccNumber(accNumber);
                    bl.setAccType(accType);
                    bl.setDebit(BigDecimal.valueOf(debit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalancePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    bl.setCredit(BigDecimal.valueOf(credit).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getBalancePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (bl.getDebit().doubleValue() == 0.0 && bl.getCredit().doubleValue() == 0.0) continue;
                    result.getItsLines().add(bl);
                    if (accType == 0) {
                        result.setTotalLinesAssets(result.getTotalLinesAssets() + 1);
                        result.setTotalAssets(result.getTotalAssets().add(bl.getDebit().subtract(bl.getCredit())));
                        continue;
                    }
                    if (accType == 1) {
                        result.setTotalLinesLiabilities(result.getTotalLinesLiabilities() + 1);
                        result.setTotalLiabilities(result.getTotalLiabilities().add(bl.getCredit().subtract(bl.getDebit())));
                        continue;
                    }
                    if (accType != 2) continue;
                    result.setTotalLinesOwnersEquity(result.getTotalLinesOwnersEquity() + 1);
                    result.setTotalOwnersEquity(result.getTotalOwnersEquity().add(bl.getCredit().subtract(bl.getDebit())));
                } while (recordSet.moveToNext());
            }
        }
        result.setDetailRowsCount(Math.max(result.getTotalLinesAssets(), result.getTotalLinesLiabilities() + result.getTotalLinesOwnersEquity() + 3));
        return result;
    }

    public final synchronized String evalQueryBalance(Map<String, Object> pAddParam, Date pDate) throws Exception {
        if (this.queryBalance == null) {
            String flName = "/accounting/balance/queryBalanceSheet.sql";
            this.queryBalance = this.loadString(flName);
        }
        String query = this.queryBalance.replace(":DATE1", String.valueOf(this.getSrvBalance().evalDatePeriodStartFor(pAddParam, pDate).getTime()));
        query = query.replace(":DATE2", String.valueOf(pDate.getTime()));
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String loadString(String pFileName) throws IOException {
        URL urlFile = SrvBalanceSheet.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvBalanceSheet.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvBalance getSrvBalance() {
        return this.srvBalance;
    }

    public final void setSrvBalance(ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
    }

    public final synchronized String getQueryBalance() {
        return this.queryBalance;
    }

    public final synchronized void setQueryBalance(String pQueryBalance) {
        this.queryBalance = pQueryBalance;
    }
}

