/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.util.Date;
import java.util.HashMap;
import org.beigesoft.accounting.model.BalanceSheet;
import org.beigesoft.accounting.report.ISrvBalanceSheet;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvDate;

public class SrvReqBalanceSheet<RS>
implements IHandlerRequest {
    private ISrvBalanceSheet srvBalanceSheet;
    private ISrvDate srvDate;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;

    public final void handle(IRequestData pRequestData) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED.intValue());
            this.srvDatabase.beginTransaction();
            Date date2 = this.srvDate.fromIso8601DateTimeNoTz(pRequestData.getParameter("date2"), null);
            HashMap<String, Object> addParam = new HashMap<String, Object>();
            BalanceSheet balanceSheet = this.getSrvBalanceSheet().retrieveBalance(addParam, date2);
            pRequestData.setAttribute("balanceSheet", (Object)balanceSheet);
            pRequestData.setAttribute("accSettings", (Object)this.srvAccSettings.lazyGetAccSettings(addParam));
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvBalanceSheet getSrvBalanceSheet() {
        return this.srvBalanceSheet;
    }

    public final void setSrvBalanceSheet(ISrvBalanceSheet pSrvBalanceSheet) {
        this.srvBalanceSheet = pSrvBalanceSheet;
    }

    public final ISrvDate getSrvDate() {
        return this.srvDate;
    }

    public final void setSrvDate(ISrvDate pSrvDate) {
        this.srvDate = pSrvDate;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }
}

