/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.PurchaseReturnLine;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseReturnLineSave<RS>
implements IEntityProcessor<PurchaseReturnLine, Long> {
    private ISrvI18n srvI18n;
    private ISrvDatabase<RS> srvDatabase;
    private String queryPurchaseReturnLineTaxes;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<UseMaterialEntry> srvUseMaterialEntry;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    public final PurchaseReturnLine process(Map<String, Object> pAddParam, PurchaseReturnLine pEntity, IRequestData pRequestData) throws Exception {
        PurchaseInvoice purchaseInvoice;
        if (pEntity.getIsNew().booleanValue()) {
            pEntity.setItsOwner((PurchaseReturn)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner()));
            purchaseInvoice = (PurchaseInvoice)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getItsOwner().getPurchaseInvoice());
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            if (pEntity.getReversedId() != null) {
                PurchaseReturnLine reversed = (PurchaseReturnLine)this.getSrvOrm().retrieveEntityById(pAddParam, PurchaseReturnLine.class, (Object)pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pAddParam.get("user"));
                }
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setPurchaseInvoiceLine(reversed.getPurchaseInvoiceLine());
                pEntity.setPurchInvLnAppearance(reversed.getPurchInvLnAppearance());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pAddParam, (Object)reversed);
                PurchaseReturnGoodsTaxLine pigtlt = new PurchaseReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                List tls = this.getSrvOrm().retrieveListForField(pAddParam, (Object)pigtlt, "itsOwner");
                for (PurchaseReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pAddParam, (Object)pigtl);
                }
                this.srvWarehouseEntry.reverseDraw(pAddParam, pEntity);
                this.srvUseMaterialEntry.reverseDraw(pAddParam, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                if (pEntity.getItsQuantity().doubleValue() == 0.0) {
                    throw new ExceptionWithCode(1003, "Quantity is 0!" + pAddParam.get("user"));
                }
                if (pEntity.getPurchaseInvoiceLine() == null) {
                    throw new ExceptionWithCode(1003, "wrong_purchaseInvoiceLine");
                }
                String langDef = (String)pAddParam.get("langDef");
                pEntity.setPurchaseInvoiceLine((PurchaseInvoiceLine)this.getSrvOrm().retrieveEntity(pAddParam, (Object)pEntity.getPurchaseInvoiceLine()));
                pEntity.setPurchInvLnAppearance(this.getSrvI18n().getMsg(PurchaseInvoiceLine.class.getSimpleName() + "short", langDef) + " #" + pEntity.getPurchaseInvoiceLine().getIdDatabaseBirth() + "-" + pEntity.getPurchaseInvoiceLine().getItsId() + ", " + pEntity.getPurchaseInvoiceLine().getInvItem().getItsName() + ", " + pEntity.getPurchaseInvoiceLine().getUnitOfMeasure().getItsName() + ", " + this.getSrvI18n().getMsg("itsCost", langDef) + "=" + this.prnc(pAddParam, pEntity.getPurchaseInvoiceLine().getItsCost()) + ", " + this.getSrvI18n().getMsg("rest_was", langDef) + "=" + this.prnq(pAddParam, pEntity.getPurchaseInvoiceLine().getTheRest()));
                pEntity.setItsQuantity(pEntity.getItsQuantity().setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getQuantityPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                pEntity.setSubtotal(pEntity.getItsQuantity().multiply(pEntity.getPurchaseInvoiceLine().getItsCost()).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                BigDecimal totalTaxes = BigDecimal.ZERO;
                String taxesDescription = "";
                HashSet<PurchaseReturnGoodsTaxLine> tls = null;
                if (!purchaseInvoice.getVendor().getIsForeigner().booleanValue() && this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue() && pEntity.getPurchaseInvoiceLine().getInvItem().getTaxCategory() != null) {
                    tls = new HashSet<PurchaseReturnGoodsTaxLine>();
                    List pstl = this.getSrvOrm().retrieveListWithConditions(pAddParam, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getPurchaseInvoiceLine().getInvItem().getTaxCategory().getItsId());
                    BigDecimal bigDecimal100 = new BigDecimal("100.00");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine pst : pstl) {
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)pst.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)pst.getTax().getItsType())) continue;
                        BigDecimal addTx = pEntity.getSubtotal().multiply(pst.getItsPercentage()).divide(bigDecimal100, (int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode());
                        totalTaxes = totalTaxes.add(addTx);
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        sb.append(pst.getTax().getItsName() + " " + this.prn(pAddParam, addTx));
                        PurchaseReturnGoodsTaxLine pigtl = new PurchaseReturnGoodsTaxLine();
                        pigtl.setIsNew(true);
                        pigtl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        pigtl.setItsTotal(addTx);
                        pigtl.setTax(pst.getTax());
                        tls.add(pigtl);
                    }
                    taxesDescription = sb.toString();
                }
                pEntity.setTaxesDescription(taxesDescription);
                pEntity.setTotalTaxes(totalTaxes);
                pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
                this.getSrvOrm().insertEntity(pAddParam, (Object)pEntity);
                pEntity.setIsNew(false);
                if (tls != null) {
                    for (PurchaseReturnGoodsTaxLine pigtl : tls) {
                        pigtl.setItsOwner(pEntity);
                        pigtl.setInvoiceId(pEntity.getItsOwner().getItsId());
                        this.getSrvOrm().insertEntity(pAddParam, (Object)pigtl);
                        pigtl.setIsNew(false);
                    }
                }
                this.srvWarehouseEntry.withdrawal(pAddParam, pEntity, pEntity.getWarehouseSiteFo());
                this.srvUseMaterialEntry.withdrawalFrom(pAddParam, pEntity, pEntity.getPurchaseInvoiceLine(), pEntity.getItsQuantity());
            }
        } else {
            throw new ExceptionWithCode(403, "Attempt to update sales invoice line by " + pAddParam.get("user"));
        }
        String query = "select sum(SUBTOTAL) as SUBTOTAL, sum(TOTALTAXES) as TOTALTAXES from PURCHASERETURNLINE where ITSOWNER=" + pEntity.getItsOwner().getItsId();
        String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
        this.getSrvOrm().updateEntity(pAddParam, (Object)pEntity.getItsOwner());
        this.updateTaxLines(pAddParam, pEntity.getItsOwner(), purchaseInvoice);
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", PurchaseReturn.class.getSimpleName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pAddParam, PurchaseReturn pItsOwner, PurchaseInvoice pPurchaseInvoice) throws Exception {
        block14: {
            List citl;
            block13: {
                citl = this.getSrvOrm().retrieveListWithConditions(pAddParam, PurchaseReturnTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
                if (pPurchaseInvoice.getVendor().getIsForeigner().booleanValue() || !this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getIsExtractSalesTaxFromPurchase().booleanValue()) break block13;
                String query = this.lazyGetQueryPurchaseReturnLineTaxes().replace(":INVOICEID", pItsOwner.getItsId().toString());
                int countUpdatedSitl = 0;
                try (IRecordSet recordSet = null;){
                    recordSet = this.getSrvDatabase().retrieveRecords(query);
                    if (recordSet.moveToFirst()) {
                        do {
                            PurchaseReturnTaxLine cit;
                            Long taxId = recordSet.getLong("TAXID");
                            Double totalTax = recordSet.getDouble("TOTALTAX");
                            if (citl.size() > countUpdatedSitl) {
                                cit = (PurchaseReturnTaxLine)((Object)citl.get(countUpdatedSitl));
                                ++countUpdatedSitl;
                            } else {
                                cit = new PurchaseReturnTaxLine();
                                cit.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                                cit.setItsOwner(pItsOwner);
                                cit.setIsNew(true);
                            }
                            Tax tax = new Tax();
                            tax.setItsId(taxId);
                            cit.setTax(tax);
                            cit.setItsTotal(BigDecimal.valueOf(totalTax).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                            if (cit.getIsNew().booleanValue()) {
                                this.getSrvOrm().insertEntity(pAddParam, (Object)cit);
                                cit.setIsNew(false);
                                continue;
                            }
                            this.getSrvOrm().updateEntity(pAddParam, (Object)cit);
                        } while (recordSet.moveToNext());
                    }
                }
                if (countUpdatedSitl >= citl.size()) break block14;
                for (int j = countUpdatedSitl; j < citl.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pAddParam, citl.get(j));
                }
                break block14;
            }
            if (citl.size() > 0) {
                for (PurchaseReturnTaxLine prtln : citl) {
                    this.getSrvOrm().deleteEntity(pAddParam, (Object)prtln);
                }
            }
        }
    }

    public final String lazyGetQueryPurchaseReturnLineTaxes() throws Exception {
        if (this.queryPurchaseReturnLineTaxes == null) {
            String flName = "/accounting/trade/purchaseReturnLineTaxes.sql";
            this.queryPurchaseReturnLineTaxes = this.loadString(flName);
        }
        return this.queryPurchaseReturnLineTaxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcPurchaseReturnLineSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcPurchaseReturnLineSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("pricePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final String prnc(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("costPrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final String prnq(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("quantityPrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<UseMaterialEntry> getSrvUseMaterialEntry() {
        return this.srvUseMaterialEntry;
    }

    public final void setSrvUseMaterialEntry(ISrvDrawItemEntry<UseMaterialEntry> pSrvUseMaterialEntry) {
        this.srvUseMaterialEntry = pSrvUseMaterialEntry;
    }

    public final void setQueryPurchaseReturnLineTaxes(String pQueryPurchaseReturnLineTaxes) {
        this.queryPurchaseReturnLineTaxes = pQueryPurchaseReturnLineTaxes;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

