/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.I18nAccounting;
import org.beigesoft.accounting.persistable.I18nBuyer;
import org.beigesoft.accounting.persistable.I18nCurrency;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EPageOrientation;
import org.beigesoft.doc.model.EPageSize;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.model.TableRow;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.model.IRequestData;
import org.beigesoft.pdf.model.ERegisteredTtfFont;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.IEntityFileReporter;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class InvoiceReportPdf<RS, WI>
implements IEntityFileReporter<SalesInvoice, Long> {
    private IPdfFactory<WI> pdfFactory;
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvNumberToString srvNumberToString;
    private String salesInvOverseaseLinesSql;
    private String salesInvOverseaseServiceLinesSql;

    public final void makeReport(Map<String, Object> pAddParam, SalesInvoice pInvoice, IRequestData pRequestData, OutputStream pOus) throws Exception {
        int k;
        int i;
        int j;
        int i2;
        String curSign;
        boolean isPrnCurLf;
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pAddParam);
        String lang = (String)pAddParam.get("lang");
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(lang));
        I18nCurrency i18nCurrency = (I18nCurrency)((Object)pAddParam.get("i18nCurrency"));
        if (i18nCurrency != null) {
            isPrnCurLf = i18nCurrency.getPrintCurrencyLeft();
            curSign = i18nCurrency.getUseCurrencySign().booleanValue() ? i18nCurrency.getHasName().getItsSign() : " " + i18nCurrency.getItsName() + " ";
        } else {
            curSign = (String)pAddParam.get("curSign");
            isPrnCurLf = accSet.getPrintCurrencyLeft();
        }
        SalesInvoice inv = this.retrieveEntity(pAddParam, pInvoice, lang, !lang.equals(langDef));
        Document doc = this.pdfFactory.lazyGetFctDocument().createDoc(EPageSize.A4, EPageOrientation.PORTRAIT);
        PdfDocument docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF_BOLD.toString());
        pdfMaker.addFontTtf(docPdf, ERegisteredTtfFont.DEJAVUSERIF.toString());
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContentPaddingBottom(1.0);
        DocTable tblOwner = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18nAccounting i18nAccounting = (I18nAccounting)((Object)pAddParam.get("i18nAccounting"));
        if (i18nAccounting != null) {
            ((TableCell)tblOwner.getItsCells().get(0)).setItsContent(i18nAccounting.getOrganizationName());
        } else {
            ((TableCell)tblOwner.getItsCells().get(0)).setItsContent(accSet.getOrganization());
        }
        int n = 0;
        if (accSet.getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber", lang) + ": " + accSet.getTaxIdentificationNumber());
        }
        if (accSet.getRegZip() != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regZip", lang) + ": " + accSet.getRegZip());
        }
        String addr = null;
        addr = i18nAccounting != null ? i18nAccounting.getRegAddress1() : accSet.getRegAddress1();
        if (addr != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress1", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegAddress2() : accSet.getRegAddress2()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress2", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegCity() : accSet.getRegCity()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCity", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegState() : accSet.getRegState()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regState", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegCountry() : accSet.getRegCountry()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            ((TableCell)tblOwner.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCountry", lang) + ": " + addr);
        }
        ((TableCell)tblOwner.getItsCells().get(0)).setFontNumber(1);
        docMaker.makeDocTableWrapping(tblOwner);
        tblOwner.setAlignHorizontal(EAlignHorizontal.RIGHT);
        DocTable tblTitle = docMaker.addDocTableNoBorder(doc, 1, 1);
        String invNum = inv.getIdBirth() != null ? inv.getIdDatabaseBirth().toString() + "-" + inv.getIdBirth() : inv.getIdDatabaseBirth().toString() + "-" + inv.getItsId();
        String title = this.srvI18n.getMsg("Invoice", lang) + " #" + invNum + ", " + this.srvI18n.getMsg("date", lang) + ": " + dateFormat.format(inv.getItsDate());
        ((TableCell)tblTitle.getItsCells().get(0)).setItsContent(title);
        ((TableCell)tblTitle.getItsCells().get(0)).setFontNumber(1);
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        doc.setContainerMarginBottom(1.0);
        docMaker.makeDocTableWrapping(tblTitle);
        DocTable tblCustomer = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18nBuyer i18nBuyer = null;
        if (!lang.equals(langDef)) {
            i18nBuyer = (I18nBuyer)((Object)this.getSrvOrm().retrieveEntityById(pAddParam, I18nBuyer.class, (Object)inv.getCustomer()));
        }
        if (i18nBuyer != null) {
            ((TableCell)tblCustomer.getItsCells().get(0)).setItsContent(i18nBuyer.getItsName());
        } else {
            ((TableCell)tblCustomer.getItsCells().get(0)).setItsContent(inv.getCustomer().getItsName());
        }
        n = 0;
        if (inv.getCustomer().getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber", lang) + ": " + inv.getCustomer().getTaxIdentificationNumber());
        }
        if (inv.getCustomer().getRegZip() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regZip", lang) + ": " + inv.getCustomer().getRegZip());
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegAddress1() : inv.getCustomer().getRegAddress1()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress1", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegAddress2() : inv.getCustomer().getRegAddress2()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regAddress2", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegCity() : inv.getCustomer().getRegCity()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCity", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegState() : inv.getCustomer().getRegState()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regState", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegCountry() : inv.getCustomer().getRegCountry()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            ((TableCell)tblCustomer.getItsCells().get(++n)).setItsContent(this.srvI18n.getMsg("regCountry", lang) + ": " + addr);
        }
        ((TableCell)tblCustomer.getItsCells().get(0)).setFontNumber(1);
        if (inv.getItsLines() != null && inv.getItsLines().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiGoods = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiGoods.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceLine.class.getSimpleName() + "s", lang));
            ((TableCell)tblTiGoods.getItsCells().get(0)).setFontNumber(1);
            tblTiGoods.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiGoods);
            doc.setContentPadding(1.0);
            doc.setContentPaddingBottom(1.5);
            DocTable tblGoods = docMaker.addDocTable(doc, 8, inv.getItsLines().size() + 1);
            tblGoods.setIsRepeatHead(true);
            ((TableRow)tblGoods.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblGoods.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("invItem", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblGoods.getItsColumns().get(0)).setWidthInPercentage(60.0);
            ((TableCell)tblGoods.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("unitOfMeasure", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(1)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("itsPrice", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(2)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(3)).setItsContent(this.srvI18n.getMsg("itsQuantity", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(3)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(4)).setItsContent(this.srvI18n.getMsg("subtotal", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(4)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(5)).setItsContent(this.srvI18n.getMsg("taxesDescription", lang));
            ((TableCell)tblGoods.getItsCells().get(6)).setItsContent(this.srvI18n.getMsg("totalTaxes", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(6)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblGoods.getItsCells().get(7)).setItsContent(this.srvI18n.getMsg("itsTotal", lang).replace(" ", "\n"));
            ((TableColumn)tblGoods.getItsColumns().get(7)).setWraping(EWraping.WRAP_CONTENT);
            for (i2 = 0; i2 < 8; ++i2) {
                ((TableCell)tblGoods.getItsCells().get(i2)).setFontNumber(1);
                ((TableCell)tblGoods.getItsCells().get(i2)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceLine salesInvoiceLine : inv.getItsLines()) {
                i = 0;
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(salesInvoiceLine.getInvItem().getItsName());
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(salesInvoiceLine.getUnitOfMeasure().getItsName());
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceLine.getItsPrice()));
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceLine.getItsQuantity()));
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceLine.getSubtotal()));
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(salesInvoiceLine.getTaxesDescription());
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceLine.getTotalTaxes()));
                k = j * 8 + i++;
                ((TableCell)tblGoods.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblGoods.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceLine.getItsTotal()));
                ++j;
            }
        }
        if (inv.getServices() != null && inv.getServices().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiServices = docMaker.addDocTableNoBorder(doc, 1, 1);
            ((TableCell)tblTiServices.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceServiceLine.class.getSimpleName() + "s", lang));
            ((TableCell)tblTiServices.getItsCells().get(0)).setFontNumber(1);
            tblTiServices.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiServices);
            doc.setContentPadding(1.0);
            doc.setContentPaddingBottom(1.5);
            DocTable tblServices = docMaker.addDocTable(doc, 8, inv.getServices().size() + 1);
            tblServices.setIsRepeatHead(true);
            ((TableRow)tblServices.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblServices.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("service", lang));
            ((TableColumn)tblServices.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(0)).setWidthInPercentage(35.0);
            ((TableCell)tblServices.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("unitOfMeasure", lang).replace(" ", "\n"));
            ((TableColumn)tblServices.getItsColumns().get(1)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblServices.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("itsPrice", lang));
            ((TableColumn)tblServices.getItsColumns().get(2)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(2)).setWidthInPercentage(15.0);
            ((TableCell)tblServices.getItsCells().get(3)).setItsContent(this.srvI18n.getMsg("itsQuantity", lang).replace(" ", "\n"));
            ((TableColumn)tblServices.getItsColumns().get(3)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblServices.getItsCells().get(4)).setItsContent(this.srvI18n.getMsg("subtotal", lang).replace(" ", "\n"));
            ((TableColumn)tblServices.getItsColumns().get(4)).setWraping(EWraping.WRAP_CONTENT);
            ((TableCell)tblServices.getItsCells().get(5)).setItsContent(this.srvI18n.getMsg("taxesDescription", lang));
            ((TableColumn)tblServices.getItsColumns().get(5)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(5)).setWidthInPercentage(20.0);
            ((TableCell)tblServices.getItsCells().get(6)).setItsContent(this.srvI18n.getMsg("totalTaxes", lang));
            ((TableColumn)tblServices.getItsColumns().get(6)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(6)).setWidthInPercentage(15.0);
            ((TableCell)tblServices.getItsCells().get(7)).setItsContent(this.srvI18n.getMsg("itsTotal", lang));
            ((TableColumn)tblServices.getItsColumns().get(7)).setIsWidthFixed(true);
            ((TableColumn)tblServices.getItsColumns().get(7)).setWidthInPercentage(15.0);
            for (i2 = 0; i2 < 8; ++i2) {
                ((TableCell)tblServices.getItsCells().get(i2)).setFontNumber(1);
                ((TableCell)tblServices.getItsCells().get(i2)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceServiceLine salesInvoiceServiceLine : inv.getServices()) {
                i = 0;
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(salesInvoiceServiceLine.getService().getItsName());
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(salesInvoiceServiceLine.getUnitOfMeasure().getItsName());
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceServiceLine.getItsPrice()));
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceServiceLine.getItsQuantity()));
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceServiceLine.getSubtotal()));
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.CENTER);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(salesInvoiceServiceLine.getTaxesDescription());
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceServiceLine.getTotalTaxes()));
                k = j * 8 + i++;
                ((TableCell)tblServices.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblServices.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceServiceLine.getItsTotal()));
                ++j;
            }
        }
        if (inv.getTaxesLines() != null && inv.getTaxesLines().size() > 0) {
            doc.setContainerMarginBottom(2.0);
            DocTable tblTiTaxes = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiTaxes.setIsRepeatHead(true);
            ((TableRow)tblTiTaxes.getItsRows().get(0)).setIsHead(true);
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg(SalesInvoiceTaxLine.class.getSimpleName() + "s", lang));
            ((TableCell)tblTiTaxes.getItsCells().get(0)).setFontNumber(1);
            tblTiTaxes.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiTaxes);
            doc.setContentPadding(1.0);
            doc.setContentPaddingBottom(1.5);
            DocTable tblTaxes = docMaker.addDocTable(doc, 2, inv.getTaxesLines().size() + 1);
            ((TableCell)tblTaxes.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("tax", lang));
            ((TableColumn)tblTaxes.getItsColumns().get(0)).setIsWidthFixed(true);
            ((TableColumn)tblTaxes.getItsColumns().get(0)).setWidthInPercentage(70.0);
            ((TableCell)tblTaxes.getItsCells().get(1)).setItsContent(this.srvI18n.getMsg("itsTotal", lang));
            for (int i22 = 0; i22 < 2; ++i22) {
                ((TableCell)tblTaxes.getItsCells().get(i22)).setFontNumber(1);
                ((TableCell)tblTaxes.getItsCells().get(i22)).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            j = 1;
            for (SalesInvoiceTaxLine salesInvoiceTaxLine : inv.getTaxesLines()) {
                i = 0;
                ((TableCell)tblTaxes.getItsCells().get(j * 2 + i++)).setItsContent(salesInvoiceTaxLine.getTax().getItsName());
                k = j * 2 + i++;
                ((TableCell)tblTaxes.getItsCells().get(k)).setAlignHorizontal(EAlignHorizontal.RIGHT);
                ((TableCell)tblTaxes.getItsCells().get(k)).setItsContent(this.prn(pAddParam, salesInvoiceTaxLine.getItsTotal()));
                ++j;
            }
        }
        doc.setAlignHoriCont(EAlignHorizontal.RIGHT);
        DocTable tblRez = docMaker.addDocTableNoBorder(doc, 2, 3);
        ((TableCell)tblRez.getItsCells().get(0)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(0)).setItsContent(this.srvI18n.getMsg("subtotal", lang) + ": ");
        ((TableCell)tblRez.getItsCells().get(1)).setFontNumber(1);
        String cnt = isPrnCurLf ? curSign + this.prn(pAddParam, inv.getSubtotal()) : this.prn(pAddParam, inv.getSubtotal()) + curSign;
        ((TableCell)tblRez.getItsCells().get(1)).setItsContent(cnt);
        ((TableCell)tblRez.getItsCells().get(2)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(2)).setItsContent(this.srvI18n.getMsg("totalTaxes", lang) + ": ");
        ((TableCell)tblRez.getItsCells().get(3)).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(pAddParam, inv.getTotalTaxes()) : this.prn(pAddParam, inv.getTotalTaxes()) + curSign;
        ((TableCell)tblRez.getItsCells().get(3)).setItsContent(cnt);
        ((TableCell)tblRez.getItsCells().get(4)).setFontNumber(1);
        ((TableCell)tblRez.getItsCells().get(4)).setItsContent(this.srvI18n.getMsg("itsTotal", lang) + ": ");
        ((TableCell)tblRez.getItsCells().get(5)).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(pAddParam, inv.getItsTotal()) : this.prn(pAddParam, inv.getItsTotal()) + curSign;
        ((TableCell)tblRez.getItsCells().get(5)).setItsContent(cnt);
        tblRez.setAlignHorizontal(EAlignHorizontal.RIGHT);
        docMaker.makeDocTableWrapping(tblRez);
        docMaker.addPagination(doc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final SalesInvoice retrieveEntity(Map<String, Object> pAddParam, SalesInvoice pInvoice, String pLang, boolean pIsOverseas) throws Exception {
        SalesInvoice inv = (SalesInvoice)this.srvOrm.retrieveEntity(pAddParam, (Object)pInvoice);
        if (pIsOverseas) {
            HashSet<String> ndFlSil = new HashSet<String>();
            ndFlSil.add("itsId");
            ndFlSil.add("subtotal");
            ndFlSil.add("totalTaxes");
            ndFlSil.add("taxesDescription");
            ndFlSil.add("invItem");
            ndFlSil.add("unitOfMeasure");
            ndFlSil.add("itsQuantity");
            ndFlSil.add("itsPrice");
            ndFlSil.add("itsTotal");
            pAddParam.put("SalesInvoiceLineneededFields", ndFlSil);
            HashSet<String> ndFlItUm = new HashSet<String>();
            ndFlItUm.add("itsId");
            ndFlItUm.add("itsName");
            pAddParam.put("InvItemneededFields", ndFlItUm);
            pAddParam.put("UnitOfMeasureneededFields", ndFlItUm);
            inv.setItsLines(this.getSrvOrm().retrieveListByQuery(pAddParam, SalesInvoiceLine.class, this.evalSalesInvOverseaseLinesSql(inv.getItsId().toString(), pLang)));
            pAddParam.remove("SalesInvoiceLineneededFields");
            pAddParam.remove("InvItemneededFields");
            pAddParam.remove("UnitOfMeasureneededFields");
        } else {
            SalesInvoiceLine sil = new SalesInvoiceLine();
            sil.setItsOwner(inv);
            pAddParam.put("SalesInvoiceLineitsOwnerdeepLevel", 1);
            inv.setItsLines(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sil, "itsOwner"));
            pAddParam.remove("SalesInvoiceLineitsOwnerdeepLevel");
        }
        SalesInvoiceTaxLine sitl = new SalesInvoiceTaxLine();
        sitl.setItsOwner(inv);
        pAddParam.put("SalesInvoiceTaxLineitsOwnerdeepLevel", 1);
        inv.setTaxesLines(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sitl, "itsOwner"));
        pAddParam.remove("SalesInvoiceTaxLineitsOwnerdeepLevel");
        if (pIsOverseas) {
            HashSet<String> ndFlSil = new HashSet<String>();
            ndFlSil.add("itsId");
            ndFlSil.add("subtotal");
            ndFlSil.add("totalTaxes");
            ndFlSil.add("taxesDescription");
            ndFlSil.add("unitOfMeasure");
            ndFlSil.add("itsQuantity");
            ndFlSil.add("service");
            ndFlSil.add("itsPrice");
            ndFlSil.add("itsTotal");
            pAddParam.put("SalesInvoiceServiceLineneededFields", ndFlSil);
            HashSet<String> ndFlItUm = new HashSet<String>();
            ndFlItUm.add("itsId");
            ndFlItUm.add("itsName");
            pAddParam.put("ServiceToSaleneededFields", ndFlItUm);
            pAddParam.put("UnitOfMeasureneededFields", ndFlItUm);
            inv.setServices(this.getSrvOrm().retrieveListByQuery(pAddParam, SalesInvoiceServiceLine.class, this.evalSalesInvOverseaseServiceLinesSql(inv.getItsId().toString(), pLang)));
            pAddParam.remove("SalesInvoiceServiceLineneededFields");
            pAddParam.remove("ServiceToSaleneededFields");
            pAddParam.remove("UnitOfMeasureneededFields");
        } else {
            SalesInvoiceServiceLine sisl = new SalesInvoiceServiceLine();
            sisl.setItsOwner(inv);
            pAddParam.put("SalesInvoiceServiceLineitsOwnerdeepLevel", 1);
            inv.setServices(this.getSrvOrm().retrieveListForField(pAddParam, (Object)sisl, "itsOwner"));
        }
        pAddParam.remove("SalesInvoiceServiceLineitsOwnerdeepLevel");
        return inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSalesInvOverseaseServiceLinesSql(String pItsOwnerId, String pLang) throws Exception {
        if (this.salesInvOverseaseServiceLinesSql == null) {
            InvoiceReportPdf invoiceReportPdf = this;
            synchronized (invoiceReportPdf) {
                if (this.salesInvOverseaseServiceLinesSql == null) {
                    String flName = "/accounting/trade/salesInvOverseaseServiceLines.sql";
                    this.salesInvOverseaseServiceLinesSql = this.loadString(flName);
                }
            }
        }
        String query = this.salesInvOverseaseServiceLinesSql.replace(":ITSOWNER", pItsOwnerId).replace(":LANG", pLang);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSalesInvOverseaseLinesSql(String pItsOwnerId, String pLang) throws Exception {
        if (this.salesInvOverseaseLinesSql == null) {
            InvoiceReportPdf invoiceReportPdf = this;
            synchronized (invoiceReportPdf) {
                if (this.salesInvOverseaseLinesSql == null) {
                    String flName = "/accounting/trade/salesInvOverseaseLines.sql";
                    this.salesInvOverseaseLinesSql = this.loadString(flName);
                }
            }
        }
        String query = this.salesInvOverseaseLinesSql.replace(":ITSOWNER", pItsOwnerId).replace(":LANG", pLang);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = InvoiceReportPdf.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = InvoiceReportPdf.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pAddParam, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pAddParam.get("dseparatorv"), (String)pAddParam.get("dgseparatorv"), (Integer)pAddParam.get("pricePrecision"), (Integer)pAddParam.get("digitsInGroup"));
    }

    public final synchronized String getSalesInvOverseaseLinesSql() {
        return this.salesInvOverseaseLinesSql;
    }

    public final synchronized void setSalesInvOverseaseLinesSql(String pSalesInvOverseaseLinesSql) {
        this.salesInvOverseaseLinesSql = pSalesInvOverseaseLinesSql;
    }

    public final synchronized String getSalesInvOverseaseServiceLinesSql() {
        return this.salesInvOverseaseServiceLinesSql;
    }

    public final synchronized void setSalesInvOverseaseServiceLinesSql(String pSalesInvOverseaseServiceLinesSql) {
        this.salesInvOverseaseServiceLinesSql = pSalesInvOverseaseServiceLinesSql;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

