/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.beigesoft.accounting.model.ENormalBalanceType;
import org.beigesoft.accounting.model.LedgerDetail;
import org.beigesoft.accounting.model.LedgerDetailLine;
import org.beigesoft.accounting.model.LedgerPrevious;
import org.beigesoft.accounting.model.LedgerPreviousLine;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.accounting.service.ISrvLedger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;

public class SrvLedger<RS>
implements ISrvLedger {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private ISrvBalance srvBalance;
    private String queryPrevious;
    private String queryDetail;

    public SrvLedger() {
    }

    public SrvLedger(ISrvDatabase<RS> pSrvDatabase, ISrvAccSettings pSrvAccSettings, ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
        this.srvDatabase = pSrvDatabase;
        this.srvAccSettings = pSrvAccSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LedgerPrevious retrievePrevious(Map<String, Object> pAddParam, Account pAccount, Date pDate1, String pSubaccId) throws Exception {
        this.getSrvBalance().recalculateAllIfNeed(pAddParam, pDate1);
        LedgerPrevious result = new LedgerPrevious();
        if (this.queryPrevious == null) {
            String flName = "/accounting/ledger/queryPreviousSl.sql";
            this.queryPrevious = this.loadString(flName);
        }
        String query = this.queryPrevious.replace(":DATEBALANCE", String.valueOf(this.getSrvBalance().evalDatePeriodStartFor(pAddParam, pDate1).getTime()));
        query = query.replace(":DATE1", String.valueOf(pDate1.getTime()));
        query = query.replace(":ACCID", "'" + pAccount.getItsId() + "'");
        String whereSubaccDebit = "";
        String whereSubaccCredit = "";
        String whereSubacc = "";
        if (pSubaccId != null && pSubaccId.length() > 0) {
            whereSubaccDebit = " and SUBACCDEBITID='" + pSubaccId + "'";
            whereSubaccCredit = " and SUBACCCREDITID='" + pSubaccId + "'";
            whereSubacc = " and SUBACCOUNT='" + pSubaccId + "'";
        }
        query = query.replace(":SUBACCDEBIT", whereSubaccDebit);
        query = query.replace(":SUBACCCREDIT", whereSubaccCredit);
        query = query.replace(":SUBACC", whereSubacc);
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    LedgerPreviousLine lpl = new LedgerPreviousLine();
                    String subaccName = recordSet.getString("SUBACC");
                    lpl.setDebit(BigDecimal.valueOf(recordSet.getDouble("DEBIT")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    lpl.setCredit(BigDecimal.valueOf(recordSet.getDouble("CREDIT")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    if (pAccount.getNormalBalanceType() == ENormalBalanceType.DEBIT) {
                        lpl.setBalance(lpl.getDebit().subtract(lpl.getCredit()));
                    } else {
                        lpl.setBalance(lpl.getCredit().subtract(lpl.getDebit()));
                    }
                    result.getLinesMap().put(subaccName, lpl);
                    result.setDebitAcc(result.getDebitAcc().add(lpl.getDebit()));
                    result.setCreditAcc(result.getCreditAcc().add(lpl.getCredit()));
                } while (recordSet.moveToNext());
            }
        }
        if (pAccount.getNormalBalanceType() == ENormalBalanceType.DEBIT) {
            result.setBalanceAcc(result.getDebitAcc().subtract(result.getCreditAcc()));
        } else {
            result.setBalanceAcc(result.getCreditAcc().subtract(result.getDebitAcc()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LedgerDetail retrieveDetail(Map<String, Object> pAddParam, Account pAccount, Date pDate1, Date pDate2, String pSubaccId, LedgerPrevious ledgerPrevious) throws Exception {
        LedgerDetail result = new LedgerDetail();
        if (this.queryDetail == null) {
            String flName = "/accounting/ledger/queryDetailSl.sql";
            this.queryDetail = this.loadString(flName);
        }
        String query = this.queryDetail.replace(":DATE1", String.valueOf(pDate1.getTime()));
        query = query.replace(":DATE2", String.valueOf(pDate2.getTime()));
        query = query.replace(":ACCID", "'" + pAccount.getItsId() + "'");
        String whereSubaccDebit = "";
        String whereSubaccCredit = "";
        if (pSubaccId != null && pSubaccId.length() > 0) {
            whereSubaccDebit = " and SUBACCDEBITID='" + pSubaccId + "'";
            whereSubaccCredit = " and SUBACCCREDITID='" + pSubaccId + "'";
        }
        query = query.replace(":SUBACCDEBIT", whereSubaccDebit);
        query = query.replace(":SUBACCCREDIT", whereSubaccCredit);
        try (IRecordSet recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                do {
                    LedgerDetailLine ldl = new LedgerDetailLine();
                    ldl.setItsDate(new Date(recordSet.getLong("ITSDATE")));
                    ldl.setSourceId(recordSet.getLong("SOURCEID"));
                    ldl.setSourceType(recordSet.getInteger("SOURCETYPE"));
                    ldl.setDescription(recordSet.getString("DESCRIPTION"));
                    ldl.setSubaccName(recordSet.getString("SUBACC"));
                    ldl.setCorrAccName(recordSet.getString("CORACCNAME"));
                    ldl.setCorrSubaccName(recordSet.getString("CORSUBACC"));
                    ldl.setCorrAccNumber(recordSet.getString("CORACCNUMBER"));
                    Boolean isDebit = recordSet.getInteger("ISDEBIT") == 1;
                    if (isDebit.booleanValue()) {
                        ldl.setDebit(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    } else {
                        ldl.setCredit(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    }
                    result.setDebitAcc(result.getDebitAcc().add(ldl.getDebit()));
                    result.setCreditAcc(result.getCreditAcc().add(ldl.getCredit()));
                    if (result.getSubaccDebitTotal().get(ldl.getSubaccName()) == null) {
                        result.getSubaccDebitTotal().put(ldl.getSubaccName(), BigDecimal.ZERO);
                        result.getSubaccCreditTotal().put(ldl.getSubaccName(), BigDecimal.ZERO);
                    }
                    result.getSubaccDebitTotal().put(ldl.getSubaccName(), result.getSubaccDebitTotal().get(ldl.getSubaccName()).add(ldl.getDebit()));
                    result.getSubaccCreditTotal().put(ldl.getSubaccName(), result.getSubaccCreditTotal().get(ldl.getSubaccName()).add(ldl.getCredit()));
                    if (pAccount.getNormalBalanceType() == ENormalBalanceType.DEBIT) {
                        result.getSubaccBalanceTotal().put(ldl.getSubaccName(), result.getSubaccDebitTotal().get(ldl.getSubaccName()).subtract(result.getSubaccCreditTotal().get(ldl.getSubaccName())));
                        result.setBalanceAcc(result.getDebitAcc().subtract(result.getCreditAcc()));
                        ldl.setBalance(result.getBalanceAcc());
                        ldl.setBalanceSubacc(result.getSubaccBalanceTotal().get(ldl.getSubaccName()));
                    } else {
                        result.getSubaccBalanceTotal().put(ldl.getSubaccName(), result.getSubaccCreditTotal().get(ldl.getSubaccName()).subtract(result.getSubaccDebitTotal().get(ldl.getSubaccName())));
                        result.setBalanceAcc(result.getCreditAcc().subtract(result.getDebitAcc()));
                        ldl.setBalance(result.getBalanceAcc());
                        ldl.setBalanceSubacc(result.getSubaccBalanceTotal().get(ldl.getSubaccName()));
                    }
                    result.getItsLines().add(ldl);
                } while (recordSet.moveToNext());
            }
        }
        for (String subaccName : result.getSubaccDebitTotal().keySet()) {
            if (ledgerPrevious.getLinesMap().get(subaccName) != null) continue;
            ledgerPrevious.getLinesMap().put(subaccName, new LedgerPreviousLine());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = SrvLedger.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvLedger.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvBalance getSrvBalance() {
        return this.srvBalance;
    }

    public final void setSrvBalance(ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
    }
}

